/*
* Copyright 2019 9ci Inc - Licensed under the Apache License, Version 2.0 (the "License")
* You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
*/
package nine.gradle

import groovy.transform.CompileStatic

import org.gradle.api.logging.Logger
import org.gradle.api.logging.Logging

@CompileStatic
class ShellRunner {
    private final static Logger LOG = Logging.getLogger(ShellRunner)

    static String runSh(String strList){
        //assert ( strList instanceof String || ( strList instanceof List && strList.each{ it instanceof String } ) )
        LOG.lifecycle(strList)
        def proc = ['sh', '-c', strList].execute()
        def outputStream = new StringBuffer()
        def errorStream = new StringBuffer()
        proc.waitForProcessOutput(outputStream, errorStream)

        String combinedResult = outputStream + errorStream

        if (proc.exitValue()) {
            LOG.error "[SH ERRORS] IN COMMAND:\n $strList"
            LOG.error "[SH ERRORS] $errorStream"
        } else {
            LOG.lifecycle "[SH INFO] $combinedResult"
            //if(outputStream) logger.lifecycle "[INFO] $outputStream"
            if(errorStream) LOG.lifecycle "[SH INFO E] $errorStream"
        }
        assert !proc.exitValue()
        return combinedResult
    }
}
