/*
* Copyright 2019 9ci Inc - Licensed under the Apache License, Version 2.0 (the "License")
* You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
*/
package nine.gradle

import groovy.transform.CompileStatic

import org.gradle.api.Project
import org.gradle.api.logging.Logger
import org.gradle.api.logging.Logging

@CompileStatic
class NineDbExtension {
    private final static Logger LOG = Logging.getLogger(NineDbPlugin)

    String cloneBaseDir
    String backupsBranch = 'backups/9.9.x'
    String cloneDir
    String testDbName = "rcm_9ci_test"

    String mssqlBakFile
    String mssqlDockerName = "mssql-9db"
    String mssqlSaPassword = '123Foobar'
    String mssqlDockerExec = "docker exec -it $mssqlDockerName"

    String mysqlBakFile
    String mysqlDockerName = "mysql-9db"
    String mysqlPassword = '123Foobar'

    NineDbExtension(Project project) {
        cloneBaseDir = 'build' //project.buildDir
        cloneDir = "$cloneBaseDir/nine-db"
        mssqlBakFile = "$cloneDir/sql-server/${testDbName}.bak"
        mysqlBakFile = "$cloneDir/mysql/${testDbName}.sql"
    }
}
