/*
* Copyright 2019 9ci Inc - Licensed under the Apache License, Version 2.0 (the "License")
* You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
*/
package nine.gradle

import groovy.transform.CompileDynamic
import groovy.transform.CompileStatic

import org.gradle.api.GradleException
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.artifacts.dsl.RepositoryHandler
import org.gradle.api.logging.Logger
import org.gradle.api.logging.Logging

@CompileStatic
class DefaultsPlugin implements Plugin<Project> {
    private final static Logger LOG = Logging.getLogger(DefaultsPlugin)


    void apply(Project project) {
        if (project.rootProject != project) {
            throw new GradleException('yakworks.defaults must only be applied to the root project')
        }
        project.allprojects { Project prj ->
            prj.plugins.withId('java') {
                addDefaultRepos(prj)
            }
        }
        // project.plugins.apply(NineDbPlugin)
    }

    @CompileDynamic
    void addJavaCompat(Project prj) {
        prj.allprojects {
            sourceCompatibility = 1.8
            targetCompatibility = 1.8
        }
    }

    /**
     * adds the default maven repos
     */
    @CompileDynamic
    void addDefaultRepos(Project prj) {
        //add our default repositories to search.
        RepositoryHandler rh = prj.repositories
        ['grails-plugins', 'snapshots'].each{ repo ->
            rh.maven {
                url "http://repo.9ci.com/${repo}"
                credentials {
                    username prj.config.maven.user
                    password prj.config.maven.key
                }
                allowInsecureProtocol = true
            }
        }
    }

}
