/*
 * Decompiled with CFR 0.152.
 */
package yakworks.api;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yakworks.api.Result;
import yakworks.message.MsgServiceRegistry;
import yakworks.message.spi.MsgService;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0004J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0007R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lyakworks/api/ResultSupport;", "", "()V", "acceptedTypes", "", "Lkotlin/reflect/KClass;", "", "getAcceptedTypes", "()Ljava/util/List;", "getMessage", "", "msgService", "Lyakworks/message/spi/MsgService;", "result", "Lyakworks/api/Result;", "getTitle", "isBasicType", "", "value", "toMap", "", "res", "api-messages"})
public final class ResultSupport {
    @NotNull
    public static final ResultSupport INSTANCE = new ResultSupport();
    @NotNull
    private static final List<KClass<? extends Comparable<?>>> acceptedTypes;

    private ResultSupport() {
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> toMap(@NotNull Result res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Map hmap = new LinkedHashMap();
        hmap.put("ok", res.getOk());
        hmap.put("status", res.getStatus().getCode());
        hmap.put("code", res.getCode());
        hmap.put("title", INSTANCE.getTitle(res));
        Object payload = res.getPayload();
        if (payload != null) {
            Class<?> payloadClass = payload.getClass();
            if (INSTANCE.isBasicType(Reflection.getOrCreateKotlinClass(payload.getClass()), acceptedTypes) || Map.class.isAssignableFrom(payloadClass) || Collection.class.isAssignableFrom(payloadClass)) {
                hmap.put("payload", res.getPayload());
            }
        }
        return hmap;
    }

    @Nullable
    public final String getTitle(@NotNull Result result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String title = result.getTitle();
        if (MsgServiceRegistry.getService() != null) {
            MsgService msgService = MsgServiceRegistry.getService();
            Intrinsics.checkNotNull((Object)msgService);
            title = this.getMessage(msgService, result);
        }
        return title;
    }

    @NotNull
    public final List<KClass<? extends Comparable<?>>> getAcceptedTypes() {
        return acceptedTypes;
    }

    public final boolean isBasicType(@NotNull Object value, @NotNull List<? extends KClass<? extends Comparable<?>>> acceptedTypes) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(acceptedTypes, (String)"acceptedTypes");
        return CollectionsKt.contains((Iterable)acceptedTypes, (Object)Reflection.getOrCreateKotlinClass(value.getClass()));
    }

    @Nullable
    public final String getMessage(@NotNull MsgService msgService, @NotNull Result result) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)msgService, (String)"msgService");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String message = null;
        if (result.getMsg() != null) {
            message = msgService.get(result.getMsg());
        }
        if (((charSequence = (CharSequence)message) == null || charSequence.length() == 0) && !((charSequence = (CharSequence)result.getTitle()) == null || charSequence.length() == 0)) {
            message = result.getTitle();
        }
        return message;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Character.class), Reflection.getOrCreateKotlinClass(Character.class)};
        acceptedTypes = CollectionsKt.listOf((Object[])objectArray);
    }
}

