/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.gorm;

import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import yakworks.api.Result;
import yakworks.api.problem.Problem;
import yakworks.message.DefaultMsgKey;
import yakworks.message.Msg;
import yakworks.security.gorm.model.AppUser;
import yakworks.security.gorm.model.SecPasswordHistory;
import yakworks.security.services.PasswordValidator;

public class AppUserPasswordValidator
extends PasswordValidator {
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public AppUserPasswordValidator() {
    }

    public Result validate(Serializable userId, String pass) {
        Result res = super.validate(pass);
        Boolean bl = res.getOk();
        if (!(bl == null ? false : bl)) {
            return res;
        }
        if (this.passwordExistInHistory(userId, pass)) {
            DefaultMsgKey msgKey = Msg.key((String)"security.validation.password.existsinhistory", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", this.getPasswordConfig().getHistoryLength()}));
            return Problem.of((String)"security.validation.password.error").addViolations(ScriptBytecodeAdapter.createList((Object[])new Object[]{msgKey}));
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    public boolean passwordExistInHistory(Serializable id, String password) {
        void var2_2;
        Reference id2 = new Reference((Object)id);
        Reference password2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        boolean bl = true;
        $transactionAttribute.setReadOnly(bl);
        String string = "yakworks.security.gorm.AppUserPasswordValidator.passwordExistInHistory";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _passwordExistInHistory_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference id;
            private /* synthetic */ Reference password;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _passwordExistInHistory_closure1(Object _outerInstance, Object _thisObject, Reference id, Reference password) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.id = reference2 = id;
                this.password = reference = password;
            }

            public Boolean doCall(TransactionStatus transactionStatus) {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((AppUserPasswordValidator)((Object)this.getThisObject()))), (String)"$tt__appUserPasswordValidator_passwordExistInHistory", (Object)new Object[]{(Serializable)ScriptBytecodeAdapter.castToType((Object)this.id.get(), Serializable.class), ShortTypeHandling.castToString((Object)this.password.get()), transactionStatus}), Boolean.class);
            }

            @Generated
            public Boolean call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Serializable getId() {
                return (Serializable)ScriptBytecodeAdapter.castToType((Object)this.id.get(), Serializable.class);
            }

            @Generated
            public String getPassword() {
                return ShortTypeHandling.castToString((Object)this.password.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _passwordExistInHistory_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new _passwordExistInHistory_closure1((Object)this, (Object)this, id2, password2)));
    }

    public boolean isPasswordExpired(Serializable id) {
        AppUser user = AppUser.get(id);
        if (user.getPasswordHash() == null) {
            return false;
        }
        Boolean bl = user.getPasswordExpired();
        if (bl == null ? false : bl) {
            return true;
        }
        if (this.getPasswordConfig().getExpiryEnabled()) {
            if (user.getPasswordChangedDate() == null) {
                return true;
            }
            LocalDateTime expiresOnDate = user.getPasswordChangedDate().plusDays(this.getPasswordConfig().getPasswordExpireDays());
            if (ScriptBytecodeAdapter.compareLessThan((Object)expiresOnDate.toLocalDate(), (Object)LocalDate.now())) {
                return true;
            }
        }
        return false;
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(AppUserPasswordValidator.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(AppUserPasswordValidator.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected boolean $tt__appUserPasswordValidator_passwordExistInHistory(Serializable id, String password, TransactionStatus transactionStatus) {
        Reference password2 = new Reference((Object)password);
        if (this.getPasswordConfig().getHistoryEnabled()) {
            List passwordHistoryList = SecPasswordHistory.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"userId", id})).list();
            public final class __tt__appUserPasswordValidator_passwordExistInHistory_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference password;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __tt__appUserPasswordValidator_passwordExistInHistory_closure2(Object _outerInstance, Object _thisObject, Reference password) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.password = reference = password;
                }

                public Boolean doCall(Object it) {
                    return ((AppUserPasswordValidator)((PasswordValidator)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PasswordValidator.class))).getPasswordEncoder().matches((CharSequence)ShortTypeHandling.castToString((Object)this.password.get()), ((SecPasswordHistory)it).getPassword());
                }

                @Generated
                public String getPassword() {
                    return ShortTypeHandling.castToString((Object)this.password.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Boolean doCall() {
                    CallSite[] callSiteArray = __tt__appUserPasswordValidator_passwordExistInHistory_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __tt__appUserPasswordValidator_passwordExistInHistory_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(__tt__appUserPasswordValidator_passwordExistInHistory_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __tt__appUserPasswordValidator_passwordExistInHistory_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return DefaultGroovyMethods.any((Iterable)passwordHistoryList, (Closure)new __tt__appUserPasswordValidator_passwordExistInHistory_closure2((Object)this, (Object)this, password2));
        }
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AppUserPasswordValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }
}

