/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.gorm.model;

import gorm.tools.repository.GormRepository;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.model.LongIdGormRepo;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yakworks.api.problem.data.DataProblem;
import yakworks.security.PasswordConfig;
import yakworks.security.gorm.model.SecPasswordHistory;

@GormRepository
public class SecPasswordHistoryRepo
extends LongIdGormRepo<SecPasswordHistory> {
    @Inject
    private PasswordConfig passwordConfig;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public SecPasswordHistoryRepo() {
    }

    @Transactional
    public SecPasswordHistory create(Serializable uid, String pwdHash) {
        if (!this.passwordConfig.getHistoryEnabled()) {
            throw (Throwable)DataProblem.ex((String)"Password history is not enabled");
        }
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)SecPasswordHistory.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"userId", uid})).count(), (Object)this.passwordConfig.getHistoryLength())) {
            SecPasswordHistory lastRecord = (SecPasswordHistory)ScriptBytecodeAdapter.castToType((Object)SecPasswordHistory.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"userId", uid, "sort", "dateCreated", "order", "asc"})).get(), SecPasswordHistory.class);
            lastRecord.delete();
        }
        SecPasswordHistory secPasswordHistory = new SecPasswordHistory();
        Long l = (Long)ScriptBytecodeAdapter.asType((Object)uid, Long.class);
        secPasswordHistory.setUserId(l);
        String string = pwdHash;
        secPasswordHistory.setPassword(string);
        LocalDateTime localDateTime = LocalDateTime.now();
        secPasswordHistory.setDateCreated(localDateTime);
        SecPasswordHistory passwordHistory = secPasswordHistory;
        return passwordHistory.persist(PersistArgs.of((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"insert", true})));
    }

    public Collection<SecPasswordHistory> findAllByUser(Serializable uid) {
        return SecPasswordHistory.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"userId", uid})).list();
    }

    public SecPasswordHistory update(Map data, PersistArgs args) {
        throw (Throwable)new UnsupportedOperationException("Updating SecPasswordHistory is not allowed");
    }

    public void removeById(Serializable id) {
        throw (Throwable)new UnsupportedOperationException("Deleting SecPasswordHistory is not allowed");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SecPasswordHistoryRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.security.gorm.model.SecPasswordHistoryRepo");
    }

    @Generated
    public PasswordConfig getPasswordConfig() {
        return this.passwordConfig;
    }

    @Generated
    public void setPasswordConfig(PasswordConfig passwordConfig) {
        this.passwordConfig = passwordConfig;
    }
}

