/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.gorm.model;

import gorm.tools.databinding.BindAction;
import gorm.tools.mango.jpql.KeyExistsQuery;
import gorm.tools.model.Persistable;
import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.GormRepository;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.BeforePersistEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.LongIdGormRepo;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.validation.Errors;
import yakworks.api.Result;
import yakworks.api.problem.Problem;
import yakworks.api.problem.data.DataProblem;
import yakworks.api.problem.data.DataProblemCodes;
import yakworks.commons.lang.Validate;
import yakworks.security.PasswordConfig;
import yakworks.security.gorm.model.AppUser;
import yakworks.security.gorm.model.SecPasswordHistory;
import yakworks.security.gorm.model.SecRole;
import yakworks.security.gorm.model.SecRolePermission;
import yakworks.security.gorm.model.SecRoleUser;
import yakworks.security.services.PasswordValidator;

@GormRepository
public class AppUserRepo
extends LongIdGormRepo<AppUser> {
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private PasswordConfig passwordConfig;
    @Autowired
    private PasswordValidator passwordValidator;
    private KeyExistsQuery usernameExistsQuery;
    private String idGeneratorKey;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public AppUserRepo() {
        String string;
        this.idGeneratorKey = string = "Users.id";
    }

    public void bindAndCreate(AppUser user, Map data, PersistArgs args) {
        String pwd = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"password"));
        if (DefaultTypeTransformation.booleanUnbox((Object)pwd)) {
            String string = pwd;
            user.setPassword(string);
        }
        this.bindAndSave(user, data, BindAction.Create, args);
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"roles"))) {
            this.setUserRoles((Long)ScriptBytecodeAdapter.castToType((Object)user.getId(), Long.class), (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"roles"), List.class));
        }
    }

    public AppUser doUpdate(Map data, PersistArgs args) {
        AppUser user = (AppUser)ScriptBytecodeAdapter.castToType((Object)super.doUpdate(data, args), AppUser.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"roles"))) {
            this.setUserRoles((Long)ScriptBytecodeAdapter.castToType((Object)user.getId(), Long.class), (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"roles"), List.class));
        }
        return user;
    }

    @RepoListener
    public void beforeRemove(AppUser user, BeforeRemoveEvent be) {
        SecRoleUser.removeAll(user);
    }

    @RepoListener
    public void beforeValidate(AppUser user, Errors errors) {
        if (user.isNew()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)user.getUsername())) {
                String string = this.parseName(user.getEmail());
                user.setUsername(string);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)user.getName())) {
                String string = this.parseName(user.getUsername());
                user.setName(string);
            }
        }
    }

    @RepoListener
    public void beforePersist(AppUser user, BeforePersistEvent e) {
        if (user.isNew()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)user.getId())) {
                this.generateId((Persistable)user);
            }
            if (this.exists(user.getUsername())) {
                throw (Throwable)((DataProblem)DataProblemCodes.UniqueConstraint.get().detail(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{user.getUsername()}, new String[]{"Violates unique constraint [username: ", "]"})))).toException();
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)user.getPassword())) {
            this.updatePassword(user, user.getPassword());
        }
    }

    public boolean exists(String username) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.usernameExistsQuery)) {
            KeyExistsQuery keyExistsQuery;
            this.usernameExistsQuery = keyExistsQuery = KeyExistsQuery.of((Class)this.getEntityClass()).keyName("username");
        }
        return this.usernameExistsQuery.exists((Serializable)((Object)username));
    }

    @RepoListener
    public void afterBind(AppUser user, Map p, AfterBindEvent ae) {
        this.checkPasswordChange(user, (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)p, (Object)"newPassword"), String.class), (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)p, (Object)"repassword"), String.class));
    }

    public SecRoleUser addUserRole(AppUser user, String roleCode, boolean flushAfterPersist) {
        SecRoleUser sru = SecRoleUser.create(user, SecRole.getByCode(roleCode), flushAfterPersist);
        return sru;
    }

    private void checkPasswordChange(AppUser user, String newPassword, String repassword) {
        String string = newPassword;
        if (!DefaultTypeTransformation.booleanUnbox((Object)(string != null ? string.trim() : null))) {
            return;
        }
        this.isSamePass(newPassword, repassword, user);
        String string2 = newPassword;
        user.setPassword(string2);
    }

    public String parseName(String name) {
        if (name.indexOf("@") != -1) {
            return name.substring(0, name.indexOf("@"));
        }
        return name;
    }

    public String encodePassword(String pass) {
        return this.passwordEncoder.encode((CharSequence)pass);
    }

    public void isSamePass(String pass, String rePass, AppUser user) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)pass.trim(), (Object)rePass.trim())) {
            throw (Throwable)((ValidationProblem)ValidationProblem.of((String)"password.mismatch").detail("The passwords you entered do not match")).entity((Object)user).toException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void setUserRoles(Long userId, List rolesId) {
        void var2_2;
        Reference userId2 = new Reference((Object)userId);
        Reference rolesId2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.security.gorm.model.AppUserRepo.setUserRoles";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _setUserRoles_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference userId;
            private /* synthetic */ Reference rolesId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setUserRoles_closure1(Object _outerInstance, Object _thisObject, Reference userId, Reference rolesId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.userId = reference2 = userId;
                this.rolesId = reference = rolesId;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AppUserRepo)((Object)this.getThisObject()))), (String)"$tt__setUserRoles", (Object)new Object[]{(Long)ScriptBytecodeAdapter.castToType((Object)this.userId.get(), Long.class), (List)ScriptBytecodeAdapter.castToType((Object)this.rolesId.get(), List.class), transactionStatus});
            }

            @Generated
            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Long getUserId() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.userId.get(), Long.class);
            }

            @Generated
            public List getRolesId() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.rolesId.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUserRoles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        $transactionTemplate.execute((Closure)new _setUserRoles_closure1((Object)this, (Object)this, userId2, rolesId2));
    }

    public void updatePassword(AppUser user, String password) {
        Validate.notEmpty((Object)password);
        if (this.passwordEncoder.matches((CharSequence)password, user.getPasswordHash())) {
            return;
        }
        String hashed = this.encodePassword(password);
        Result valid = null;
        valid = user.isNew() ? this.passwordValidator.validate(password) : this.passwordValidator.validate(user.getId(), password);
        Boolean bl = valid.getOk();
        if (bl == null ? false : bl) {
            String string = hashed;
            user.setPasswordHash(string);
            LocalDateTime localDateTime = LocalDateTime.now();
            user.setPasswordChangedDate(localDateTime);
            boolean bl2 = false;
            user.setPasswordExpired(bl2);
            if (this.passwordConfig.getHistoryEnabled()) {
                SecPasswordHistory.getRepo().create(user.getId(), user.getPasswordHash());
            }
        } else {
            ValidationProblem problem = ValidationProblem.ofEntity((Object)user);
            problem.violations(((Problem)ScriptBytecodeAdapter.castToType((Object)valid, Problem.class)).getViolations());
            throw (Throwable)problem.toException();
        }
    }

    @Transactional(readOnly=true)
    public Set<String> getRoles(AppUser user) {
        Reference user2 = new Reference((Object)user);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        boolean bl = true;
        $transactionAttribute.setReadOnly(bl);
        String string = "yakworks.security.gorm.model.AppUserRepo.getRoles";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _getRoles_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference user;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getRoles_closure2(Object _outerInstance, Object _thisObject, Reference user) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.user = reference = user;
            }

            public Set doCall(TransactionStatus transactionStatus) {
                return (Set)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((AppUserRepo)((Object)this.getThisObject()))), (String)"$tt__getRoles", (Object)new Object[]{(AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class), transactionStatus}), Set.class);
            }

            @Generated
            public Set call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public AppUser getUser() {
                return (AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRoles_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Set)$transactionTemplate.execute((Closure)new _getRoles_closure2((Object)this, (Object)this, user2));
    }

    @Transactional(readOnly=true)
    public Set getPermissions(AppUser user) {
        Reference user2 = new Reference((Object)user);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        boolean bl = true;
        $transactionAttribute.setReadOnly(bl);
        String string = "yakworks.security.gorm.model.AppUserRepo.getPermissions";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _getPermissions_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference user;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getPermissions_closure3(Object _outerInstance, Object _thisObject, Reference user) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.user = reference = user;
            }

            public Set doCall(TransactionStatus transactionStatus) {
                return (Set)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((AppUserRepo)((Object)this.getThisObject()))), (String)"$tt__getPermissions", (Object)new Object[]{(AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class), transactionStatus}), Set.class);
            }

            @Generated
            public Set call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public AppUser getUser() {
                return (AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPermissions_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Set)$transactionTemplate.execute((Closure)new _getPermissions_closure3((Object)this, (Object)this, user2));
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(AppUserRepo.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(AppUserRepo.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected void $tt__setUserRoles(Long userId, List rolesId, TransactionStatus transactionStatus) {
        List list;
        public final class __tt__setUserRoles_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __tt__setUserRoles_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Long doCall(Object it) {
                return it instanceof Map ? (Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)it, (String)"id"), Long.class) : (Long)ScriptBytecodeAdapter.castToType((Object)SecRole.getByCode(ShortTypeHandling.castToString((Object)it)).getId(), Long.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Long doCall() {
                CallSite[] callSiteArray = __tt__setUserRoles_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__setUserRoles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(__tt__setUserRoles_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __tt__setUserRoles_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List incomeRoles = DefaultGroovyMethods.collect((Iterable)rolesId, (Closure)new __tt__setUserRoles_closure4((Object)this, (Object)this));
        public final class __tt__setUserRoles_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __tt__setUserRoles_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Long doCall(Object it) {
                return ((SecRoleUser)it).getRole().getId();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Long doCall() {
                CallSite[] callSiteArray = __tt__setUserRoles_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__setUserRoles_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(__tt__setUserRoles_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __tt__setUserRoles_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List existingRoles = DefaultGroovyMethods.collect(SecRoleUser.getByUser(userId), (Closure)new __tt__setUserRoles_closure5((Object)this, (Object)this));
        List deleting = null;
        List addition = null;
        Reference user = new Reference((Object)AppUser.get(userId));
        if (DefaultTypeTransformation.booleanUnbox((Object)existingRoles) && DefaultTypeTransformation.booleanUnbox((Object)incomeRoles)) {
            deleting = DefaultGroovyMethods.minus((List)existingRoles, (Collection)incomeRoles);
            addition = DefaultGroovyMethods.minus((List)incomeRoles, (Collection)existingRoles);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)incomeRoles)) {
            addition = incomeRoles;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)existingRoles)) {
            deleting = existingRoles;
        }
        List list2 = deleting;
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)(list2 != null ? Integer.valueOf(list2.size()) : null), (Object)0)) {
            public final class __tt__setUserRoles_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference user;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __tt__setUserRoles_closure6(Object _outerInstance, Object _thisObject, Reference user) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.user = reference = user;
                }

                public Object doCall(Long id) {
                    SecRoleUser.remove(SecRole.load(id), (AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class));
                    return null;
                }

                @Generated
                public Object call(Long id) {
                    return this.doCall(id);
                }

                @Generated
                public AppUser getUser() {
                    return (AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __tt__setUserRoles_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)deleting, (Closure)new __tt__setUserRoles_closure6((Object)this, (Object)this, user));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)((list = addition) != null ? Integer.valueOf(list.size()) : null), (Object)0)) {
            public final class __tt__setUserRoles_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference user;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __tt__setUserRoles_closure7(Object _outerInstance, Object _thisObject, Reference user) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.user = reference = user;
                }

                public SecRoleUser doCall(Long id) {
                    return SecRoleUser.create((AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class), SecRole.load(id));
                }

                @Generated
                public SecRoleUser call(Long id) {
                    return this.doCall(id);
                }

                @Generated
                public AppUser getUser() {
                    return (AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __tt__setUserRoles_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)addition, (Closure)new __tt__setUserRoles_closure7((Object)this, (Object)this, user));
        }
    }

    protected Set $tt__getRoles(AppUser user, TransactionStatus transactionStatus) {
        List res = SecRoleUser.executeQuery((CharSequence)"select distinct role.code from SecRoleUser where user.id = :uid", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uid", user.getId()}));
        return (Set)ScriptBytecodeAdapter.asType((Object)res, Set.class);
    }

    protected Set $tt__getPermissions(AppUser user, TransactionStatus transactionStatus) {
        return (Set)ScriptBytecodeAdapter.asType((Object)SecRolePermission.executeQuery((CharSequence)"\n              select distinct p.permission\n                    from SecRolePermission p\n                    join p.role r\n                    join SecRoleUser sru on sru.role = r\n                    join sru.user u\n                    where u.id = :uid\n            ", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uid", user.getId()})), Set.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AppUserRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Generated
    public PasswordConfig getPasswordConfig() {
        return this.passwordConfig;
    }

    @Generated
    public void setPasswordConfig(PasswordConfig passwordConfig) {
        this.passwordConfig = passwordConfig;
    }

    @Generated
    public PasswordValidator getPasswordValidator() {
        return this.passwordValidator;
    }

    @Generated
    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    @Generated
    public KeyExistsQuery getUsernameExistsQuery() {
        return this.usernameExistsQuery;
    }

    @Generated
    public void setUsernameExistsQuery(KeyExistsQuery keyExistsQuery) {
        this.usernameExistsQuery = keyExistsQuery;
    }

    @Generated
    public String getIdGeneratorKey() {
        return this.idGeneratorKey;
    }

    @Generated
    public void setIdGeneratorKey(String string) {
        this.idGeneratorKey = string;
    }
}

