/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.spring;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import yakworks.security.spring.token.JwtProperties;
import yakworks.security.spring.token.TokenController;
import yakworks.security.spring.token.generator.JwtTokenExchanger;
import yakworks.security.spring.token.generator.JwtTokenGenerator;

@Configuration
@Lazy
@ConditionalOnClass(value={OAuth2Token.class})
@EnableConfigurationProperties(value={JwtProperties.class})
public class JwtConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TokenController tokenController() {
        return new TokenController();
    }

    @Bean
    @ConditionalOnMissingBean
    JWTClaimsSetAwareJWSKeySelector claimsSetKeySelector(JwtProperties jwtProperties) {
        return (header, claimsSet, context) -> {
            Collection<JwtProperties.Issuer> issuers = jwtProperties.getIssuers().values();
            String iss = claimsSet.getIssuer();
            if (iss != null) {
                JwtProperties.Issuer issConfig = issuers.stream().filter(issuer -> iss.equals(issuer.getIss())).findAny().orElse(null);
                return Collections.singletonList(issConfig.getKeyPair().getPublic());
            }
            return Collections.singletonList(jwtProperties.getDefaultIssuer().getKeyPair().getPublic());
        };
    }

    @Bean
    JWTProcessor jwtProcessor(JWTClaimsSetAwareJWSKeySelector claimsSetKeySelector) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWTClaimsSetAwareJWSKeySelector(claimsSetKeySelector);
        return jwtProcessor;
    }

    @Bean
    JwtDecoder jwtDecoder(JWTProcessor jwtProcessor) {
        NimbusJwtDecoder decoder = new NimbusJwtDecoder(jwtProcessor);
        DelegatingOAuth2TokenValidator validator = new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{JwtValidators.createDefault()});
        decoder.setJwtValidator((OAuth2TokenValidator)validator);
        return decoder;
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtEncoder jwtEncoder(JwtProperties jwtProperties) {
        JwtProperties.Issuer issuer = jwtProperties.getDefaultIssuer();
        KeyPair keyPair = issuer.getKeyPair();
        Object jwk = issuer.isEC() ? new ECKey.Builder(Curve.P_256, (ECPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).build() : new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).build();
        ImmutableJWKSet jwks = new ImmutableJWKSet(new JWKSet((JWK)jwk));
        NimbusJwtEncoder encoder = new NimbusJwtEncoder((JWKSource)jwks);
        return encoder;
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtTokenGenerator tokenGenerator() {
        return new JwtTokenGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtTokenExchanger jwtTokenExchanger() {
        return new JwtTokenExchanger();
    }
}

