/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.services;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import yakworks.api.Result;
import yakworks.api.problem.Problem;
import yakworks.message.Msg;

public class PasswordValidator
implements GroovyObject {
    @Inject
    private PasswordEncoder passwordEncoder;
    @Value(value="${yakworks.security.password.expireDays:90}")
    private int passwordExpireDays;
    @Value(value="${yakworks.security.password.expireEnabled:false}")
    private boolean passwordExpiryEnabled;
    @Value(value="${yakworks.security.password.warnDays:30}")
    private int passwordWarnDays;
    @Value(value="${yakworks.security.password.minLength:4}")
    private Integer passwordMinLength;
    @Value(value="${yakworks.security.password.mustContainNumbers:false}")
    private boolean passwordMustContainNumbers;
    @Value(value="${yakworks.security.password.mustContainSymbols:false}")
    private boolean passwordMustContainSymbols;
    @Value(value="${yakworks.security.password.mustContainUpperaseLetter:false}")
    private boolean passwordMustContainUpperaseLetter;
    @Value(value="${yakworks.security.password.password.mustContainLowercaseLetter:false}")
    private boolean passwordMustContainLowercaseLetter;
    @Value(value="${yakworks.security.password.historyEnabled:false}")
    private boolean passwordHistoryEnabled;
    @Value(value="${yakworks.security.password.historyLength:4}")
    private int passwordHistoryLength;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PasswordValidator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Result validate(String pass, String passConfirm) {
        List problemKeys = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (!DefaultTypeTransformation.booleanUnbox((Object)pass) || ScriptBytecodeAdapter.compareLessThan((Object)pass.length(), (Object)this.passwordMinLength)) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)Msg.key((String)"security.validation.password.minlength", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", this.passwordMinLength})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)passConfirm, (Object)pass)) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)Msg.key((String)"security.validation.password.match"));
        }
        if (this.passwordMustContainLowercaseLetter && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*[a-z].*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)Msg.key((String)"security.validation.password.mustcontain.lowercase"));
        }
        if (this.passwordMustContainUpperaseLetter && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*[A-Z].*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)Msg.key((String)"security.validation.password.mustcontain.uppercase"));
        }
        if (this.passwordMustContainNumbers && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*[0-9].*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)Msg.key((String)"security.validation.password.mustcontain.numbers"));
        }
        if (this.passwordMustContainSymbols && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*\\W.*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)Msg.key((String)"security.validation.password.mustcontain.symbol"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)problemKeys)) {
            return Problem.of((String)"security.validation.password.error").addViolations(problemKeys);
        }
        return Result.OK();
    }

    public boolean passwordExistInHistory(Serializable userId, String password) {
        throw (Throwable)new UnsupportedOperationException("Not Implemented");
    }

    public boolean isPasswordExpired(Serializable id) {
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PasswordValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Generated
    public int getPasswordExpireDays() {
        return this.passwordExpireDays;
    }

    @Generated
    public void setPasswordExpireDays(int n) {
        this.passwordExpireDays = n;
    }

    @Generated
    public boolean getPasswordExpiryEnabled() {
        return this.passwordExpiryEnabled;
    }

    @Generated
    public boolean isPasswordExpiryEnabled() {
        return this.passwordExpiryEnabled;
    }

    @Generated
    public void setPasswordExpiryEnabled(boolean bl) {
        this.passwordExpiryEnabled = bl;
    }

    @Generated
    public int getPasswordWarnDays() {
        return this.passwordWarnDays;
    }

    @Generated
    public void setPasswordWarnDays(int n) {
        this.passwordWarnDays = n;
    }

    @Generated
    public Integer getPasswordMinLength() {
        return this.passwordMinLength;
    }

    @Generated
    public void setPasswordMinLength(Integer n) {
        this.passwordMinLength = n;
    }

    @Generated
    public boolean getPasswordMustContainNumbers() {
        return this.passwordMustContainNumbers;
    }

    @Generated
    public boolean isPasswordMustContainNumbers() {
        return this.passwordMustContainNumbers;
    }

    @Generated
    public void setPasswordMustContainNumbers(boolean bl) {
        this.passwordMustContainNumbers = bl;
    }

    @Generated
    public boolean getPasswordMustContainSymbols() {
        return this.passwordMustContainSymbols;
    }

    @Generated
    public boolean isPasswordMustContainSymbols() {
        return this.passwordMustContainSymbols;
    }

    @Generated
    public void setPasswordMustContainSymbols(boolean bl) {
        this.passwordMustContainSymbols = bl;
    }

    @Generated
    public boolean getPasswordMustContainUpperaseLetter() {
        return this.passwordMustContainUpperaseLetter;
    }

    @Generated
    public boolean isPasswordMustContainUpperaseLetter() {
        return this.passwordMustContainUpperaseLetter;
    }

    @Generated
    public void setPasswordMustContainUpperaseLetter(boolean bl) {
        this.passwordMustContainUpperaseLetter = bl;
    }

    @Generated
    public boolean getPasswordMustContainLowercaseLetter() {
        return this.passwordMustContainLowercaseLetter;
    }

    @Generated
    public boolean isPasswordMustContainLowercaseLetter() {
        return this.passwordMustContainLowercaseLetter;
    }

    @Generated
    public void setPasswordMustContainLowercaseLetter(boolean bl) {
        this.passwordMustContainLowercaseLetter = bl;
    }

    @Generated
    public boolean getPasswordHistoryEnabled() {
        return this.passwordHistoryEnabled;
    }

    @Generated
    public boolean isPasswordHistoryEnabled() {
        return this.passwordHistoryEnabled;
    }

    @Generated
    public void setPasswordHistoryEnabled(boolean bl) {
        this.passwordHistoryEnabled = bl;
    }

    @Generated
    public int getPasswordHistoryLength() {
        return this.passwordHistoryLength;
    }

    @Generated
    public void setPasswordHistoryLength(int n) {
        this.passwordHistoryLength = n;
    }
}

