/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.spring.token;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.core.io.Resource;

public class PemUtils
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PemUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static KeyPair parseKeyPair(Resource resource) {
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(resource.getInputStream()));
        PEMKeyPair pemKeyPair = (PEMKeyPair)ScriptBytecodeAdapter.castToType((Object)pemParser.readObject(), PEMKeyPair.class);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        KeyPair keyPair = converter.getKeyPair(pemKeyPair);
        pemParser.close();
        return keyPair;
    }

    private static byte[] parsePEMFile(Resource resource) throws IOException {
        if (!resource.exists()) {
            throw (Throwable)new FileNotFoundException(String.format("The file '%s' doesn't exist.", resource.getFilename()));
        }
        PemReader reader = new PemReader((Reader)new InputStreamReader(resource.getInputStream()));
        PemObject pemObject = reader.readPemObject();
        byte[] content = pemObject.getContent();
        reader.close();
        return content;
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algorithm) {
        PublicKey publicKey;
        PublicKey publicKey2 = null;
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        publicKey2 = publicKey = kf.generatePublic(keySpec);
        return publicKey2;
    }

    private static PrivateKey getPrivateKey(byte[] keyBytes, String algorithm) {
        PrivateKey privateKey;
        PrivateKey privateKey2 = null;
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        privateKey2 = privateKey = kf.generatePrivate(keySpec);
        return privateKey2;
    }

    public static PublicKey readPublicKeyFromFile(Resource resource, String algorithm) throws IOException {
        byte[] bytes = PemUtils.parsePEMFile(resource);
        return PemUtils.getPublicKey(bytes, algorithm);
    }

    public static PrivateKey readPrivateKeyFromFile(Resource resource, String algorithm) throws IOException {
        byte[] bytes = PemUtils.parsePEMFile(resource);
        return PemUtils.getPrivateKey(bytes, algorithm);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PemUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

