/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.spring.token.store;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import yakworks.security.spring.token.store.TokenStore;

public class OpaqueTokenStoreAuthProvider
implements AuthenticationProvider,
GroovyObject {
    public static final String AUTHORITY_PREFIX = "SCOPE_";
    private TokenStore tokenStore;
    private String tokenPrefix;
    private OpaqueTokenAuthenticationProvider opaqueTokenAuthenticationProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public OpaqueTokenStoreAuthProvider(TokenStore tokenStore) {
        OpaqueTokenAuthenticationProvider opaqueTokenAuthenticationProvider;
        TokenStore tokenStore2;
        MetaClass metaClass;
        String string;
        this.tokenPrefix = string = "opq_";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.tokenStore = tokenStore2 = tokenStore;
        this.opaqueTokenAuthenticationProvider = opaqueTokenAuthenticationProvider = new OpaqueTokenAuthenticationProvider(this::introspect);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)ScriptBytecodeAdapter.castToType((Object)authentication, BearerTokenAuthenticationToken.class);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            BearerTokenAuthenticationToken bearerTokenAuthenticationToken = bearer;
            valueRecorder.record((Object)bearerTokenAuthenticationToken, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)bearerTokenAuthenticationToken)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert bearer", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        String token = bearer.getToken();
        if (token.startsWith(this.tokenPrefix)) {
            return this.opaqueTokenAuthenticationProvider.authenticate(authentication);
        }
        return (Authentication)ScriptBytecodeAdapter.castToType(null, Authentication.class);
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        UserDetails user = this.tokenStore.loadUserByToken(token);
        if (!DefaultTypeTransformation.booleanUnbox((Object)user)) {
            throw (Throwable)new BadOpaqueTokenException("Provided token isn't active");
        }
        return new DefaultOAuth2AuthenticatedPrincipal(user.getUsername(), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"login", user.getUsername(), "springUser", user}), null);
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OpaqueTokenStoreAuthProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    @Generated
    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    @Generated
    public String getTokenPrefix() {
        return this.tokenPrefix;
    }

    @Generated
    public void setTokenPrefix(String string) {
        this.tokenPrefix = string;
    }

    @Generated
    public OpaqueTokenAuthenticationProvider getOpaqueTokenAuthenticationProvider() {
        return this.opaqueTokenAuthenticationProvider;
    }

    @Generated
    public void setOpaqueTokenAuthenticationProvider(OpaqueTokenAuthenticationProvider opaqueTokenAuthenticationProvider) {
        this.opaqueTokenAuthenticationProvider = opaqueTokenAuthenticationProvider;
    }
}

