/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.spring.token;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.annotation.Nullable;
import java.beans.Transient;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import yakworks.api.ApiStatus;
import yakworks.api.GenericResult;
import yakworks.api.HttpStatus;
import yakworks.api.problem.GenericProblem;
import yakworks.api.problem.Problem;
import yakworks.api.problem.ProblemResult;
import yakworks.api.problem.UnexpectedProblem;
import yakworks.security.spring.token.TokenUtils;
import yakworks.security.spring.token.generator.JwtTokenExchanger;
import yakworks.security.spring.token.generator.JwtTokenGenerator;
import yakworks.security.spring.token.generator.StoreTokenGenerator;
import yakworks.security.user.CurrentUser;

@RestController
public class TokenController
implements GroovyObject {
    @Inject
    private JwtTokenGenerator jwtTokenGenerator;
    @Inject
    private JwtTokenExchanger jwtTokenExchanger;
    @Inject
    @Nullable
    private StoreTokenGenerator storeTokenGenerator;
    @Inject
    private CurrentUser currentUser;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public TokenController() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PostMapping(value={"/oauth/token.txt"})
    public String tokenTxt() {
        return ((Jwt)this.jwtTokenGenerator.generate()).getTokenValue();
    }

    @PostMapping(value={"/oauth/token"})
    public ResponseEntity<Map> token(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, String> params) {
        Map map;
        Map map2;
        Map body = null;
        String string = params == null ? null : params.get("grant_type");
        Boolean bl = string != null ? Boolean.valueOf(string.endsWith("token-exchange")) : null;
        body = (bl == null ? false : bl) ? (map2 = this.exchangeToken(params)) : (map = this.generateToken(request, response));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)body);
    }

    public Map generateToken(HttpServletRequest request, HttpServletResponse response) {
        Jwt token = (Jwt)ScriptBytecodeAdapter.castToType(this.jwtTokenGenerator.generate(), Jwt.class);
        Cookie cookie = TokenUtils.tokenCookie(request, (AbstractOAuth2Token)token);
        response.addCookie(cookie);
        Map body = TokenUtils.tokenToMap((AbstractOAuth2Token)token);
        return body;
    }

    public Map exchangeToken(Map<String, String> params) {
        String requested_subject = ShortTypeHandling.castToString((Object)params.get("requested_subject"));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = requested_subject;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert requested_subject", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Jwt token = this.jwtTokenExchanger.exchange(requested_subject);
        Map body = TokenUtils.tokenToMap((AbstractOAuth2Token)token);
        String string = requested_subject;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)body, (String)"sub");
        return body;
    }

    @GetMapping(value={"/oauth/token/callback"})
    public ResponseEntity<Map> callback(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, String> params) {
        return this.token(request, response, params);
    }

    @Deprecated
    @PostMapping(value={"/tokenLegacy"})
    public ResponseEntity<Map> tokenLegacy(HttpServletRequest request, HttpServletResponse response) {
        OAuth2AccessToken token = (OAuth2AccessToken)ScriptBytecodeAdapter.castToType(this.storeTokenGenerator.generate(), OAuth2AccessToken.class);
        Cookie cookie = TokenUtils.tokenCookie(request, (AbstractOAuth2Token)token);
        response.addCookie(cookie);
        Map body = TokenUtils.tokenToMap((AbstractOAuth2Token)token);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)body);
    }

    @GetMapping(value={"/validate"})
    public ResponseEntity<Map> validateToken(HttpServletRequest request, HttpServletResponse response) {
        Map body = this.currentUser.getUserMap();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)body);
    }

    @ExceptionHandler(value={Exception.class})
    public Object handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) {
        Object v0;
        GenericProblem problem = null;
        if (e instanceof UsernameNotFoundException) {
            GenericResult genericResult = ((ProblemResult)Problem.of((String)"user.notfound").status((ApiStatus)HttpStatus.NOT_FOUND)).detail(e.getMessage());
            problem = (GenericProblem)ScriptBytecodeAdapter.castToType((Object)genericResult, GenericProblem.class);
        } else {
            GenericResult genericResult = ((UnexpectedProblem)new UnexpectedProblem().cause((Throwable)e)).detail(e.getMessage());
            problem = (GenericProblem)ScriptBytecodeAdapter.castToType((Object)genericResult, GenericProblem.class);
        }
        if (log.isWarnEnabled()) {
            log.warn(e.getMessage());
            v0 = null;
        } else {
            v0 = null;
        }
        return problem.asMap();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TokenController.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.security.spring.token.TokenController");
    }

    @Generated
    public JwtTokenGenerator getJwtTokenGenerator() {
        return this.jwtTokenGenerator;
    }

    @Generated
    public void setJwtTokenGenerator(JwtTokenGenerator jwtTokenGenerator) {
        this.jwtTokenGenerator = jwtTokenGenerator;
    }

    @Generated
    public JwtTokenExchanger getJwtTokenExchanger() {
        return this.jwtTokenExchanger;
    }

    @Generated
    public void setJwtTokenExchanger(JwtTokenExchanger jwtTokenExchanger) {
        this.jwtTokenExchanger = jwtTokenExchanger;
    }

    @Generated
    public StoreTokenGenerator getStoreTokenGenerator() {
        return this.storeTokenGenerator;
    }

    @Generated
    public void setStoreTokenGenerator(StoreTokenGenerator storeTokenGenerator) {
        this.storeTokenGenerator = storeTokenGenerator;
    }

    @Generated
    public CurrentUser getCurrentUser() {
        return this.currentUser;
    }

    @Generated
    public void setCurrentUser(CurrentUser currentUser) {
        this.currentUser = currentUser;
    }
}

