/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.spring.token;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.ECGenParameterSpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;

public class TokenUtils
implements GroovyObject {
    public static String COOKIE_NAME;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public TokenUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static KeyPair generateRsaKey() {
        KeyPair keyPair = null;
        try {
            KeyPair keyPair2;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            keyPair = keyPair2 = keyPairGenerator.generateKeyPair();
        }
        catch (Exception ex) {
            throw (Throwable)new IllegalStateException(ex);
        }
        return keyPair;
    }

    public static KeyPair generateES256Key() {
        KeyPair keyPair = null;
        try {
            KeyPair keyPair2;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(new ECGenParameterSpec("secp256r1"));
            keyPair = keyPair2 = keyPairGenerator.generateKeyPair();
        }
        catch (Exception ex) {
            throw (Throwable)new IllegalStateException(ex);
        }
        return keyPair;
    }

    public static Cookie tokenCookie(HttpServletRequest request, AbstractOAuth2Token token) {
        Cookie tCookie = new Cookie(COOKIE_NAME, token.getTokenValue());
        int n = TokenUtils.getExpiresIn(token);
        tCookie.setMaxAge(n);
        String string = "/";
        tCookie.setPath(string);
        if (TokenUtils.isHttps(request)) {
            tCookie.setHttpOnly(true);
            tCookie.setSecure(true);
        }
        return tCookie;
    }

    public static boolean isHttps(HttpServletRequest request) {
        return request.getRequestURL().toString().startsWith("https");
    }

    public static int getExpiresIn(AbstractOAuth2Token token) {
        if (token.getExpiresAt() != null) {
            return DefaultGroovyMethods.toInteger((Number)ChronoUnit.SECONDS.between(Instant.now(), token.getExpiresAt()));
        }
        return -1;
    }

    public static Map tokenToMap(AbstractOAuth2Token token) {
        LinkedHashMap body = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"token_type", "Bearer", "access_token", token.getTokenValue(), "expires_in", TokenUtils.getExpiresIn(token)}), LinkedHashMap.class);
        return body;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TokenUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        COOKIE_NAME = string = "TOK";
    }
}

