/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class NameUtils
implements GroovyObject {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    public static final String DOLLAR_SEPARATOR;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public NameUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String toCamelCase(String text) {
        String string;
        public final class _toCamelCase_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toCamelCase_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(List<String> it) {
                return ((String)DefaultGroovyMethods.getAt(it, (int)2)).toUpperCase();
            }

            public Object call(List<String> it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toCamelCase_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        text = string = StringGroovyMethods.replaceAll((CharSequence)text.toLowerCase(), (CharSequence)"(_)([A-Za-z0-9])", (Closure)new _toCamelCase_closure1(NameUtils.class, NameUtils.class));
        return text;
    }

    public static String getSetterName(String propertyName) {
        String suffix = NameUtils.getSuffixForGetterOrSetter(propertyName);
        return StringGroovyMethods.plus((String)PROPERTY_SET_PREFIX, (CharSequence)suffix);
    }

    public static String getGetterName(String propertyName) {
        String suffix = NameUtils.getSuffixForGetterOrSetter(propertyName);
        return StringGroovyMethods.plus((String)PROPERTY_GET_PREFIX, (CharSequence)suffix);
    }

    public static String getSuffixForGetterOrSetter(String propertyName) {
        String suffix = null;
        if (propertyName.length() > 1 && Character.isLowerCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1))) {
            String string;
            suffix = string = propertyName;
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)}, new String[]{"", "", ""});
            suffix = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return suffix;
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (NameUtils.isBlank(logicalName)) {
            throw (Throwable)new IllegalArgumentException("Argument [logicalName] cannot be null or blank");
        }
        String className = StringGroovyMethods.plus((String)logicalName.substring(0, 1).toUpperCase(Locale.ENGLISH), (CharSequence)logicalName.substring(1));
        if (trailingName != null) {
            String string;
            className = string = StringGroovyMethods.plus((String)className, (CharSequence)trailingName);
        }
        return className;
    }

    public static String getFullClassName(Class cls) {
        String className = cls.getName();
        return NameUtils.getFullClassName(className);
    }

    public static String getFullClassName(String className) {
        int i = className.indexOf("$");
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)i, (Object)-1)) {
            String string;
            className = string = className.substring(0, i);
        }
        return className;
    }

    public static String getClassName(String logicalName) {
        return NameUtils.getClassName(logicalName, "");
    }

    public static String getClassName(Class clazz) {
        String sn = clazz.getSimpleName();
        if (sn.contains(DOLLAR_SEPARATOR)) {
            return clazz.getSuperclass().getName();
        }
        return clazz.getName();
    }

    public static String getClassNameRepresentation(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String[] tokens = name.split("[^\\w\\d]");
        String token12 = null;
        String[] stringArray = tokens;
        if (tokens != null) {
            for (String token12 : stringArray) {
                String token = token12.trim();
                int length = token.length();
                if (!(length > 0)) continue;
                buf.append(token.substring(0, 1).toUpperCase(Locale.ENGLISH));
                if (!(length > 1)) continue;
                buf.append(token.substring(1));
            }
        }
        return buf.toString();
    }

    public static String capitalize(String name) {
        if (NameUtils.isBlank(name)) {
            return name;
        }
        return StringGroovyMethods.plus((String)name.substring(0, 1).toUpperCase(), (CharSequence)name.substring(1));
    }

    public static String getClassNameFromKebabCase(String name) {
        if (NameUtils.isBlank(name)) {
            return name;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)name.indexOf("-"), (Object)-1)) {
            return StringGroovyMethods.plus((String)name.substring(0, 1).toUpperCase(), (CharSequence)name.substring(1));
        }
        StringBuilder buf = new StringBuilder();
        String[] tokens = name.split("-");
        String token2 = null;
        String[] stringArray = tokens;
        if (tokens != null) {
            for (String token2 : stringArray) {
                if (token2 == null || token2.length() == 0) continue;
                buf.append(token2.substring(0, 1).toUpperCase()).append(token2.substring(1));
            }
        }
        return buf.toString();
    }

    public static String getPropertyName(String name) {
        return NameUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return NameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        return NameUtils.getPropertyNameRepresentation(NameUtils.getShortName(targetClass));
    }

    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)pos, (Object)-1)) {
            String string;
            name = string = name.substring(pos + 1);
        }
        if (name.isEmpty()) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = StringGroovyMethods.plus((String)name.substring(0, 1).toLowerCase(Locale.ENGLISH), (CharSequence)name.substring(1));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)propertyName.indexOf(" "), (Object)-1)) {
            String string;
            propertyName = string = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameFromKebabCase(String name) {
        return NameUtils.getPropertyName(NameUtils.getClassNameFromKebabCase(name));
    }

    public static String getShortName(Class<?> targetClass) {
        return NameUtils.getShortName(targetClass.getName());
    }

    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)i, (Object)-1)) {
            String string;
            className = string = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getPackageName(String className) {
        int i = className.lastIndexOf(".");
        String packageName = "";
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)i, (Object)-1)) {
            String string;
            packageName = string = className.substring(0, i);
        }
        return packageName;
    }

    public static String getKebabCase(Class<?> clazz) {
        return ShortTypeHandling.castToString(clazz == null ? null : NameUtils.getKebabCase(clazz.getName()));
    }

    public static String getKebabCase(String name) {
        if (name == null) {
            return ShortTypeHandling.castToString(null);
        }
        if (name.endsWith(".groovy")) {
            String string;
            name = string = name.substring(0, name.length() - 7);
        }
        return NameUtils.getNaturalName(name).replaceAll("\\s", "-").toLowerCase();
    }

    public static String getNaturalName(String name) {
        String string;
        name = string = NameUtils.getShortName(name);
        List words = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        int i = 0;
        char[] chars = name.toCharArray();
        int j = 0;
        while (j < chars.length) {
            char c = BytecodeInterface8.cArrayGet((char[])chars, (int)j);
            String w = null;
            if (i >= words.size()) {
                String string2;
                w = string2 = "";
                words.add(i, w);
            } else {
                Object e = words.get(i);
                w = ShortTypeHandling.castToString(e);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    char c2;
                    c = c2 = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    String string3;
                    w = string3 = "";
                    words.add(++i, w);
                }
                words.set(i, StringGroovyMethods.plus((CharSequence)w, (Object)Character.valueOf(c)));
            } else if (Character.isUpperCase(c)) {
                if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1)) && Character.isUpperCase(BytecodeInterface8.cArrayGet((char[])chars, (int)(j - 1)))) {
                    words.set(i, StringGroovyMethods.plus((CharSequence)w, (Object)Character.valueOf(c)));
                } else {
                    words.add(++i, String.valueOf(c));
                }
            }
            int n = j;
            int cfr_ignored_0 = n + 1;
        }
        StringBuilder buf = new StringBuilder();
        Iterator j2 = words.iterator();
        while (j2.hasNext()) {
            String word = ShortTypeHandling.castToString(j2.next());
            buf.append(word);
            if (!j2.hasNext()) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String getPropertyNameConvention(Object object) {
        String suffix = "";
        return NameUtils.getPropertyNameConvention(object, suffix);
    }

    public static boolean isValidJavaPackage(String packageName) {
        if (NameUtils.isBlank(packageName)) {
            return false;
        }
        String[] parts = packageName.split("\\.");
        String part2 = null;
        String[] stringArray = parts;
        if (parts != null) {
            for (String part2 : stringArray) {
                if (!(!NameUtils.isValidJavaIdentifier(part2))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String name) {
        if (NameUtils.isBlank(name)) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(BytecodeInterface8.cArrayGet((char[])chars, (int)0))) {
            return false;
        }
        char c2 = '\u0000';
        char[] cArray = chars;
        if (chars != null) {
            for (char c2 : cArray) {
                if (!(!Character.isJavaIdentifierPart(c2))) continue;
                return false;
            }
        }
        return true;
    }

    public static String getPropertyNameConvention(Object object, String suffix) {
        if (object != null) {
            Class<?> type = object.getClass();
            if (type.isArray()) {
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(type.getComponentType()), (CharSequence)suffix), (CharSequence)"Array");
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
                if (coll.isEmpty()) {
                    return "emptyCollection";
                }
                Object first = coll.iterator().next();
                if (coll instanceof List) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(first.getClass()), (CharSequence)suffix), (CharSequence)"List");
                }
                if (coll instanceof Set) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(first.getClass()), (CharSequence)suffix), (CharSequence)"Set");
                }
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(first.getClass()), (CharSequence)suffix), (CharSequence)"Collection");
            }
            if (object instanceof Map) {
                Map map = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
                if (map.isEmpty()) {
                    return "emptyMap";
                }
                Object entry = map.values().iterator().next();
                if (entry != null) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(entry.getClass()), (CharSequence)suffix), (CharSequence)"Map");
                }
            } else {
                return StringGroovyMethods.plus((String)NameUtils.getPropertyName(object.getClass()), (CharSequence)suffix);
            }
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String getPropertyForGetter(String getterName) {
        return NameUtils.getPropertyForGetter(getterName, Boolean.TYPE);
    }

    public static String getPropertyForGetter(String getterName, Class returnType) {
        if (getterName == null || getterName.length() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        if (getterName.startsWith(PROPERTY_GET_PREFIX)) {
            String prop = getterName.substring(3);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        if (getterName.startsWith("is") && ScriptBytecodeAdapter.compareEqual((Object)returnType, Boolean.TYPE)) {
            String prop = getterName.substring(2);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String convertValidPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return ShortTypeHandling.castToString(null);
        }
        if (suffix.length() == 1) {
            return ShortTypeHandling.castToString((Object)(Character.isUpperCase(suffix.charAt(0)) ? suffix.toLowerCase() : null));
        }
        if (Character.isUpperCase(suffix.charAt(1))) {
            return suffix;
        }
        if (Character.isUpperCase(suffix.charAt(0))) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Character.valueOf(Character.toLowerCase(suffix.charAt(0))), suffix.substring(1)}, new String[]{"", "", ""}));
        }
        if ('_' == suffix.charAt(0)) {
            return suffix;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static boolean isGetter(String name, Class<?> ... args) {
        return NameUtils.isGetter(name, Boolean.TYPE, args);
    }

    public static boolean isGetter(String name, Class returnType, Class<?> ... args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        if (name.startsWith(PROPERTY_GET_PREFIX)) {
            String string;
            name = string = name.substring(3);
            if (NameUtils.isPropertyMethodSuffix(name)) {
                return true;
            }
        } else if (name.startsWith("is") && ScriptBytecodeAdapter.compareEqual((Object)returnType, Boolean.TYPE)) {
            String string;
            name = string = name.substring(2);
            if (NameUtils.isPropertyMethodSuffix(name)) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return false;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0));
        }
        return Character.isUpperCase(suffix.charAt(0)) || Character.isUpperCase(suffix.charAt(1));
    }

    public static String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        if (setterName.startsWith(PROPERTY_SET_PREFIX)) {
            String prop = setterName.substring(3);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return ShortTypeHandling.castToString(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NameUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        DOLLAR_SEPARATOR = string = "$";
    }
}

