/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.io;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yakworks.commons.lang.DateUtil;

public class FileUtil
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public FileUtil() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void deleteTempFile(Object filePath) {
        File file = filePath instanceof File ? (File)ScriptBytecodeAdapter.castToType((Object)filePath, File.class) : new File(ShortTypeHandling.castToString((Object)filePath));
        FileUtil.delete(file);
    }

    public static void deleteAllTempFiles(Object directoryPath) {
        File directory = directoryPath instanceof File ? (File)ScriptBytecodeAdapter.castToType((Object)directoryPath, File.class) : new File(ShortTypeHandling.castToString((Object)directoryPath));
        if (directory.exists()) {
            File[] filesList = directory.listFiles();
            public final class _deleteAllTempFiles_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _deleteAllTempFiles_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(File file) {
                    Date lastModifiedFileDate = new Date(file.lastModified());
                    long diffHours = DateUtil.getDateDifference_inHours(lastModifiedFileDate);
                    if (diffHours >= (long)1) {
                        FileUtil.delete(file);
                        return null;
                    }
                    return null;
                }

                public Object call(File file) {
                    return this.doCall(file);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deleteAllTempFiles_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)filesList, Object[].class)), (Closure)new _deleteAllTempFiles_closure1(FileUtil.class, FileUtil.class));
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            FileOutputStream fos = new FileOutputStream(file.getPath());
            FileLock fl = fos.getChannel().tryLock();
            if (DefaultTypeTransformation.booleanUnbox((Object)fl)) {
                fl.release();
            }
            fos.close();
            file.delete();
        }
    }

    public static String getExtension(String name) {
        return FilenameUtils.getExtension((String)name);
    }

    public static String extractMimeType(File file) {
        return FileUtil.extractMimeType(file.getName());
    }

    public static String extractMimeType(String fileName) {
        String string;
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)mimeType)) {
            LinkedHashMap mimeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"doc", "application/msword", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "xls", "application/vnd.ms-excel", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}), LinkedHashMap.class);
            String exten = FileUtil.getExtension(fileName);
            if (mimeMap.containsKey(exten)) {
                return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)mimeMap, (Object)exten));
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)(string = mimeType)) ? string : "application/octet-stream";
    }

    public static String extractNameWithoutExtension(String name) {
        return name.substring(0, name.lastIndexOf("."));
    }

    public static String parseStringAsGString(String theString, Map binding) {
        SimpleTemplateEngine engine = new SimpleTemplateEngine();
        Template template = engine.createTemplate(theString);
        String result = template.make(binding).toString();
        return result;
    }

    public static File generateTxtFile(String content, String fileName, String fileLocation) {
        return FileUtil.generateTxtFile(content, fileName, new File(fileLocation));
    }

    public static File generateTxtFile(String content, String fileName, File fileDirectory) {
        Reference content2 = new Reference((Object)content);
        if (!fileDirectory.exists()) {
            fileDirectory.mkdir();
        }
        File thefile = new File(fileDirectory, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fileName}, new String[]{"", ".txt"})));
        public final class _generateTxtFile_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference content;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateTxtFile_closure2(Object _outerInstance, Object _thisObject, Reference content) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.content = reference = content;
            }

            public Object doCall(Object it) {
                ((BufferedWriter)it).write(ShortTypeHandling.castToString((Object)this.content.get()));
                return null;
            }

            @Generated
            public String getContent() {
                return ShortTypeHandling.castToString((Object)this.content.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateTxtFile_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withWriter((File)thefile, (Closure)new _generateTxtFile_closure2(FileUtil.class, FileUtil.class, content2));
        return thefile;
    }

    public static List<File> unzip(File zip, File destDir) {
        List files = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));
        ZipEntry zepEntry = null;
        while (true) {
            ZipEntry zipEntry;
            zepEntry = zipEntry = zis.getNextEntry();
            if (!(zipEntry != null)) break;
            String fileName = zepEntry.getName();
            File newFile = new File(destDir, fileName);
            newFile.getParentFile().mkdirs();
            if (zepEntry.isDirectory()) {
                newFile.mkdir();
                continue;
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            IOGroovyMethods.leftShift((OutputStream)fos, (InputStream)zis);
            fos.flush();
            fos.close();
            DefaultGroovyMethods.leftShift((List)files, (Object)newFile);
        }
        zis.closeEntry();
        zis.close();
        return files;
    }

    public static File zip(File file, File destDir) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            File file2 = file;
            valueRecorder.record((Object)file2, 8);
            boolean bl = file2.exists();
            valueRecorder.record((Object)bl, 13);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert file.exists()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)destDir)) {
            File file3;
            destDir = file3 = file.getParentFile();
        }
        File zip = new File(destDir, FileUtil.changeExtension(file.getName(), "ZIP"));
        FileOutputStream fout = new FileOutputStream(zip);
        Reference zout = new Reference((Object)new ZipOutputStream(fout));
        ((ZipOutputStream)zout.get()).setLevel(Deflater.BEST_COMPRESSION);
        ZipEntry entry = new ZipEntry(file.getName());
        ((ZipOutputStream)zout.get()).putNextEntry(entry);
        public final class _zip_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference zout;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _zip_closure3(Object _outerInstance, Object _thisObject, Reference zout) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.zout = reference = zout;
            }

            public Object doCall(Object fin) {
                return IOGroovyMethods.leftShift((OutputStream)((OutputStream)ScriptBytecodeAdapter.castToType((Object)this.zout.get(), OutputStream.class)), (InputStream)((InputStream)ScriptBytecodeAdapter.castToType((Object)fin, InputStream.class)));
            }

            @Generated
            public ZipOutputStream getZout() {
                return (ZipOutputStream)ScriptBytecodeAdapter.castToType((Object)this.zout.get(), ZipOutputStream.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _zip_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withInputStream((File)file, (Closure)new _zip_closure3(FileUtil.class, FileUtil.class, zout));
        ((ZipOutputStream)zout.get()).closeEntry();
        ((ZipOutputStream)zout.get()).close();
        return zip;
    }

    public static String changeExtension(String name, String newExtension) {
        String changed = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)name.substring(0, name.lastIndexOf(".")), (CharSequence)"."), (CharSequence)newExtension);
        return changed;
    }

    public static void writeMapToSortedProperties(Map map, File toFile, boolean deleteIfExists) {
        if (toFile.exists() && deleteIfExists) {
            toFile.delete();
        }
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtil.readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charsetName) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)charsetName);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static File zip(File file) {
        return FileUtil.zip(file, null);
    }

    @Generated
    public static void writeMapToSortedProperties(Map map, File toFile) {
        FileUtil.writeMapToSortedProperties(map, toFile, true);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.commons.io.FileUtil");
    }
}

