/*
* Copyright 2021 Yak.Works - Licensed under the Apache License, Version 2.0 (the "License")
* You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
*/
package yakworks.problem

import javax.annotation.Nullable

import groovy.transform.CompileStatic

import yakworks.api.ApiStatus
import yakworks.i18n.MsgKey

@CompileStatic
final class ProblemBuilder {

    // private static final Set<String> RESERVED_PROPERTIES = new HashSet<>(Arrays.asList(
    //         "type", "title", "status", "detail", "instance", "cause"
    // ));

    private URI type
    private String title
    private ApiStatus status
    private String detail
    private URI instance
    private ProblemException cause
    private MsgKey msg

    /**
     * @see Problem#create()
     */
    // ProblemBuilder() {
    //
    // }

    static ProblemBuilder create() {
        return new ProblemBuilder();
    }

    public ProblemBuilder msg(MsgKey msg) {
        this.msg = msg;
        return this;
    }

    public ProblemBuilder type(@Nullable final URI type) {
        this.type = type;
        return this;
    }

    public ProblemBuilder title(@Nullable final String title) {
        this.title = title;
        return this;
    }

    public ProblemBuilder status(@Nullable final ApiStatus status) {
        this.status = status;
        // if(this.title == null) this.title = status.getReason();
        return this;
    }

    public ProblemBuilder detail(@Nullable final String detail) {
        this.detail = detail;
        return this;
    }

    public ProblemBuilder instance(@Nullable final URI instance) {
        this.instance = instance;
        return this;
    }

    public ProblemBuilder cause(@Nullable final ProblemException cause) {
        this.cause = cause;
        return this;
    }

    // /**
    //  *
    //  * @param key property name
    //  * @param value property value
    //  * @return this for chaining
    //  * @throws IllegalArgumentException if key is any of type, title, status, detail or instance
    //  */
    // public ProblemBuilder with(final String key, @Nullable final Object value) throws IllegalArgumentException {
    //     if (RESERVED_PROPERTIES.contains(key)) {
    //         throw new IllegalArgumentException("Property " + key + " is reserved");
    //     }
    //     parameters.put(key, value);
    //     return this;
    // }

    public ProblemException build() {
        def rp = ProblemException.of(cause)
        //ugly but getting it working for now
        if(msg) rp.msg(msg)
        if(type) rp.type(type)
        if(title) rp.title(title)
        if(status) rp.status(status)
        if(detail) rp.detail(detail)
        if(instance) rp.instance(instance)
        return rp
    }

}
