/*
 * Decompiled with CFR 0.152.
 */
package yakworks.problem;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import yakworks.api.ApiStatus;
import yakworks.api.Result;
import yakworks.i18n.MsgKey;
import yakworks.problem.ProblemBuilder;
import yakworks.problem.ProblemException;
import yakworks.problem.Violation;

public interface Problem
extends Result {
    public static final URI DEFAULT_TYPE = URI.create("about:blank");

    @Override
    default public Boolean getOk() {
        return false;
    }

    default public MsgKey getMsg() {
        return MsgKey.of((String)"problem.blank");
    }

    default public URI getType() {
        return null;
    }

    default public void setType(URI v) {
    }

    default public String getDetail() {
        return null;
    }

    default public void setDetail(String v) {
    }

    default public List<Violation> getViolations() {
        return Collections.emptyList();
    }

    default public void setViolations(List<Violation> v) {
    }

    @Nullable
    default public URI getInstance() {
        return null;
    }

    public static ProblemBuilder builder() {
        return new ProblemBuilder();
    }

    public static ProblemException create() {
        return new ProblemException();
    }

    public static ProblemException of(ApiStatus status) {
        return Problem.builder().status(status).build();
    }

    public static ProblemException of(ApiStatus status, String detail) {
        return Problem.builder().status(status).detail(detail).build();
    }

    public static ProblemException of(MsgKey msg) {
        return Problem.builder().msg(msg).build();
    }

    public static ProblemException of(String code, Object args) {
        return Problem.builder().msg((MsgKey)MsgKey.of((String)code, (Object)args)).build();
    }
}

