/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.time.TimeCategory;
import groovy.time.TimeDuration;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.groovy.datetime.extensions.DateTimeExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import yakworks.commons.lang.LocalDateUtils;
import yakworks.commons.lang.Validate;

public class DateUtil
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DateUtil() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Date getNextMonth() {
        return DateUtil.shiftCurrentDateByMonths(1);
    }

    public static Date getPreviousMonth() {
        return DateUtil.shiftCurrentDateByMonths(-1);
    }

    @Deprecated
    public static Date getTwoMonthsBack() {
        return DateUtil.shiftCurrentDateByMonths(-2);
    }

    @Deprecated
    public static Date getThreeMonthsBack() {
        return DateUtil.shiftCurrentDateByMonths(-3);
    }

    @Deprecated
    public static Date getFourMonthsBack() {
        return DateUtil.shiftCurrentDateByMonths(-4);
    }

    public static Date shiftCurrentDateByMonths(int months) {
        Calendar month = DateUtil.getCurrentCalendarInstance();
        month.set(Calendar.DATE, 1);
        month.add(Calendar.MONTH, months);
        return month.getTime();
    }

    public static Date addMonths(Date date, int number) {
        Reference date2 = new Reference((Object)date);
        Reference number2 = new Reference((Object)number);
        CallSite[] callSiteArray = DateUtil.$getCallSiteArray();
        Reference result = new Reference(null);
        Date cfr_ignored_0 = (Date)result.get();
        public final class _addMonths_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference date;
            private /* synthetic */ Reference number;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addMonths_closure1(Object _outerInstance, Object _thisObject, Reference result, Reference date, Reference number) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _addMonths_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.result = reference3 = result;
                this.date = reference2 = date;
                this.number = reference = number;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addMonths_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].call(this.date.get(), callSiteArray[1].callGetProperty(this.number.get()));
                this.result.set((Object)((Date)ScriptBytecodeAdapter.castToType((Object)object, Date.class)));
                return object;
            }

            @Generated
            public Date getResult() {
                CallSite[] callSiteArray = _addMonths_closure1.$getCallSiteArray();
                return (Date)ScriptBytecodeAdapter.castToType((Object)this.result.get(), Date.class);
            }

            @Generated
            public Date getDate() {
                CallSite[] callSiteArray = _addMonths_closure1.$getCallSiteArray();
                return (Date)ScriptBytecodeAdapter.castToType((Object)this.date.get(), Date.class);
            }

            @Generated
            public int getNumber() {
                CallSite[] callSiteArray = _addMonths_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.number.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addMonths_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addMonths_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "plus";
                stringArray[1] = "months";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _addMonths_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addMonths_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addMonths_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[0].callStatic(DateUtil.class, TimeCategory.class, (Object)new _addMonths_closure1(DateUtil.class, DateUtil.class, result, date2, number2));
        return (Date)result.get();
    }

    public static Date getFirstDateOfMonth() {
        Calendar startDate = DateUtil.getCurrentCalendarInstance();
        startDate.set(Calendar.DATE, 1);
        return DateUtil.setTimeAsOfMidnight(startDate).getTime();
    }

    public static Date getFirstDayOfWeek() {
        Calendar startDate = DateUtil.getCurrentCalendarInstance();
        int dayOfWeek = startDate.get(Calendar.DAY_OF_WEEK);
        while (dayOfWeek != Calendar.MONDAY) {
            int n;
            startDate.add(Calendar.DATE, -1);
            dayOfWeek = n = startDate.get(Calendar.DAY_OF_WEEK);
        }
        return DateUtil.setTimeAsOfMidnight(startDate).getTime();
    }

    public static Date getLastDayOfWeek() {
        Calendar endDate = DateUtil.getCurrentCalendarInstance();
        int dayOfWeek = endDate.get(Calendar.DAY_OF_WEEK);
        while (dayOfWeek != Calendar.SUNDAY) {
            int n;
            endDate.add(Calendar.DATE, 1);
            dayOfWeek = n = endDate.get(Calendar.DAY_OF_WEEK);
        }
        return DateUtil.setTimeBeforeMidnight(endDate).getTime();
    }

    @Deprecated
    public static Date getLastWeekEndDate() {
        Calendar endDate = DateUtil.getCurrentCalendarInstance();
        int dayOfWeek = endDate.get(Calendar.DAY_OF_WEEK);
        while (dayOfWeek != Calendar.SUNDAY) {
            int n;
            endDate.add(Calendar.DATE, -1);
            dayOfWeek = n = endDate.get(Calendar.DAY_OF_WEEK);
        }
        return DateUtil.setTimeBeforeMidnight(endDate).getTime();
    }

    @Deprecated
    public static int getLastWeekStartDate() {
        Calendar startDate = DateUtil.getCurrentCalendarInstance();
        int dayOfWeek = startDate.get(Calendar.DAY_OF_WEEK);
        while (dayOfWeek != Calendar.SUNDAY) {
            int n;
            startDate.add(Calendar.DATE, -1);
            dayOfWeek = n = startDate.get(Calendar.DAY_OF_WEEK);
        }
        while (dayOfWeek != Calendar.MONDAY) {
            int n;
            startDate.add(Calendar.DATE, -1);
            dayOfWeek = n = startDate.get(Calendar.DAY_OF_WEEK);
        }
        return dayOfWeek;
    }

    public static Calendar getCurrentCalendarInstance() {
        return DateUtil.getCalendarInstanceByDate(new Date());
    }

    public static Calendar getCalendarInstanceByDate(Date date) {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTime(date);
        return calendarDate;
    }

    public static String getMonthLetter(String periodToPost) {
        String monthLetter = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)periodToPost) && periodToPost.length() >= 5) {
            String string;
            String month = periodToPost.substring(4, 6);
            monthLetter = string = StringGroovyMethods.isInteger((CharSequence)month) ? DateUtil.getMonthLetterByNum(Integer.parseInt(month)) : "?";
        } else {
            String string;
            monthLetter = string = "?";
        }
        return monthLetter;
    }

    public static String getMonthLetterByNum(int monthNumber) {
        Object[] monthNames = new DateFormatSymbols().getMonths();
        return DefaultTypeTransformation.booleanUnbox((Object)(new IntRange(true, 1, 12) == null ? Boolean.valueOf(false) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)new IntRange(true, 1, 12), (Object)monthNumber)))) ? StringGroovyMethods.getAt((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])monthNames, (int)(monthNumber - 1))), (int)0) : "?";
    }

    public static Date convertStringToDateTime(String strDt, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
        Date dtTmp = null;
        try {
            Date date;
            dtTmp = date = df.parse(strDt);
        }
        catch (ParseException e) {
        }
        return dtTmp;
    }

    public static int getYearOf(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return gc.get(Calendar.YEAR);
    }

    public static int getYearOf(TemporalAccessor date) {
        return Year.from(date).getValue();
    }

    public static long getDateDifference_inHours(Date date) {
        Calendar lastModifiedDateCalendar = DateUtil.getCalendarInstanceByDate(date);
        long diff = DateUtil.getCurrentCalendarInstance().getTimeInMillis() - lastModifiedDateCalendar.getTimeInMillis();
        return DefaultTypeTransformation.longUnbox((Object)ScriptBytecodeAdapter.asType((Object)NumberNumberDiv.div((Number)Math.abs(diff), (Number)(60 * 60 * 1000)), Long.TYPE));
    }

    public static Date setToMidnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DateUtil.setTimeAsOfMidnight(cal);
        return cal.getTime();
    }

    public static Calendar setTimeAsOfMidnight(Calendar cal) {
        return DateUtil.setTime(cal, 0, 0, 0);
    }

    public static Calendar setTimeBeforeMidnight(Calendar cal) {
        return DateUtil.setTime(cal, 23, 59, 59);
    }

    public static Calendar setTime(Calendar cal, int hours, int minutes, int seconds, int milliseconds) {
        cal.set(Calendar.HOUR_OF_DAY, hours);
        cal.set(Calendar.MINUTE, minutes);
        cal.set(Calendar.SECOND, seconds);
        cal.set(Calendar.MILLISECOND, milliseconds);
        return cal;
    }

    public static boolean isTodayTheDate(ChronoUnit period, int dayNumber) {
        LocalDate thedate = LocalDate.now();
        ChronoUnit chronoUnit = period;
        if (ScriptBytecodeAdapter.isCase((Object)chronoUnit, (Object)ChronoUnit.DAYS)) {
            return true;
        }
        if (ScriptBytecodeAdapter.isCase((Object)chronoUnit, (Object)ChronoUnit.WEEKS)) {
            return DayOfWeek.from(thedate).getValue() == dayNumber;
        }
        if (ScriptBytecodeAdapter.isCase((Object)chronoUnit, (Object)ChronoUnit.MONTHS)) {
            return thedate.getDayOfMonth() == dayNumber;
        }
        return false;
    }

    public static int getMonthDiff(Date one, Date two) {
        Calendar start = Calendar.getInstance();
        start.setTime(one);
        Calendar end = Calendar.getInstance();
        end.setTime(two);
        int diffYear = end.get(Calendar.YEAR) - start.get(Calendar.YEAR);
        int diffMonth = diffYear * 12 + end.get(Calendar.MONTH) - start.get(Calendar.MONTH);
        return diffMonth;
    }

    /*
     * WARNING - void declaration
     */
    public static int getDaysBetween(Date start, Date end) {
        void var1_1;
        Reference start2 = new Reference((Object)start);
        Reference end2 = new Reference((Object)var1_1);
        CallSite[] callSiteArray = DateUtil.$getCallSiteArray();
        callSiteArray[1].call(Validate.class, (Object)((Date)start2.get()), (Object)"[Start date]");
        callSiteArray[2].call(Validate.class, (Object)((Date)end2.get()), (Object)"[End date]");
        Reference days = new Reference((Object)0);
        Integer cfr_ignored_0 = (Integer)days.get();
        public final class _getDaysBetween_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference start;
            private /* synthetic */ Reference end;
            private /* synthetic */ Reference days;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDaysBetween_closure2(Object _outerInstance, Object _thisObject, Reference start, Reference end, Reference days) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getDaysBetween_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.start = reference3 = start;
                this.end = reference2 = end;
                this.days = reference = days;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDaysBetween_closure2.$getCallSiteArray();
                TimeDuration duration = (TimeDuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.start.get(), this.end.get()), TimeDuration.class);
                Object object = callSiteArray[1].callGetProperty((Object)duration);
                this.days.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)object, Integer.class)));
                return object;
            }

            @Generated
            public Date getStart() {
                CallSite[] callSiteArray = _getDaysBetween_closure2.$getCallSiteArray();
                return (Date)ScriptBytecodeAdapter.castToType((Object)this.start.get(), Date.class);
            }

            @Generated
            public Date getEnd() {
                CallSite[] callSiteArray = _getDaysBetween_closure2.$getCallSiteArray();
                return (Date)ScriptBytecodeAdapter.castToType((Object)this.end.get(), Date.class);
            }

            @Generated
            public Integer getDays() {
                CallSite[] callSiteArray = _getDaysBetween_closure2.$getCallSiteArray();
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.days.get(), Integer.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getDaysBetween_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDaysBetween_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "minus";
                stringArray[1] = "days";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getDaysBetween_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getDaysBetween_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDaysBetween_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[3].callStatic(DateUtil.class, TimeCategory.class, (Object)new _getDaysBetween_closure2(DateUtil.class, DateUtil.class, start2, end2, days));
        return (Integer)days.get();
    }

    public static Date getLastDayOfMonth(Date date, int addMonth) {
        LocalDate locDate = LocalDateUtils.getLastDateOfMonth(DateTimeExtensions.toLocalDate((Date)date));
        if (addMonth != 0) {
            LocalDate localDate;
            locDate = localDate = locDate.plusMonths((Long)ScriptBytecodeAdapter.asType((Object)addMonth, Long.class));
        }
        return DateTimeExtensions.toDate((LocalDate)locDate);
    }

    public static Date getFirstDayOfMonth(Date date, int addMonth) {
        LocalDate locDate = LocalDateUtils.getFirstDateOfMonth(DateTimeExtensions.toLocalDate((Date)date));
        if (addMonth != 0) {
            LocalDate localDate;
            locDate = localDate = locDate.plusMonths((Long)ScriptBytecodeAdapter.asType((Object)addMonth, Long.class));
        }
        return DateTimeExtensions.toDate((LocalDate)locDate);
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (LocalDate)ScriptBytecodeAdapter.castToType(null, LocalDate.class);
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (LocalDateTime)ScriptBytecodeAdapter.castToType(null, LocalDateTime.class);
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDateTime();
    }

    public static Date fromLocalDate(LocalDate localDate, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)localDate)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        return Date.from(localDate.atStartOfDay(zoneId).toInstant());
    }

    public static Date fromLocalDateTime(LocalDateTime localDate, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)localDate)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        return Date.from(localDate.atZone(zoneId).toInstant());
    }

    public static boolean isSameDay(Date date1, Date date2) {
        LocalDate ld1 = LocalDateTime.ofInstant(date1.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate ld2 = LocalDateTime.ofInstant(date2.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return ScriptBytecodeAdapter.compareEqual((Object)ld1, (Object)ld2);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DateUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static Calendar setTime(Calendar cal, int hours, int minutes, int seconds) {
        return DateUtil.setTime(cal, hours, minutes, seconds, 0);
    }

    @Generated
    public static Calendar setTime(Calendar cal, int hours, int minutes) {
        return DateUtil.setTime(cal, hours, minutes, 0, 0);
    }

    @Generated
    public static Calendar setTime(Calendar cal, int hours) {
        return DateUtil.setTime(cal, hours, 0, 0, 0);
    }

    @Generated
    public static Calendar setTime(Calendar cal) {
        return DateUtil.setTime(cal, 0, 0, 0, 0);
    }

    @Generated
    public static Date getLastDayOfMonth(Date date) {
        return DateUtil.getLastDayOfMonth(date, 0);
    }

    @Generated
    public static Date getFirstDayOfMonth(Date date) {
        return DateUtil.getFirstDayOfMonth(date, 0);
    }

    @Generated
    public static LocalDate toLocalDate(Date date) {
        return DateUtil.toLocalDate(date, ZoneId.systemDefault());
    }

    @Generated
    public static LocalDateTime toLocalDateTime(Date date) {
        return DateUtil.toLocalDateTime(date, ZoneId.systemDefault());
    }

    @Generated
    public static Date fromLocalDate(LocalDate localDate) {
        return DateUtil.fromLocalDate(localDate, ZoneId.systemDefault());
    }

    @Generated
    public static Date fromLocalDateTime(LocalDateTime localDate) {
        return DateUtil.fromLocalDateTime(localDate, ZoneId.systemDefault());
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "use";
        stringArray[1] = "notNull";
        stringArray[2] = "notNull";
        stringArray[3] = "use";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[4];
        DateUtil.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DateUtil.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DateUtil.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

