/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.json;

import groovy.json.JsonGenerator;
import groovy.json.JsonSlurper;
import groovy.json.StreamingJsonBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.builder.Builder;
import groovy.transform.builder.SimpleStrategy;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.NioGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import yakworks.commons.io.IOUtils;
import yakworks.commons.json.converters.CurrencyConverter;
import yakworks.commons.json.converters.InstantJsonConverter;
import yakworks.commons.json.converters.LocalDateJsonConverter;
import yakworks.commons.json.converters.LocalDateTimeJsonConverter;
import yakworks.commons.json.converters.LocalTimeJsonConverter;
import yakworks.commons.json.converters.OffsetDateTimeJsonConverter;
import yakworks.commons.json.converters.OffsetTimeJsonConverter;
import yakworks.commons.json.converters.PeriodJsonConverter;
import yakworks.commons.json.converters.URIConverter;
import yakworks.commons.json.converters.ZonedDateTimeJsonConverter;

@Builder(builderStrategy=SimpleStrategy.class, prefix="")
public class JsonEngine
implements GroovyObject {
    public static JsonEngine INSTANCE;
    private String dateFormat;
    private String timeZone;
    private String locale;
    private Boolean escapeUnicode;
    private JsonGenerator jsonGenerator;
    private JsonSlurper jsonSlurper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public JsonEngine() {
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        this.dateFormat = string3 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        this.timeZone = string2 = "GMT";
        this.locale = string = "en/US";
        boolean bl = false;
        this.escapeUnicode = bl;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public JsonGenerator.Options buildOptions() {
        Locale locale;
        Locale locale2;
        Reference options = new Reference((Object)new JsonGenerator.Options());
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.escapeUnicode)) {
            ((JsonGenerator.Options)options.get()).disableUnicodeEscaping();
        }
        Locale loc = null;
        Object[] localeData = this.locale.split("/");
        loc = localeData.length > 1 ? (locale2 = new Locale(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])localeData, (int)0)), ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])localeData, (int)1)))) : (locale = new Locale(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])localeData, (int)0))));
        ((JsonGenerator.Options)options.get()).dateFormat(this.dateFormat, loc);
        ((JsonGenerator.Options)options.get()).timezone(this.timeZone);
        ((JsonGenerator.Options)options.get()).excludeNulls();
        public final class _buildOptions_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference options;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildOptions_closure1(Object _outerInstance, Object _thisObject, Reference options) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.options = reference = options;
            }

            public Object doCall(Object it) {
                return ((JsonGenerator.Options)this.options.get()).addConverter((JsonGenerator.Converter)ScriptBytecodeAdapter.castToType((Object)it, JsonGenerator.Converter.class));
            }

            @Generated
            public JsonGenerator.Options getOptions() {
                return (JsonGenerator.Options)ScriptBytecodeAdapter.castToType((Object)this.options.get(), JsonGenerator.Options.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildOptions_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getConverters(), (Closure)new _buildOptions_closure1(this, this, options));
        return (JsonGenerator.Options)options.get();
    }

    public JsonEngine build() {
        JsonSlurper jsonSlurper;
        JsonGenerator jsonGenerator;
        this.jsonGenerator = jsonGenerator = this.buildOptions().build();
        this.jsonSlurper = jsonSlurper = this.buildSlurper();
        return this;
    }

    public JsonSlurper buildSlurper() {
        return new JsonSlurper();
    }

    public List<JsonGenerator.Converter> getConverters() {
        ServiceLoader<JsonGenerator.Converter> loader = ServiceLoader.load(JsonGenerator.Converter.class);
        List converters = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        JsonGenerator.Converter converter = null;
        Iterator<JsonGenerator.Converter> iterator = loader.iterator();
        while (iterator.hasNext()) {
            converter = (JsonGenerator.Converter)ScriptBytecodeAdapter.castToType((Object)iterator.next(), JsonGenerator.Converter.class);
            converters.add(converter);
        }
        converters.add(new InstantJsonConverter());
        converters.add(new LocalDateJsonConverter());
        converters.add(new LocalDateTimeJsonConverter());
        converters.add(new LocalTimeJsonConverter());
        converters.add(new OffsetDateTimeJsonConverter());
        converters.add(new OffsetTimeJsonConverter());
        converters.add(new PeriodJsonConverter());
        converters.add(new ZonedDateTimeJsonConverter());
        converters.add(new CurrencyConverter());
        converters.add(new URIConverter());
        return converters;
    }

    public static String toJson(Object object) {
        return JsonEngine.stringify(object);
    }

    public static String stringify(Object object, Map arguments) {
        return JsonEngine.getGenerator().toJson(object);
    }

    public static JsonGenerator getGenerator() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)INSTANCE)) {
            JsonEngine jsonEngine;
            INSTANCE = jsonEngine = new JsonEngine().build();
        }
        return INSTANCE.getJsonGenerator();
    }

    public static JsonSlurper getSlurper() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)INSTANCE)) {
            JsonEngine jsonEngine;
            INSTANCE = jsonEngine = new JsonEngine().build();
        }
        return INSTANCE.getJsonSlurper();
    }

    public static Object parseJson(String text) {
        return JsonEngine.getSlurper().parseText(text);
    }

    public static <T> T parseJson(String text, Class<T> clazz) {
        Object parsedObj = JsonEngine.parseJson(text);
        JsonEngine.validateExpectedClass(clazz, parsedObj);
        return (T)parsedObj;
    }

    public static void validateExpectedClass(Class clazz, Object parsedObj) {
        if (!clazz.isAssignableFrom(parsedObj.getClass())) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{clazz.getSimpleName(), parsedObj.getClass().getSimpleName()}, new String[]{"Json parsing expected a ", " but got a ", ""})));
        }
    }

    public static void streamToFile(Path filePath, Object payload) {
        BufferedWriter fileWriter = NioGroovyMethods.newWriter((Path)filePath);
        StreamingJsonBuilder sjb = new StreamingJsonBuilder((Writer)fileWriter, JsonEngine.getGenerator());
        sjb.call(new Object[]{payload});
        IOUtils.flushAndClose(fileWriter);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JsonEngine.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public JsonEngine dateFormat(String dateFormat) {
        String string;
        this.dateFormat = string = dateFormat;
        return this;
    }

    @Generated
    public JsonEngine timeZone(String timeZone) {
        String string;
        this.timeZone = string = timeZone;
        return this;
    }

    @Generated
    public JsonEngine locale(String locale) {
        String string;
        this.locale = string = locale;
        return this;
    }

    @Generated
    public JsonEngine escapeUnicode(Boolean escapeUnicode) {
        Boolean bl;
        this.escapeUnicode = bl = escapeUnicode;
        return this;
    }

    @Generated
    public JsonEngine jsonGenerator(JsonGenerator jsonGenerator) {
        JsonGenerator jsonGenerator2;
        this.jsonGenerator = jsonGenerator2 = jsonGenerator;
        return this;
    }

    @Generated
    public JsonEngine jsonSlurper(JsonSlurper jsonSlurper) {
        JsonSlurper jsonSlurper2;
        this.jsonSlurper = jsonSlurper2 = jsonSlurper;
        return this;
    }

    @Generated
    public static String stringify(Object object) {
        return JsonEngine.stringify(object, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public void setTimeZone(String string) {
        this.timeZone = string;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public void setLocale(String string) {
        this.locale = string;
    }

    @Generated
    public Boolean getEscapeUnicode() {
        return this.escapeUnicode;
    }

    @Generated
    public void setEscapeUnicode(Boolean bl) {
        this.escapeUnicode = bl;
    }

    @Generated
    public JsonGenerator getJsonGenerator() {
        return this.jsonGenerator;
    }

    @Generated
    public void setJsonGenerator(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    @Generated
    public JsonSlurper getJsonSlurper() {
        return this.jsonSlurper;
    }

    @Generated
    public void setJsonSlurper(JsonSlurper jsonSlurper) {
        this.jsonSlurper = jsonSlurper;
    }
}

