/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import yakworks.commons.lang.LocalDateUtils;

public class IsoDateUtil
implements GroovyObject {
    private static final Pattern LOCAL_DATE;
    private static final Pattern GMT_MILLIS;
    private static final Pattern GMT_SECONDS;
    private static final Pattern TZ_LESS;
    private static final Pattern TZ_LESS_HH_MM;
    private static final ThreadLocal<SimpleDateFormat> LOCAL_DATE_FORMAT;
    private static final ThreadLocal<SimpleDateFormat> DATE_TIME_FORMAT;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public IsoDateUtil() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Date parse(String date) {
        String string;
        String string2 = date;
        date = string = string2 != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)ScriptBytecodeAdapter.castToType((Object)DATE_TIME_FORMAT.get(), SimpleDateFormat.class);
        if (StringGroovyMethods.matches((CharSequence)date, (Pattern)GMT_MILLIS)) {
            return dateFormat.parse(date);
        }
        if (StringGroovyMethods.matches((CharSequence)date, (Pattern)LOCAL_DATE)) {
            SimpleDateFormat simpleDateFormat = LOCAL_DATE_FORMAT.get();
            dateFormat = (SimpleDateFormat)ScriptBytecodeAdapter.castToType((Object)simpleDateFormat, SimpleDateFormat.class);
        } else if (StringGroovyMethods.matches((CharSequence)date, (Pattern)GMT_SECONDS)) {
            String string3;
            date = string3 = date.replaceFirst("Z$", ".000Z");
        } else if (StringGroovyMethods.matches((CharSequence)date, (Pattern)TZ_LESS)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{date}, new String[]{"", ".000Z"});
            date = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (StringGroovyMethods.matches((CharSequence)date, (Pattern)TZ_LESS_HH_MM)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{date}, new String[]{"", ":00.000Z"});
            date = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return dateFormat.parse(date);
    }

    public static LocalDate parseLocalDate(String date) {
        return LocalDateUtils.parse(date);
    }

    public static LocalDateTime parseLocalDateTime(String date) {
        return LocalDateUtils.parseLocalDateTime(date);
    }

    public static String format(Date date) {
        return DATE_TIME_FORMAT.get().format(date);
    }

    public static String format(LocalDateTime date) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(date);
    }

    public static String format(LocalDate date, String format) {
        DateTimeFormatter formatter = DefaultTypeTransformation.booleanUnbox((Object)format) ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ISO_LOCAL_DATE;
        return date.format(formatter);
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
        String dtStr = "";
        try {
            String string;
            dtStr = string = df.format(date);
        }
        catch (ParseException e) {
        }
        return dtStr;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IsoDateUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static String format(LocalDate date) {
        return IsoDateUtil.format(date, null);
    }

    @Generated
    public static String dateToString(Date date) {
        return IsoDateUtil.dateToString(date, "MM/dd/yyyy hh:mm:ss");
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-\\d{2}-\\d{2}$");
        LOCAL_DATE = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        Object object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z");
        GMT_MILLIS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object2, Pattern.class);
        Object object3 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");
        GMT_SECONDS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object3, Pattern.class);
        Object object4 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}");
        TZ_LESS = (Pattern)ScriptBytecodeAdapter.castToType((Object)object4, Pattern.class);
        Object object5 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}");
        TZ_LESS_HH_MM = (Pattern)ScriptBytecodeAdapter.castToType((Object)object5, Pattern.class);
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                SimpleDateFormat fmatter = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                fmatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                return fmatter;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ThreadLocal threadLocal = ThreadLocal.withInitial((Supplier)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure1(IsoDateUtil.class, IsoDateUtil.class)), Supplier.class));
        LOCAL_DATE_FORMAT = threadLocal;
        public final class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                SimpleDateFormat fmatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
                fmatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                return fmatter;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ThreadLocal threadLocal2 = ThreadLocal.withInitial((Supplier)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure2(IsoDateUtil.class, IsoDateUtil.class)), Supplier.class));
        DATE_TIME_FORMAT = threadLocal2;
    }

    @Generated
    public static Pattern getLOCAL_DATE() {
        return LOCAL_DATE;
    }

    @Generated
    public static Pattern getGMT_MILLIS() {
        return GMT_MILLIS;
    }

    @Generated
    public static Pattern getGMT_SECONDS() {
        return GMT_SECONDS;
    }

    @Generated
    public static Pattern getTZ_LESS() {
        return TZ_LESS;
    }

    @Generated
    public static Pattern getTZ_LESS_HH_MM() {
        return TZ_LESS_HH_MM;
    }

    @Generated
    public static ThreadLocal<SimpleDateFormat> getLOCAL_DATE_FORMAT() {
        return LOCAL_DATE_FORMAT;
    }

    @Generated
    public static ThreadLocal<SimpleDateFormat> getDATE_TIME_FORMAT() {
        return DATE_TIME_FORMAT;
    }
}

