/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.audit;

import gorm.tools.utils.GormMetaUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import yakworks.commons.lang.ClassUtils;
import yakworks.security.audit.AuditCreatedTrait;
import yakworks.security.audit.AuditStamp;
import yakworks.security.audit.AuditStampTrait;
import yakworks.security.audit.AuditUserResolver;
import yakworks.security.audit.ast.FieldProps;
import yakworks.security.user.UserInfo;

public class AuditStampSupport
implements GroovyObject {
    private static final String DISABLE_AUDITSTAMP_FIELD = "disableAuditStamp";
    protected static AuditUserResolver USER_RESOLVER;
    @Autowired
    private AuditUserResolver auditUserResolver;
    @Autowired
    private MappingContext grailsDomainClassMappingContext;
    private Map<String, FieldProps> fieldProps;
    private final Set<String> auditStampedEntities;
    private final Set<String> auditStampCreateEntities;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AuditStampSupport() {
        MetaClass metaClass;
        Set set;
        Set set2;
        this.auditStampedEntities = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.auditStampCreateEntities = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PostConstruct
    public void init() {
        AuditUserResolver auditUserResolver;
        Collection collection;
        if (!DefaultTypeTransformation.booleanUnbox(this.fieldProps)) {
            Map<String, FieldProps> map = FieldProps.buildFieldMap(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            this.fieldProps = map;
        }
        Iterator iterator = (collection = this.grailsDomainClassMappingContext.getPersistentEntities()) != null ? collection.iterator() : null;
        PersistentEntity persistentEntity = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                persistentEntity = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator2.next(), PersistentEntity.class);
                if (this.isClassAuditStamped(persistentEntity.getJavaClass())) {
                    DefaultGroovyMethods.leftShift(this.auditStampedEntities, (Object)persistentEntity.getName());
                }
                if (!this.isClassAuditCreateStamped(persistentEntity.getJavaClass())) continue;
                DefaultGroovyMethods.leftShift(this.auditStampCreateEntities, (Object)persistentEntity.getName());
            }
        }
        USER_RESOLVER = auditUserResolver = this.auditUserResolver;
    }

    public boolean isClassAuditStamped(Class domainClass) {
        return (AuditStampTrait.class.isAssignableFrom(domainClass) || DefaultTypeTransformation.booleanUnbox((Object)AnnotationUtils.findAnnotation((Class)domainClass, AuditStamp.class))) && !this.isAuditStampDisabled(domainClass);
    }

    public boolean isClassAuditCreateStamped(Class domainClass) {
        return AuditCreatedTrait.class.isAssignableFrom(domainClass) && !this.isAuditStampDisabled(domainClass);
    }

    public boolean isAuditStampDisabled(Class clazz) {
        return ScriptBytecodeAdapter.compareEqual((Object)ClassUtils.getStaticPropertyValue((Class)clazz, (String)DISABLE_AUDITSTAMP_FIELD, Boolean.class), (Object)true);
    }

    public boolean isAuditStamped(String name) {
        return this.auditStampedEntities.contains(GormMetaUtils.unwrapIfProxy((String)name));
    }

    public boolean isAuditCreateStamped(String name) {
        return this.auditStampCreateEntities.contains(GormMetaUtils.unwrapIfProxy((String)name));
    }

    public void stampIfNew(Object entity, Class<?> dateTimeClass) {
        if (entity instanceof AuditStampTrait && this.hasCreatedDate(entity)) {
            this.ensureEditedDate(entity);
        } else {
            this.stampDefaults(entity, dateTimeClass);
        }
    }

    public void ensureEditedDate(Object entity) {
        String createdDateName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getCREATED_DATE_KEY())).getName();
        String editedDateName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_DATE_KEY())).getName();
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Object)entity, (String)editedDateName))) {
            Object object = DefaultGroovyMethods.getAt((Object)entity, (String)createdDateName);
            ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{editedDateName, object});
        }
    }

    public void stampDefaults(Object entity, Class<?> dateTimeClass) {
        Object timestamp = this.createTimestamp(dateTimeClass);
        Serializable uid = this.getCurrentUserId();
        String datePropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getCREATED_DATE_KEY())).getName();
        Object t = timestamp;
        ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{datePropName, t});
        String userPropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getCREATED_BY_KEY())).getName();
        Serializable serializable = uid;
        ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{userPropName, serializable});
        if (entity instanceof AuditStampTrait) {
            String edatePropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_DATE_KEY())).getName();
            Object t2 = timestamp;
            ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{edatePropName, t2});
            String euserPropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_BY_KEY())).getName();
            Serializable serializable2 = uid;
            ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{euserPropName, serializable2});
        }
    }

    public void stampUpdate(Object entity, Class<?> dateTimeClass) {
        Object timestamp = this.createTimestamp(dateTimeClass);
        String datePropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_DATE_KEY())).getName();
        String userPropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_BY_KEY())).getName();
        Object t = timestamp;
        ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{datePropName, t});
        Serializable serializable = this.getCurrentUserId();
        ScriptBytecodeAdapter.invokeMethodN(AuditStampSupport.class, (Object)entity, (String)"putAt", (Object[])new Object[]{userPropName, serializable});
    }

    public void stampPreUpdateEvent(EntityAccess ea, Class<?> dateTimeClass) {
        Object timestamp = this.createTimestamp(dateTimeClass);
        String datePropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_DATE_KEY())).getName();
        String userPropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getEDITED_BY_KEY())).getName();
        ea.setProperty(datePropName, timestamp);
        ea.setProperty(userPropName, (Object)this.getCurrentUserId());
    }

    public <T> T createTimestamp(Class<?> dateTimeClass) {
        return (T)InvokerHelper.invokeStaticMethod(dateTimeClass, (String)"now", null);
    }

    public boolean hasCreatedDate(Object entity) {
        String createdDateFieldName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getCREATED_DATE_KEY())).getName();
        MetaProperty createdDateProperty = DefaultGroovyMethods.hasProperty((Object)entity, (String)createdDateFieldName);
        if (createdDateProperty != null) {
            Object existingValue = createdDateProperty.getProperty(entity);
            return existingValue != null;
        }
        return DefaultTypeTransformation.booleanUnbox(null);
    }

    public Serializable getCurrentUserId() {
        Serializable uid = USER_RESOLVER.getCurrentUserId();
        Serializable serializable = uid;
        return DefaultTypeTransformation.booleanUnbox((Object)serializable) ? serializable : Long.valueOf(0L);
    }

    public static UserInfo getUserInfo(Serializable uid) {
        return USER_RESOLVER.getUserInfo(uid);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AuditStampSupport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public void stampIfNew(Object entity) {
        CallSite[] callSiteArray = AuditStampSupport.$getCallSiteArray();
        this.stampIfNew(entity, LocalDateTime.class);
    }

    @Generated
    public void stampDefaults(Object entity) {
        CallSite[] callSiteArray = AuditStampSupport.$getCallSiteArray();
        this.stampDefaults(entity, LocalDateTime.class);
    }

    @Generated
    public void stampUpdate(Object entity) {
        CallSite[] callSiteArray = AuditStampSupport.$getCallSiteArray();
        this.stampUpdate(entity, LocalDateTime.class);
    }

    @Generated
    public void stampPreUpdateEvent(EntityAccess ea) {
        CallSite[] callSiteArray = AuditStampSupport.$getCallSiteArray();
        this.stampPreUpdateEvent(ea, LocalDateTime.class);
    }

    @Generated
    public <T> T createTimestamp() {
        CallSite[] callSiteArray = AuditStampSupport.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createTimestamp(LocalDateTime.class);
        }
        return this.createTimestamp(LocalDateTime.class);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AuditUserResolver getAuditUserResolver() {
        return this.auditUserResolver;
    }

    @Generated
    public void setAuditUserResolver(AuditUserResolver auditUserResolver) {
        this.auditUserResolver = auditUserResolver;
    }

    @Generated
    public MappingContext getGrailsDomainClassMappingContext() {
        return this.grailsDomainClassMappingContext;
    }

    @Generated
    public void setGrailsDomainClassMappingContext(MappingContext mappingContext) {
        this.grailsDomainClassMappingContext = mappingContext;
    }

    @Generated
    public Map<String, FieldProps> getFieldProps() {
        return this.fieldProps;
    }

    @Generated
    public void setFieldProps(Map<String, FieldProps> map) {
        this.fieldProps = map;
    }

    @Generated
    public final Set<String> getAuditStampedEntities() {
        return this.auditStampedEntities;
    }

    @Generated
    public final Set<String> getAuditStampCreateEntities() {
        return this.auditStampCreateEntities;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AuditStampSupport.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AuditStampSupport.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

