/*
 * Decompiled with CFR 0.152.
 */
package yakworks.etl.excel;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.builder.Builder;
import groovy.transform.builder.SimpleStrategy;
import java.beans.Transient;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import yakworks.commons.beans.PropertyTools;
import yakworks.commons.map.MapFlattener;
import yakworks.meta.MetaMapList;
import yakworks.meta.MetaProp;

@Builder(builderStrategy=SimpleStrategy.class, prefix="", includes={"includes", "headerType", "headers", "outputStream"})
public class ExcelBuilder
implements GroovyObject {
    public static final String SHEET_NAME = "data";
    public static final DefaultIndexedColorMap INDEXED_COLOR_MAP;
    private List<String> includes;
    private String configKey;
    private String headerType;
    private List<String> headers;
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    private CreationHelper createHelper;
    private OutputStream outputStream;
    private XSSFCellStyle styleHeader;
    private XSSFCellStyle styleMoney;
    private XSSFCellStyle styleLocalDate;
    private XSSFCellStyle styleDateTime;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ExcelBuilder() {
        MetaClass metaClass;
        String string;
        this.headerType = string = "labels";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static ExcelBuilder of(OutputStream outstream) {
        ExcelBuilder eb = new ExcelBuilder();
        OutputStream outputStream = outstream;
        eb.setOutputStream(outputStream);
        return eb;
    }

    public ExcelBuilder build() {
        XSSFSheet xSSFSheet;
        XSSFWorkbook xSSFWorkbook;
        this.workbook = xSSFWorkbook = new XSSFWorkbook();
        this.sheet = xSSFSheet = this.workbook.createSheet(SHEET_NAME);
        XSSFCreationHelper xSSFCreationHelper = this.sheet.getWorkbook().getCreationHelper();
        this.createHelper = xSSFCreationHelper;
        this.initDefaultStyles();
        return this;
    }

    public void initDefaultStyles() {
        XSSFCellStyle xSSFCellStyle;
        XSSFCellStyle xSSFCellStyle2;
        XSSFCellStyle xSSFCellStyle3;
        XSSFCellStyle xSSFCellStyle4;
        this.styleMoney = xSSFCellStyle4 = this.workbook.createCellStyle();
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.RIGHT;
        this.styleMoney.setAlignment(horizontalAlignment);
        boolean bl = true;
        this.styleMoney.setWrapText(bl);
        XSSFDataFormat xformat = this.workbook.createDataFormat();
        this.styleMoney.setDataFormat(xformat.getFormat("#,##0.00"));
        this.styleLocalDate = xSSFCellStyle3 = this.workbook.createCellStyle();
        this.styleLocalDate.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy"));
        this.styleDateTime = xSSFCellStyle2 = this.workbook.createCellStyle();
        this.styleDateTime.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy h:mm"));
        this.styleHeader = xSSFCellStyle = this.workbook.createCellStyle();
        this.styleHeader.setFillForegroundColor(ExcelBuilder.parseColor("#F5F5F5"));
        this.styleHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.styleHeader.setBorderBottom(BorderStyle.MEDIUM);
        this.styleHeader.getDataFormatString();
        XSSFFont font = this.workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        this.styleHeader.setFont((Font)font);
    }

    public ExcelBuilder writeData(Collection<Map> dataList) {
        this.createHeader(dataList);
        Reference rowIdx = new Reference((Object)1);
        public final class _writeData_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rowIdx;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _writeData_closure1(Object _outerInstance, Object _thisObject, Reference rowIdx) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rowIdx = reference = rowIdx;
            }

            public Row doCall(Map rowData, int i) {
                Reference rowData2 = new Reference((Object)rowData);
                public final class _closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference rowData;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure5(Object _outerInstance, Object _thisObject, Reference rowData) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.rowData = reference = rowData;
                    }

                    public Object doCall(Object it) {
                        return PropertyTools.getProperty((Object)this.rowData.get(), (String)ShortTypeHandling.castToString((Object)it));
                    }

                    @Generated
                    public Map getRowData() {
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.rowData.get(), Map.class);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                List vals = DefaultGroovyMethods.collect(((ExcelBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExcelBuilder.class)).getIncludes(), (Closure)new _closure5((Object)this, this.getThisObject(), rowData2));
                Row row = ((ExcelBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExcelBuilder.class)).createRow(DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)((Number)ScriptBytecodeAdapter.castToType((Object)this.rowIdx.get(), Number.class)), (Number)i)), vals);
                return row;
            }

            @Generated
            public Row call(Map rowData, int i) {
                Reference rowData2 = new Reference((Object)rowData);
                return this.doCall((Map)rowData2.get(), i);
            }

            @Generated
            public Integer getRowIdx() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.rowIdx.get(), Integer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeData_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex(dataList, (Closure)new _writeData_closure1(this, this, rowIdx));
        return this;
    }

    public ExcelBuilder createHeader(Collection<Map> dataList) {
        if (dataList instanceof MetaMapList && DefaultTypeTransformation.booleanUnbox((Object)((MetaMapList)ScriptBytecodeAdapter.castToType(dataList, MetaMapList.class)).getMetaEntity())) {
            Map metaProps = ((MetaMapList)ScriptBytecodeAdapter.castToType(dataList, MetaMapList.class)).getMetaEntity().flatten();
            if (!DefaultTypeTransformation.booleanUnbox(this.includes)) {
                List list;
                this.includes = list = (List)ScriptBytecodeAdapter.asType(metaProps.keySet(), List.class);
            }
            if (!DefaultTypeTransformation.booleanUnbox(this.headers)) {
                List list;
                public final class _createHeader_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _createHeader_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public String doCall(Object it) {
                        return ((MetaProp)it).getTitle();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public String doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createHeader_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                this.headers = list = DefaultGroovyMethods.collect(metaProps.values(), (Closure)new _createHeader_closure2(this, this));
            }
            this.writeHeader(this.headers);
        } else {
            Map firstRow = (Map)DefaultGroovyMethods.getAt(dataList, (int)0);
            Map flatRow = MapFlattener.of((Map)firstRow).convertObjectToString(false).flatten();
            if (!DefaultTypeTransformation.booleanUnbox(this.includes)) {
                List list;
                this.includes = list = DefaultGroovyMethods.toList(flatRow.keySet());
            }
            this.writeHeader(this.includes);
        }
        return this;
    }

    public Row createRow(int rowIndex, Collection rowData) {
        Reference row = new Reference((Object)this.sheet.createRow(rowIndex));
        public final class _createRow_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference row;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createRow_closure3(Object _outerInstance, Object _thisObject, Reference row) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.row = reference = row;
            }

            public Cell doCall(Object field, int i) {
                return ((ExcelBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExcelBuilder.class)).createCell((Row)ScriptBytecodeAdapter.castToType((Object)this.row.get(), Row.class), i, field);
            }

            @Generated
            public Cell call(Object field, int i) {
                return this.doCall(field, i);
            }

            @Generated
            public Row getRow() {
                return (Row)ScriptBytecodeAdapter.castToType((Object)this.row.get(), Row.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createRow_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex((Collection)rowData, (Closure)new _createRow_closure3(this, this, row));
        return (XSSFRow)row.get();
    }

    public Cell createCell(Row row, int columnIndex, Object value) {
        Cell cell = row.createCell(columnIndex);
        this.setCellValue(cell, value);
        return cell;
    }

    public Cell setCellValue(Cell cell, Object value) {
        if (value == null) {
            cell.setBlank();
            return cell;
        }
        if (value instanceof BigDecimal) {
            cell.setCellValue(((Number)ScriptBytecodeAdapter.castToType((Object)value, Number.class)).doubleValue());
            cell.setCellStyle((CellStyle)this.styleMoney);
            return cell;
        }
        if (value instanceof Number) {
            cell.setCellValue(((Number)ScriptBytecodeAdapter.castToType((Object)value, Number.class)).doubleValue());
            return cell;
        }
        if (value instanceof LocalDate) {
            cell.setCellValue((LocalDate)ScriptBytecodeAdapter.castToType((Object)value, LocalDate.class));
            cell.setCellStyle((CellStyle)this.styleLocalDate);
            return cell;
        }
        if (value instanceof LocalDateTime) {
            cell.setCellValue(((LocalDateTime)value).truncatedTo(ChronoUnit.SECONDS));
            cell.setCellStyle((CellStyle)this.styleDateTime);
            return cell;
        }
        if (value instanceof Date) {
            cell.setCellValue((Date)ScriptBytecodeAdapter.castToType((Object)value, Date.class));
            cell.setCellStyle((CellStyle)this.styleDateTime);
            return cell;
        }
        if (value instanceof Calendar) {
            cell.setCellValue((Calendar)ScriptBytecodeAdapter.castToType((Object)value, Calendar.class));
            return cell;
        }
        if (value instanceof Boolean) {
            cell.setCellValue(Integer.valueOf(DefaultTypeTransformation.booleanUnbox((Object)value) ? 1 : 0).doubleValue());
            return cell;
        }
        if (value instanceof Map && ((Map)value).containsKey("name")) {
            cell.setCellValue(DefaultGroovyMethods.toString((Object)DefaultGroovyMethods.getAt((Object)value, (String)"name")));
            return cell;
        }
        cell.setCellValue(DefaultGroovyMethods.toString((Object)value));
        return cell;
    }

    public ExcelBuilder writeHeader(Collection<String> titles) {
        Reference header = new Reference((Object)this.sheet.createRow(0));
        public final class _writeHeader_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference header;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _writeHeader_closure4(Object _outerInstance, Object _thisObject, Reference header) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.header = reference = header;
            }

            public Object doCall(String title, int i) {
                XSSFCell headerCell = ((XSSFRow)this.header.get()).createCell(i);
                headerCell.setCellValue(title);
                headerCell.setCellStyle((CellStyle)((ExcelBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExcelBuilder.class)).getStyleHeader());
                return null;
            }

            @Generated
            public Object call(String title, int i) {
                return this.doCall(title, i);
            }

            @Generated
            public XSSFRow getHeader() {
                return (XSSFRow)ScriptBytecodeAdapter.castToType((Object)this.header.get(), XSSFRow.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeHeader_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex(titles, (Closure)new _writeHeader_closure4(this, this, header));
        return this;
    }

    public ExcelBuilder writeOut() {
        this.workbook.write(this.outputStream);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExcelBuilder writeOutAndClose() {
        try {
            try {
                this.workbook.write(this.outputStream);
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
            if (!(this.outputStream != null)) return this;
        }
        catch (Throwable throwable) {
            if (!(this.outputStream != null)) throw throwable;
            try {
                this.outputStream.close();
                throw throwable;
            }
            catch (IOException ignored) {
            }
            throw throwable;
        }
        try {
            this.outputStream.close();
            return this;
        }
        catch (IOException ignored) {
        }
        return this;
    }

    public static XSSFColor parseColor(String hex) {
        if (hex == null) {
            throw (Throwable)new IllegalArgumentException("Please, provide the color in '#abcdef' hex string format");
        }
        Matcher match = Pattern.compile("#([\\dA-F]{2})([\\dA-F]{2})([\\dA-F]{2})").matcher(hex.toUpperCase());
        if (!match.matches()) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Cannot parse color ", (CharSequence)hex), (CharSequence)". Please, provide the color in '#abcdef' hex string format"));
        }
        byte red = (byte)Integer.parseInt(match.group(1), 16);
        byte green = (byte)Integer.parseInt(match.group(2), 16);
        byte blue = (byte)Integer.parseInt(match.group(3), 16);
        return new XSSFColor(new byte[]{red, green, blue}, (IndexedColorMap)INDEXED_COLOR_MAP);
    }

    @Generated
    public ExcelBuilder includes(List<String> includes) {
        List<String> list = includes;
        this.includes = list;
        return this;
    }

    @Generated
    public ExcelBuilder headerType(String headerType) {
        String string;
        this.headerType = string = headerType;
        return this;
    }

    @Generated
    public ExcelBuilder headers(List<String> headers) {
        List<String> list = headers;
        this.headers = list;
        return this;
    }

    @Generated
    public ExcelBuilder outputStream(OutputStream outputStream) {
        OutputStream outputStream2;
        this.outputStream = outputStream2 = outputStream;
        return this;
    }

    public static /* synthetic */ List<String> pfaccess$0(ExcelBuilder $that) {
        return $that.includes;
    }

    public static /* synthetic */ XSSFCellStyle pfaccess$1(ExcelBuilder $that) {
        return $that.styleHeader;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExcelBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        DefaultIndexedColorMap defaultIndexedColorMap;
        INDEXED_COLOR_MAP = defaultIndexedColorMap = new DefaultIndexedColorMap();
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public void setIncludes(List<String> list) {
        this.includes = list;
    }

    @Generated
    public String getConfigKey() {
        return this.configKey;
    }

    @Generated
    public void setConfigKey(String string) {
        this.configKey = string;
    }

    @Generated
    public String getHeaderType() {
        return this.headerType;
    }

    @Generated
    public void setHeaderType(String string) {
        this.headerType = string;
    }

    @Generated
    public List<String> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setHeaders(List<String> list) {
        this.headers = list;
    }

    @Generated
    public XSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    @Generated
    public void setWorkbook(XSSFWorkbook xSSFWorkbook) {
        this.workbook = xSSFWorkbook;
    }

    @Generated
    public XSSFSheet getSheet() {
        return this.sheet;
    }

    @Generated
    public void setSheet(XSSFSheet xSSFSheet) {
        this.sheet = xSSFSheet;
    }

    @Generated
    public CreationHelper getCreateHelper() {
        return this.createHelper;
    }

    @Generated
    public void setCreateHelper(CreationHelper creationHelper) {
        this.createHelper = creationHelper;
    }

    @Generated
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Generated
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Generated
    public XSSFCellStyle getStyleHeader() {
        return this.styleHeader;
    }

    @Generated
    public void setStyleHeader(XSSFCellStyle xSSFCellStyle) {
        this.styleHeader = xSSFCellStyle;
    }

    @Generated
    public XSSFCellStyle getStyleMoney() {
        return this.styleMoney;
    }

    @Generated
    public void setStyleMoney(XSSFCellStyle xSSFCellStyle) {
        this.styleMoney = xSSFCellStyle;
    }

    @Generated
    public XSSFCellStyle getStyleLocalDate() {
        return this.styleLocalDate;
    }

    @Generated
    public void setStyleLocalDate(XSSFCellStyle xSSFCellStyle) {
        this.styleLocalDate = xSSFCellStyle;
    }

    @Generated
    public XSSFCellStyle getStyleDateTime() {
        return this.styleDateTime;
    }

    @Generated
    public void setStyleDateTime(XSSFCellStyle xSSFCellStyle) {
        this.styleDateTime = xSSFCellStyle;
    }
}

