/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rest.gorm.controller;

import gorm.tools.job.SyncJobArgs;
import gorm.tools.job.SyncJobEntity;
import gorm.tools.job.SyncJobService;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.RepoLookup;
import gorm.tools.repository.model.DataOp;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import yakworks.api.problem.GenericProblem;
import yakworks.api.problem.Problem;
import yakworks.commons.extensions.MapExtensions;
import yakworks.etl.csv.CsvToMapTransformer;
import yakworks.gorm.api.IncludesConfig;
import yakworks.gorm.api.IncludesKey;
import yakworks.spring.AppCtx;

public class BulkControllerSupport<D>
implements GroovyObject {
    @Autowired
    private SyncJobService syncJobService;
    @Autowired
    private CsvToMapTransformer csvToMapTransformer;
    @Autowired
    private IncludesConfig includesConfig;
    @Autowired
    private ProblemHandler problemHandler;
    private Class<D> entityClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public BulkControllerSupport(Class<D> entityClass) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Class<D> clazz = entityClass;
        this.entityClass = clazz;
    }

    public static <D> BulkControllerSupport<D> of(Class<D> entityClass) {
        BulkControllerSupport<D> bcs = new BulkControllerSupport<D>(entityClass);
        AppCtx.autowire(bcs);
        return bcs;
    }

    public SyncJobEntity process(List<Map> dataList, SyncJobArgs syncJobArgs) {
        Long jobId = null;
        if (DefaultTypeTransformation.booleanUnbox(syncJobArgs.getParams().get("attachmentId"))) {
            Long l;
            jobId = l = this.doBulkCsv(syncJobArgs);
        } else {
            Long l;
            boolean bl = MapExtensions.getBoolean((Map)syncJobArgs.getParams(), (Object)"async", (boolean)false);
            syncJobArgs.setAsync(Boolean.valueOf(bl));
            jobId = l = this.getRepo().bulk(dataList, syncJobArgs);
        }
        SyncJobEntity job = this.syncJobService.getJob((Serializable)jobId);
        return job;
    }

    public Long doBulkCsv(SyncJobArgs syncJobArgs) {
        Map params = syncJobArgs.getParams();
        boolean bl = MapExtensions.getBoolean((Map)params, (Object)"savePayload", (boolean)false);
        syncJobArgs.setSavePayload(Boolean.valueOf(bl));
        List<Map> dataList = this.transformCsvToBulkList(params);
        return this.getRepo().bulk(dataList, syncJobArgs);
    }

    public SyncJobArgs setupSyncJobArgs(DataOp dataOp, Map params, String sourceId) {
        Map includesMap = this.includesConfig.getIncludes(this.entityClass);
        List bulkIncludes = IncludesConfig.getFieldIncludes((Map)includesMap, (List)ScriptBytecodeAdapter.createList((Object[])new Object[]{IncludesKey.bulk.name()}));
        List bulkErrorIncludes = (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)includesMap, (Object)"bulkError"), List.class);
        SyncJobArgs syncJobArgs = SyncJobArgs.withParams((Map)params);
        DataOp dataOp2 = dataOp;
        syncJobArgs.setOp(dataOp2);
        List list = bulkIncludes;
        syncJobArgs.setIncludes(list);
        List list2 = bulkErrorIncludes;
        syncJobArgs.setErrorIncludes(list2);
        String string = sourceId;
        syncJobArgs.setSourceId(string);
        return syncJobArgs;
    }

    public List<Map> transformCsvToBulkList(Map params) {
        return this.csvToMapTransformer.process(params);
    }

    public GormRepo<D> getRepo() {
        return RepoLookup.findRepo(this.getEntityClass());
    }

    public Problem handleBulkOperationException(HttpServletRequest req, Throwable e) {
        GenericProblem apiError = this.problemHandler.handleException(this.getEntityClass(), e);
        if (apiError.getStatus().getCode() == 500) {
            Object v0;
            String requestInfo = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getRequestURI(), req.getMethod(), req.getQueryString()}, new String[]{"requestURI=[", "], method=[", "], queryString=[", "]"}));
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{requestInfo, apiError.getCause()}, new String[]{"\u26d4\ufe0f \ud83d\udc49 Bulk operation exception \u26d4\ufe0f \n ", " \n ", "?.message"})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        return apiError;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BulkControllerSupport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rest.gorm.controller.BulkControllerSupport");
    }

    @Generated
    public SyncJobService getSyncJobService() {
        return this.syncJobService;
    }

    @Generated
    public void setSyncJobService(SyncJobService syncJobService) {
        this.syncJobService = syncJobService;
    }

    @Generated
    public CsvToMapTransformer getCsvToMapTransformer() {
        return this.csvToMapTransformer;
    }

    @Generated
    public void setCsvToMapTransformer(CsvToMapTransformer csvToMapTransformer) {
        this.csvToMapTransformer = csvToMapTransformer;
    }

    @Generated
    public IncludesConfig getIncludesConfig() {
        return this.includesConfig;
    }

    @Generated
    public void setIncludesConfig(IncludesConfig includesConfig) {
        this.includesConfig = includesConfig;
    }

    @Generated
    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Generated
    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    @Generated
    public Class<D> getEntityClass() {
        return this.entityClass;
    }

    @Generated
    public void setEntityClass(Class<D> clazz) {
        this.entityClass = clazz;
    }
}

