/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.openapi;

import gorm.tools.openapi.ApiSchemaEntity;
import gorm.tools.openapi.GormToSchema;
import gorm.tools.openapi.YamlUtils;
import gorm.tools.rest.ast.RestApiAstUtils;
import gorm.tools.support.ConfigAware;
import gorm.tools.utils.GormMetaUtils;
import grails.config.Config;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.beans.factory.annotation.Autowired;
import yakworks.commons.io.FileSystemUtils;
import yakworks.commons.io.FileUtil;
import yakworks.commons.lang.NameUtils;
import yakworks.commons.util.BuildSupport;

public class OpenApiGenerator
implements ConfigAware,
ConfigAware.Trait.FieldHelper,
GroovyObject {
    private static final String API_SRC = "src/api-docs";
    private static final String API_BUILD = "build/api-docs";
    @Autowired
    private GormToSchema gormToSchema;
    private Config gorm_tools_support_ConfigAware__config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public OpenApiGenerator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ConfigAware.Trait.Helper.$init$((ConfigAware)this);
    }

    public void generate() {
        Path buildDest = this.makeBuildDirs();
        Path srcPath = this.getApiSrcPath();
        FileSystemUtils.copyRecursively((Path)srcPath, (Path)buildDest);
        this.generateModels();
        this.genOpenapiYaml(ScriptBytecodeAdapter.createList((Object[])new Object[]{"rally", "security", "ar"}));
    }

    public Path getApiSrcPath(String sub) {
        String string = BuildSupport.getGradleProjectDir();
        Path path = Paths.get(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "", API_SRC);
        return DefaultTypeTransformation.booleanUnbox((Object)sub) ? path.resolve(sub) : path;
    }

    public Path getApiBuildPath(String sub) {
        String string = BuildSupport.getGradleProjectDir();
        Path path = Paths.get(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "", API_BUILD);
        return DefaultTypeTransformation.booleanUnbox((Object)sub) ? path.resolve(sub) : path;
    }

    public Path makeBuildDirs() {
        Path path = this.getApiBuildPath();
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    public void genOpenapiYaml(List namespaceList) {
        Path openapiYaml = this.getApiSrcPath("openapi/api.yaml");
        Map api = (Map)ScriptBytecodeAdapter.castToType((Object)YamlUtils.loadYaml(openapiYaml), Map.class);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Map map = api;
            valueRecorder.record((Object)map, 8);
            Object object = DefaultGroovyMethods.getAt((Map)map, (Object)"openapi");
            valueRecorder.record(object, -1);
            valueRecorder.record(object, 11);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)"3.0.3");
            valueRecorder.record((Object)bl, -1);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert api['openapi'] == '3.0.3'", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        this.spinThroughRestApi(api, namespaceList);
    }

    public void spinThroughRestApi(Map api, List namespaceList) {
        Map restApiPaths = (Map)ScriptBytecodeAdapter.castToType((Object)this.getConfig().getProperty("api.paths", Map.class), Map.class);
        List tags = (List)ScriptBytecodeAdapter.castToType(api.get("tags"), List.class);
        LinkedHashMap xTagGroups = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        Reference namespaces = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)this.getConfig().getProperty("api.namespaces", Map.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class)));
        Object entry = null;
        Iterator iterator = DefaultGroovyMethods.iterator((Object)restApiPaths);
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (((Map)namespaces.get()).containsKey(((Map.Entry)entry).getKey())) {
                String namespace = ShortTypeHandling.castToString(((Map.Entry)entry).getKey());
                Object epoint = null;
                Iterator iterator2 = DefaultGroovyMethods.iterator((Object)((Map)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), Map.class)));
                while (iterator2.hasNext()) {
                    epoint = iterator2.next();
                    String endpoint = ShortTypeHandling.castToString(((Map.Entry)epoint).getKey());
                    this.processEndpoint(api, endpoint, namespace, (Map)ScriptBytecodeAdapter.castToType(((Map.Entry)epoint).getValue(), Map.class), xTagGroups, tags);
                }
                continue;
            }
            String pathName = ShortTypeHandling.castToString(((Map.Entry)entry).getKey());
            Map pathCfg = (Map)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), Map.class);
            Map pathParts = RestApiAstUtils.splitPath(pathName, pathCfg);
            String endpoint = ShortTypeHandling.castToString(pathParts.get("name"));
            String namespace = ShortTypeHandling.castToString(pathParts.get("namespace"));
            this.processEndpoint(api, endpoint, namespace, pathCfg, xTagGroups, tags);
        }
        List list = tags;
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)api, (String)"tags");
        Reference xTagGroupsList = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _spinThroughRestApi_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference xTagGroupsList;
            private /* synthetic */ Reference namespaces;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _spinThroughRestApi_closure1(Object _outerInstance, Object _thisObject, Reference xTagGroupsList, Reference namespaces) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.xTagGroupsList = reference2 = xTagGroupsList;
                this.namespaces = reference = namespaces;
            }

            public Object doCall(Object k, Object v) {
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.xTagGroupsList.get(), List.class)), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.namespaces.get(), Map.class)), (Object)k), "tags", (List)ScriptBytecodeAdapter.asType((Object)v, List.class)}));
            }

            public Object call(Object k, Object v) {
                return this.doCall(k, v);
            }

            @Generated
            public Object getxTagGroupsList() {
                return this.xTagGroupsList.get();
            }

            @Generated
            public Map getNamespaces() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.namespaces.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _spinThroughRestApi_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Map)xTagGroups, (Closure)new _spinThroughRestApi_closure1(this, this, xTagGroupsList, namespaces));
        List list2 = (List)xTagGroupsList.get();
        ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)api, (String)"putAt", (Object[])new Object[]{"x-tagGroups", list2});
        Path buildOpenapiYaml = this.getApiBuildPath().resolve("openapi/api.yaml");
        YamlUtils.saveYaml(buildOpenapiYaml, api);
    }

    public void processEndpoint(Map api, String endpoint, String namespace, Map pathMap, Map xTagGroups, List tags) {
        LinkedHashMap tagEntry = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", endpoint}), LinkedHashMap.class);
        if (DefaultTypeTransformation.booleanUnbox(pathMap.get("description"))) {
            Object v = pathMap.get("description");
            ScriptBytecodeAdapter.setProperty(v, null, (Object)tagEntry, (String)"description");
        }
        DefaultGroovyMethods.leftShift((List)tags, (Object)tagEntry);
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)xTagGroups, (Object)namespace))) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)xTagGroups, (String)"putAt", (Object[])new Object[]{namespace, list});
        }
        ((List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)xTagGroups, (Object)namespace), List.class)).add(endpoint);
        try {
            this.createPaths(api, endpoint, namespace, pathMap);
        }
        catch (Exception e) {
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{endpoint}, new String[]{"Error on ", ""}));
            throw (Throwable)new IllegalArgumentException(msg, (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
        }
    }

    public Map createPaths(Map api, String endpoint, String namespace, Map restConfig) {
        Map paths = (Map)ScriptBytecodeAdapter.castToType(api.get("paths"), Map.class);
        String namespacePrefix = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)namespace) ? new GStringImpl(new Object[]{namespace}, new String[]{"", "/"}) : ""));
        String pathKey = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespacePrefix, endpoint}, new String[]{"/", "", ""}));
        String pathKeyId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathKey}, new String[]{"", "/{id}"}));
        String pathKeyPrefix = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespacePrefix}, new String[]{"./paths/", ""}));
        String pathFileBase = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathKeyPrefix, endpoint}, new String[]{"", "", ""}));
        Files.createDirectories(this.getApiBuildPath("openapi").resolve(pathKeyPrefix), new FileAttribute[0]);
        String capitalName = NameUtils.getClassNameFromKebabCase((String)endpoint);
        String modelName = NameUtils.getShortName((String)ShortTypeHandling.castToString(restConfig.get("entityClass")));
        String baseDir = DefaultTypeTransformation.booleanUnbox((Object)namespace) ? "../../" : "../";
        LinkedHashMap model = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"endpoint", endpoint, "name", endpoint, "capitalName", capitalName, "modelName", modelName, "namespace", namespace, "baseDir", baseDir}), LinkedHashMap.class);
        String filePathRef = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathFileBase}, new String[]{"", ".yaml"}));
        this.processTplFile("paths/tpl.yaml", filePathRef, model);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"$ref", filePathRef});
        ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)paths, (String)"putAt", (Object[])new Object[]{pathKey, map});
        GStringImpl gStringImpl = new GStringImpl(new Object[]{pathFileBase}, new String[]{"", "@{id}.yaml"});
        filePathRef = ShortTypeHandling.castToString((Object)gStringImpl);
        this.processTplFile("paths/tpl@{id}.yaml", filePathRef, model);
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"$ref", filePathRef});
        ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)paths, (String)"putAt", (Object[])new Object[]{pathKeyId, map2});
        if (DefaultTypeTransformation.booleanUnbox(restConfig.get("bulkOps"))) {
            Map map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"$ref", new GStringImpl(new Object[]{pathFileBase}, new String[]{"", "@bulk.yaml"}).toString()});
            ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)paths, (String)"putAt", (Object[])new Object[]{new GStringImpl(new Object[]{pathKey}, new String[]{"", "/bulk"}), map3});
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{pathFileBase}, new String[]{"", "@bulk.yaml"});
            filePathRef = ShortTypeHandling.castToString((Object)gStringImpl2);
            this.processTplFile("paths/tpl@bulk.yaml", filePathRef, model);
            return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
    }

    public void processTplFile(String srcPath, String outputPath, Map model) {
        String string;
        Path tplFile = this.getApiSrcPath("openapi").resolve(srcPath);
        String ymlTpl = FileUtil.readFileToString((File)tplFile.toFile());
        ymlTpl = string = FileUtil.parseStringAsGString((String)ymlTpl, (Map)model);
        Path outPath = this.getApiBuildPath("openapi").resolve(outputPath);
        Files.write(outPath, ymlTpl.getBytes(), new OpenOption[0]);
    }

    public void modifyForAllowedOps(String filePathRef, Map restConfig) {
        List allowedOps = (List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)restConfig, (Object)"restConfig"), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)allowedOps)) {
            return;
        }
        Path yamlPath = this.getApiBuildPath("openapi").resolve(filePathRef);
        Map tplYaml = (Map)ScriptBytecodeAdapter.castToType((Object)YamlUtils.loadYaml(yamlPath), Map.class);
        if (!allowedOps.contains("create")) {
            tplYaml.remove("post");
        }
        if (!allowedOps.contains("update")) {
            tplYaml.remove("put");
        }
        if (!allowedOps.contains("delete")) {
            tplYaml.remove("delete");
        }
    }

    public void generateModels() {
        MappingContext mapctx = GormMetaUtils.getMappingContext();
        PersistentEntity entity = null;
        Iterator iterator = mapctx.getPersistentEntities().iterator();
        while (iterator.hasNext()) {
            entity = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentEntity.class);
            Map map = this.gormToSchema.generate(entity, ApiSchemaEntity.CruType.Read);
            Map mapCreate = this.gormToSchema.generate(entity, ApiSchemaEntity.CruType.Create);
            Map mapUpdate = this.gormToSchema.generate(entity, ApiSchemaEntity.CruType.Update);
            this.writeYmlModel(entity.getJavaClass(), map, ApiSchemaEntity.CruType.Read);
            this.writeYmlModel(entity.getJavaClass(), mapCreate, ApiSchemaEntity.CruType.Create);
            this.writeYmlModel(entity.getJavaClass(), mapUpdate, ApiSchemaEntity.CruType.Update);
        }
    }

    public Path writeYmlModel(Class clazz, Map schemaMap, ApiSchemaEntity.CruType type) {
        String suffix = ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareEqual((Object)((Object)type), (Object)((Object)ApiSchemaEntity.CruType.Read)) ? "" : new GStringImpl(new Object[]{type}, new String[]{"_", ""})));
        Files.createDirectories(this.getApiBuildPath("openapi/models"), new FileAttribute[0]);
        Path path = this.getApiBuildPath(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{clazz.getSimpleName(), suffix}, new String[]{"openapi/models/", "", ".yaml"})));
        YamlUtils.saveYaml(path, schemaMap);
        return path;
    }

    @Traits.TraitBridge(traitClass=ConfigAware.class, desc="()Lgrails/config/Config;")
    public Config getConfig() {
        return ConfigAware.Trait.Helper.getConfig((ConfigAware)this);
    }

    public /* synthetic */ Config gorm_tools_support_ConfigAwaretrait$super$getConfig() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Config)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getConfig", (Object)new Object[0]), Config.class);
        }
        return (Config)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getConfig"), Config.class);
    }

    @Traits.TraitBridge(traitClass=ConfigAware.class, desc="(Lgrails/config/Config;)V")
    public void setConfiguration(Config param1) {
        ConfigAware.Trait.Helper.setConfiguration((ConfigAware)this, (Config)param1);
    }

    public /* synthetic */ void gorm_tools_support_ConfigAwaretrait$super$setConfiguration(Config param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setConfiguration", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setConfiguration", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=ConfigAware.class, desc="(Lgrails/config/Config;)V")
    public void setConfig(Config param1) {
        ConfigAware.Trait.Helper.setConfig((ConfigAware)this, (Config)param1);
    }

    public /* synthetic */ void gorm_tools_support_ConfigAwaretrait$super$setConfig(Config param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setConfig", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setConfig", (Object[])new Object[]{param0});
        }
    }

    static {
        ConfigAware.Trait.Helper.$static$init$(OpenApiGenerator.class);
    }

    public Config gorm_tools_support_ConfigAware__config$get() {
        return this.gorm_tools_support_ConfigAware__config;
    }

    public Config gorm_tools_support_ConfigAware__config$set(Config val) {
        Config config;
        this.gorm_tools_support_ConfigAware__config = config = val;
        return config;
    }

    @Generated
    public Path getApiSrcPath() {
        return this.getApiSrcPath(null);
    }

    @Generated
    public Path getApiBuildPath() {
        return this.getApiBuildPath(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OpenApiGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public static String getAPI_SRC() {
        return API_SRC;
    }

    @Generated
    public static String getAPI_BUILD() {
        return API_BUILD;
    }

    @Generated
    public GormToSchema getGormToSchema() {
        return this.gormToSchema;
    }

    @Generated
    public void setGormToSchema(GormToSchema gormToSchema) {
        this.gormToSchema = gormToSchema;
    }
}

