/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.openapi;

import gorm.tools.openapi.ApiSchemaEntity;
import gorm.tools.openapi.GormToSchema;
import gorm.tools.openapi.YamlUtils;
import gorm.tools.rest.ast.RestApiAstUtils;
import gorm.tools.support.ConfigAware;
import gorm.tools.utils.GormMetaUtils;
import grails.config.Config;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.yaml.snakeyaml.Yaml;
import yakworks.commons.io.FileSystemUtils;
import yakworks.commons.io.FileUtil;
import yakworks.commons.lang.NameUtils;
import yakworks.commons.map.Maps;
import yakworks.commons.util.BuildSupport;

public class OpenApiGenerator
implements ConfigAware,
ConfigAware.Trait.FieldHelper,
GroovyObject {
    private String apiSrc;
    private String apiBuild;
    private List namespaceList;
    @Autowired
    private GormToSchema gormToSchema;
    private Config gorm_tools_support_ConfigAware__config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public OpenApiGenerator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ConfigAware.Trait.Helper.$init$((ConfigAware)this);
    }

    public void generate(List nsList) {
        Path buildDest = this.makeBuildDirs();
        Path srcPath = this.getApiSrcPath();
        FileSystemUtils.copyRecursively((Path)srcPath, (Path)buildDest);
        this.generateModels();
        List list = nsList;
        this.genOpenapiYaml(DefaultTypeTransformation.booleanUnbox((Object)list) ? list : this.namespaceList);
    }

    public Path getApiSrcPath(String sub) {
        String string = BuildSupport.getGradleRootProjectDir();
        Path path = Paths.get(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "", this.apiSrc);
        return DefaultTypeTransformation.booleanUnbox((Object)sub) ? path.resolve(sub) : path;
    }

    public Path getApiBuildPath(String sub) {
        String string = BuildSupport.getGradleRootProjectDir();
        Path path = Paths.get(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "", this.apiBuild);
        return DefaultTypeTransformation.booleanUnbox((Object)sub) ? path.resolve(sub) : path;
    }

    public Path makeBuildDirs() {
        Path path = this.getApiBuildPath();
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    public void genOpenapiYaml(List namespaceList) {
        Path openapiYaml = this.getApiSrcPath("api.yaml");
        Map api = (Map)ScriptBytecodeAdapter.castToType((Object)YamlUtils.loadYaml(openapiYaml), Map.class);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Map map = api;
            valueRecorder.record((Object)map, 8);
            Object object = DefaultGroovyMethods.getAt((Map)map, (Object)"openapi");
            valueRecorder.record(object, -1);
            valueRecorder.record(object, 11);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)"3.0.3");
            valueRecorder.record((Object)bl, -1);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert api['openapi'] == '3.0.3'", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        this.spinThroughRestApi(api, namespaceList);
    }

    public void spinThroughRestApi(Map api, List namespaceList) {
        Map restApiPaths = (Map)ScriptBytecodeAdapter.castToType((Object)this.getConfig().getProperty("api.paths", Map.class), Map.class);
        List tags = (List)ScriptBytecodeAdapter.castToType(api.get("tags"), List.class);
        LinkedHashMap newTagGroups = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        Map namespaces = (Map)ScriptBytecodeAdapter.castToType((Object)this.getConfig().getProperty("api.namespaces", Map.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class);
        Object entry = null;
        Iterator iterator = DefaultGroovyMethods.iterator((Object)restApiPaths);
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (namespaces.containsKey(((Map.Entry)entry).getKey())) {
                String namespace = ShortTypeHandling.castToString(((Map.Entry)entry).getKey());
                if (DefaultTypeTransformation.booleanUnbox((Object)namespaceList) && !namespaceList.contains(namespace)) continue;
                Object epoint = null;
                Iterator iterator2 = DefaultGroovyMethods.iterator((Object)((Map)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), Map.class)));
                while (iterator2.hasNext()) {
                    epoint = iterator2.next();
                    String endpoint = ShortTypeHandling.castToString(((Map.Entry)epoint).getKey());
                    this.processEndpoint(api, endpoint, namespace, (Map)ScriptBytecodeAdapter.castToType(((Map.Entry)epoint).getValue(), Map.class), newTagGroups, tags);
                }
                continue;
            }
            String pathName = ShortTypeHandling.castToString(((Map.Entry)entry).getKey());
            Map pathCfg = (Map)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), Map.class);
            Map pathParts = RestApiAstUtils.splitPath(pathName, pathCfg);
            String endpoint = ShortTypeHandling.castToString(pathParts.get("name"));
            String namespace = ShortTypeHandling.castToString(pathParts.get("namespace"));
            if (DefaultTypeTransformation.booleanUnbox((Object)namespace) && DefaultTypeTransformation.booleanUnbox((Object)namespaceList) && !namespaceList.contains(namespace)) continue;
            this.processEndpoint(api, endpoint, namespace, pathCfg, newTagGroups, tags);
        }
        List list = tags;
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)api, (String)"tags");
        this.mergeTagGroups(api, namespaces, newTagGroups);
        Path buildOpenapiYaml = this.getApiBuildPath().resolve("api.yaml");
        YamlUtils.saveYaml(buildOpenapiYaml, api);
    }

    /*
     * WARNING - void declaration
     */
    public void mergeTagGroups(Map api, Map namespaces, Map<String, List> newTagGroups) {
        void var3_3;
        Reference namespaces2 = new Reference((Object)namespaces);
        Reference newTagGroups2 = new Reference((Object)var3_3);
        List xTagGroups = (List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)api, (Object)"x-tagGroups"), List.class);
        LinkedHashMap mergedTagGroups = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        public final class _mergeTagGroups_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference newTagGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mergeTagGroups_closure1(Object _outerInstance, Object _thisObject, Reference newTagGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.newTagGroups = reference = newTagGroups;
            }

            public Object doCall(Object it) {
                List tags = (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)it, (String)"tags"), List.class);
                String name = (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)it, (String)"name"), String.class);
                if (((Map)this.newTagGroups.get()).containsKey(name)) {
                    ((List)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.newTagGroups.get(), Map.class)), (Object)name)).addAll(tags);
                } else {
                    List list = tags;
                    ScriptBytecodeAdapter.invokeMethodN(_mergeTagGroups_closure1.class, (Object)this.newTagGroups.get(), (String)"putAt", (Object[])new Object[]{name, list});
                }
                List list = DefaultGroovyMethods.sort((Iterable)DefaultGroovyMethods.unique((List)((List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.newTagGroups.get(), Map.class)), (Object)name), List.class))));
                ScriptBytecodeAdapter.invokeMethodN(_mergeTagGroups_closure1.class, (Object)this.newTagGroups.get(), (String)"putAt", (Object[])new Object[]{name, list});
                return list;
            }

            @Generated
            public Map getNewTagGroups() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.newTagGroups.get(), Map.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergeTagGroups_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)xTagGroups, (Closure)new _mergeTagGroups_closure1(this, this, newTagGroups2));
        Reference xTagGroupsList = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _mergeTagGroups_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference xTagGroupsList;
            private /* synthetic */ Reference namespaces;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mergeTagGroups_closure2(Object _outerInstance, Object _thisObject, Reference xTagGroupsList, Reference namespaces) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.xTagGroupsList = reference2 = xTagGroupsList;
                this.namespaces = reference = namespaces;
            }

            public Object doCall(Object k, Object v) {
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.xTagGroupsList.get(), List.class)), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.namespaces.get(), Map.class)), (Object)k), "tags", (List)ScriptBytecodeAdapter.asType((Object)v, List.class)}));
            }

            public Object call(Object k, Object v) {
                return this.doCall(k, v);
            }

            @Generated
            public Object getxTagGroupsList() {
                return this.xTagGroupsList.get();
            }

            @Generated
            public Map getNamespaces() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.namespaces.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergeTagGroups_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Map)((Map)newTagGroups2.get()), (Closure)new _mergeTagGroups_closure2(this, this, xTagGroupsList, namespaces2));
        List list = (List)xTagGroupsList.get();
        ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)api, (String)"putAt", (Object[])new Object[]{"x-tagGroups", list});
    }

    public void processEndpoint(Map api, String endpoint, String namespace, Map pathMap, Map xTagGroups, List tags) {
        List list;
        Reference endpoint2 = new Reference((Object)endpoint);
        LinkedHashMap tagEntry = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", (String)endpoint2.get()}), LinkedHashMap.class);
        if (DefaultTypeTransformation.booleanUnbox(pathMap.get("description"))) {
            Object v = pathMap.get("description");
            ScriptBytecodeAdapter.setProperty(v, null, (Object)tagEntry, (String)"description");
        }
        tags = list = tags;
        public final class _processEndpoint_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference endpoint;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processEndpoint_closure3(Object _outerInstance, Object _thisObject, Reference endpoint) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.endpoint = reference = endpoint;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual(it.get("name"), (Object)this.endpoint.get());
            }

            @Generated
            public String getEndpoint() {
                return ShortTypeHandling.castToString((Object)this.endpoint.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processEndpoint_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)tags, (Closure)new _processEndpoint_closure3(this, this, endpoint2)))) {
            DefaultGroovyMethods.leftShift((List)tags, (Object)tagEntry);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)xTagGroups, (Object)namespace))) {
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)xTagGroups, (String)"putAt", (Object[])new Object[]{namespace, list2});
        }
        ((List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)xTagGroups, (Object)namespace), List.class)).add((String)endpoint2.get());
        try {
            this.createPaths(api, (String)endpoint2.get(), namespace, pathMap);
        }
        catch (Exception e) {
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)endpoint2.get()}, new String[]{"Error on ", ""}));
            throw (Throwable)new IllegalArgumentException(msg, (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
        }
    }

    public Map createPaths(Map api, String endpoint, String namespace, Map restConfig) {
        Map paths = (Map)ScriptBytecodeAdapter.castToType(api.get("paths"), Map.class);
        String namespacePrefix = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)namespace) ? new GStringImpl(new Object[]{namespace}, new String[]{"", "/"}) : ""));
        String pathKey = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespacePrefix, endpoint}, new String[]{"/", "", ""}));
        String pathKeyId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathKey}, new String[]{"", "/{id}"}));
        String pathKeyPrefix = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespacePrefix}, new String[]{"./paths/", ""}));
        String pathFileBase = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathKeyPrefix, endpoint}, new String[]{"", "", ""}));
        Files.createDirectories(this.getApiBuildPath().resolve(pathKeyPrefix), new FileAttribute[0]);
        String capitalName = NameUtils.getClassNameFromKebabCase((String)endpoint);
        String modelName = NameUtils.getShortName((String)ShortTypeHandling.castToString(restConfig.get("entityClass")));
        String baseDir = DefaultTypeTransformation.booleanUnbox((Object)namespace) ? "../../" : "../";
        LinkedHashMap model = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"endpoint", endpoint, "name", endpoint, "capitalName", capitalName, "modelName", modelName, "namespace", namespace, "baseDir", baseDir}), LinkedHashMap.class);
        String filePathRef = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathFileBase}, new String[]{"", ".yaml"}));
        this.processTplFile(restConfig, "paths/tpl.yaml", filePathRef, model);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"$ref", filePathRef});
        ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)paths, (String)"putAt", (Object[])new Object[]{pathKey, map});
        GStringImpl gStringImpl = new GStringImpl(new Object[]{pathFileBase}, new String[]{"", "@{id}.yaml"});
        filePathRef = ShortTypeHandling.castToString((Object)gStringImpl);
        this.processTplFile(restConfig, "paths/tpl@{id}.yaml", filePathRef, model);
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"$ref", filePathRef});
        ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)paths, (String)"putAt", (Object[])new Object[]{pathKeyId, map2});
        if (DefaultTypeTransformation.booleanUnbox(restConfig.get("bulkOps"))) {
            Map map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"$ref", new GStringImpl(new Object[]{pathFileBase}, new String[]{"", "@bulk.yaml"}).toString()});
            ScriptBytecodeAdapter.invokeMethodN(OpenApiGenerator.class, (Object)paths, (String)"putAt", (Object[])new Object[]{new GStringImpl(new Object[]{pathKey}, new String[]{"", "/bulk"}), map3});
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{pathFileBase}, new String[]{"", "@bulk.yaml"});
            filePathRef = ShortTypeHandling.castToString((Object)gStringImpl2);
            this.processTplFile(restConfig, "paths/tpl@bulk.yaml", filePathRef, model);
            return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
    }

    public void processTplFile(Map restConfig, String srcPath, String outputPath, Map model) {
        String string;
        Path tplFile = this.getApiSrcPath().resolve(srcPath);
        String ymlTpl = FileUtil.readFileToString((File)tplFile.toFile());
        ymlTpl = string = FileUtil.parseStringAsGString((String)ymlTpl, (Map)model);
        Map pathMap = (Map)ScriptBytecodeAdapter.castToType(this.parseAndLoadYaml(srcPath, model), Map.class);
        this.modifyForAllowedOps(restConfig, pathMap);
        Path existingTplFile = this.getApiSrcPath().resolve(outputPath);
        if (Files.exists(existingTplFile, new LinkOption[0])) {
            Map map;
            Map overridePathMap = (Map)ScriptBytecodeAdapter.castToType(this.parseAndLoadYaml(outputPath, model), Map.class);
            pathMap = map = Maps.merge((Map[])new Map[]{pathMap, overridePathMap});
        }
        Path outPath = this.getApiBuildPath().resolve(outputPath);
        YamlUtils.saveYaml(outPath, pathMap);
    }

    public <T> T parseAndLoadYaml(String srcTplYamlPath, Map model) {
        String string;
        Path tplFile = this.getApiSrcPath().resolve(srcTplYamlPath);
        String ymlTpl = FileUtil.readFileToString((File)tplFile.toFile());
        ymlTpl = string = FileUtil.parseStringAsGString((String)ymlTpl, (Map)model);
        return (T)new Yaml().load(ymlTpl);
    }

    public void modifyForAllowedOps(Map restConfig, Map pathMap) {
        List allowedOps = (List)ScriptBytecodeAdapter.asType(restConfig.get("allowedOps"), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)allowedOps)) {
            return;
        }
        if (!allowedOps.contains("create")) {
            pathMap.remove("post");
        }
        if (!allowedOps.contains("update")) {
            pathMap.remove("put");
        }
        if (!allowedOps.contains("delete")) {
            pathMap.remove("delete");
        }
    }

    public void generateModels() {
        MappingContext mapctx = GormMetaUtils.getMappingContext();
        PersistentEntity entity = null;
        Iterator iterator = mapctx.getPersistentEntities().iterator();
        while (iterator.hasNext()) {
            entity = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentEntity.class);
            Map map = this.gormToSchema.generate(entity, ApiSchemaEntity.CruType.Read);
            Map mapCreate = this.gormToSchema.generate(entity, ApiSchemaEntity.CruType.Create);
            Map mapUpdate = this.gormToSchema.generate(entity, ApiSchemaEntity.CruType.Update);
            this.writeYmlModel(entity.getJavaClass(), map, ApiSchemaEntity.CruType.Read);
            this.writeYmlModel(entity.getJavaClass(), mapCreate, ApiSchemaEntity.CruType.Create);
            this.writeYmlModel(entity.getJavaClass(), mapUpdate, ApiSchemaEntity.CruType.Update);
        }
    }

    public Path writeYmlModel(Class clazz, Map schemaMap, ApiSchemaEntity.CruType type) {
        String suffix = ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareEqual((Object)((Object)type), (Object)((Object)ApiSchemaEntity.CruType.Read)) ? "" : new GStringImpl(new Object[]{type}, new String[]{"_", ""})));
        Files.createDirectories(this.getApiBuildPath("models"), new FileAttribute[0]);
        Path path = this.getApiBuildPath(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{clazz.getSimpleName(), suffix}, new String[]{"models/", "", ".yaml"})));
        YamlUtils.saveYaml(path, schemaMap);
        return path;
    }

    @Traits.TraitBridge(traitClass=ConfigAware.class, desc="()Lgrails/config/Config;")
    public Config getConfig() {
        return ConfigAware.Trait.Helper.getConfig((ConfigAware)this);
    }

    public /* synthetic */ Config gorm_tools_support_ConfigAwaretrait$super$getConfig() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Config)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getConfig", (Object)new Object[0]), Config.class);
        }
        return (Config)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getConfig"), Config.class);
    }

    @Traits.TraitBridge(traitClass=ConfigAware.class, desc="(Lgrails/config/Config;)V")
    public void setConfiguration(Config param1) {
        ConfigAware.Trait.Helper.setConfiguration((ConfigAware)this, (Config)param1);
    }

    public /* synthetic */ void gorm_tools_support_ConfigAwaretrait$super$setConfiguration(Config param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setConfiguration", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setConfiguration", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=ConfigAware.class, desc="(Lgrails/config/Config;)V")
    public void setConfig(Config param1) {
        ConfigAware.Trait.Helper.setConfig((ConfigAware)this, (Config)param1);
    }

    public /* synthetic */ void gorm_tools_support_ConfigAwaretrait$super$setConfig(Config param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setConfig", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setConfig", (Object[])new Object[]{param0});
        }
    }

    static {
        ConfigAware.Trait.Helper.$static$init$(OpenApiGenerator.class);
    }

    public Config gorm_tools_support_ConfigAware__config$get() {
        return this.gorm_tools_support_ConfigAware__config;
    }

    public Config gorm_tools_support_ConfigAware__config$set(Config val) {
        Config config;
        this.gorm_tools_support_ConfigAware__config = config = val;
        return config;
    }

    @Generated
    public void generate() {
        this.generate(ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    @Generated
    public Path getApiSrcPath() {
        return this.getApiSrcPath(null);
    }

    @Generated
    public Path getApiBuildPath() {
        return this.getApiBuildPath(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OpenApiGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getApiSrc() {
        return this.apiSrc;
    }

    @Generated
    public void setApiSrc(String string) {
        this.apiSrc = string;
    }

    @Generated
    public String getApiBuild() {
        return this.apiBuild;
    }

    @Generated
    public void setApiBuild(String string) {
        this.apiBuild = string;
    }

    @Generated
    public List getNamespaceList() {
        return this.namespaceList;
    }

    @Generated
    public void setNamespaceList(List list) {
        this.namespaceList = list;
    }

    @Generated
    public GormToSchema getGormToSchema() {
        return this.gormToSchema;
    }

    @Generated
    public void setGormToSchema(GormToSchema gormToSchema) {
        this.gormToSchema = gormToSchema;
    }
}

