/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.audit.scratch;

import gorm.tools.audit.AuditStamp;
import gorm.tools.audit.AuditStampTrait;
import gorm.tools.audit.ast.AuditStampConfigLoader;
import gorm.tools.audit.ast.FieldProps;
import gorm.tools.security.services.SecService;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.core.artefact.DomainClassArtefactHandler;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.EventType;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.AnnotationUtils;
import yakworks.commons.lang.ClassUtils;

public class GormToolsAuditStampListener
extends AbstractPersistenceEventListener
implements GroovyObject {
    private static final String DISABLE_AUDITSTAMP_FIELD = "disableAuditTrailStamp";
    @Autowired
    private GrailsApplication grailsApplication;
    @Autowired
    private SecService secService;
    private final Set<String> auditStampedEntities;
    private Map<String, FieldProps> fieldProps;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected GormToolsAuditStampListener(Datastore datastore) {
        super(datastore);
        MetaClass metaClass;
        Set set;
        this.auditStampedEntities = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PostConstruct
    public void init() {
        if (!DefaultTypeTransformation.booleanUnbox(this.fieldProps)) {
            Map<String, FieldProps> map = FieldProps.buildFieldMap((Map)new AuditStampConfigLoader().load());
            this.fieldProps = map;
        }
        GrailsClass[] domains = this.grailsApplication.getArtefacts(DomainClassArtefactHandler.TYPE);
        GrailsClass domain2 = null;
        GrailsClass[] grailsClassArray = domains;
        if (domains != null) {
            for (GrailsClass domain2 : grailsClassArray) {
                if (!this.isAuditStamped(domain2.getClazz())) continue;
                DefaultGroovyMethods.leftShift(this.auditStampedEntities, (Object)domain2.getClazz().getName());
            }
        }
    }

    public boolean isAuditStamped(Class domainClass) {
        return (AuditStampTrait.class.isAssignableFrom(domainClass) || DefaultTypeTransformation.booleanUnbox((Object)AnnotationUtils.findAnnotation((Class)domainClass, AuditStamp.class))) && !this.isAuditStampDisabled(domainClass);
    }

    public boolean isAuditStampDisabled(Class clazz) {
        return ScriptBytecodeAdapter.compareEqual((Object)ClassUtils.getStaticPropertyValue((Class)clazz, (String)DISABLE_AUDITSTAMP_FIELD, Boolean.class), (Object)true);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        EntityAccess ea = event.getEntityAccess();
        PersistentEntity entity = event.getEntity();
        if (entity == null || !this.auditStampedEntities.contains(entity.getName())) {
            return;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)event.getEventType(), (Object)EventType.PreInsert)) {
            this.beforeInsert(ea);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)event.getEventType(), (Object)EventType.PreUpdate)) {
            this.beforeUpdate(ea);
        }
    }

    private void beforeInsert(EntityAccess ea) {
        this.setDefaults(ea);
    }

    private void beforeUpdate(EntityAccess ea) {
        this.setTimestampField(FieldProps.getEDITED_DATE_KEY(), ea, null);
        this.setUserField(FieldProps.getEDITED_BY_KEY(), ea);
    }

    public void setTimestampField(String prop, EntityAccess ea, Object date) {
        String datePropName = ((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)prop)).getName();
        Object timestamp = date;
        if (!DefaultTypeTransformation.booleanUnbox((Object)timestamp)) {
            Class dateTimeClass = ea.getPropertyType(datePropName);
            Object t = this.createTimestamp(dateTimeClass);
            timestamp = t;
        }
        ea.setProperty(datePropName, timestamp);
    }

    public <T> T createTimestamp(Class<?> dateTimeClass) {
        return (T)DefaultGroovyMethods.invokeMethod(dateTimeClass, (String)"now", null);
    }

    @Deprecated
    public void setDateField(String prop, EntityAccess ea, Date date) {
        ea.setProperty(((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)prop)).getName(), (Object)date);
    }

    public void setUserField(String prop, EntityAccess ea) {
        ea.setProperty(((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)prop)).getName(), (Object)this.getCurrentUserId());
    }

    public void setDefaults(EntityAccess ea) {
        Class dateTimeClass = ea.getPropertyType(((FieldProps)DefaultGroovyMethods.getAt(this.fieldProps, (Object)FieldProps.getCREATED_DATE_KEY())).getName());
        Object timestamp = this.createTimestamp(dateTimeClass);
        this.setTimestampField(FieldProps.getCREATED_DATE_KEY(), ea, timestamp);
        this.setTimestampField(FieldProps.getEDITED_DATE_KEY(), ea, timestamp);
        this.setUserField(FieldProps.getCREATED_BY_KEY(), ea);
        this.setUserField(FieldProps.getEDITED_BY_KEY(), ea);
    }

    public Serializable getCurrentUserId() {
        Serializable uid = this.secService.getUserId();
        Serializable serializable = uid;
        return DefaultTypeTransformation.booleanUnbox((Object)serializable) ? serializable : Long.valueOf(0L);
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreInsertEvent.class.isAssignableFrom(eventType) || PreUpdateEvent.class.isAssignableFrom(eventType) || ValidationEvent.class.isAssignableFrom(eventType);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GormToolsAuditStampListener.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Deprecated
    @Generated
    public void setDateField(String prop, EntityAccess ea) {
        this.setDateField(prop, ea, new Date());
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    @Generated
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    @Generated
    public SecService getSecService() {
        return this.secService;
    }

    @Generated
    public void setSecService(SecService secService) {
        this.secService = secService;
    }

    @Generated
    public final Set<String> getAuditStampedEntities() {
        return this.auditStampedEntities;
    }

    @Generated
    public Map<String, FieldProps> getFieldProps() {
        return this.fieldProps;
    }

    @Generated
    public void setFieldProps(Map<String, FieldProps> map) {
        this.fieldProps = map;
    }
}

