/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.security;

import gorm.tools.security.domain.AppUser;
import gorm.tools.security.domain.SecPasswordHistory;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import yakworks.api.Result;
import yakworks.i18n.MsgKey;
import yakworks.problem.ApiProblem;

public class PasswordValidator
implements GroovyObject {
    @Inject
    private PasswordEncoder passwordEncoder;
    @Value(value="${gorm.tools.security.password.minLength:4}")
    private Integer passwordMinLength;
    @Value(value="${gorm.tools.security.password.mustContainNumbers:false}")
    private boolean passwordMustContainNumbers;
    @Value(value="${gorm.tools.security.password.mustContainSymbols:false}")
    private boolean passwordMustContainSymbols;
    @Value(value="${gorm.tools.security.password.mustContainUpperaseLetter:false}")
    private boolean passwordMustContainUpperaseLetter;
    @Value(value="${gorm.tools.security.password.password.mustContainLowercaseLetter:false}")
    private boolean passwordMustContainLowercaseLetter;
    @Value(value="${gorm.tools.security.password.historyEnabled:false}")
    private boolean passwordHistoryEnabled;
    @Value(value="${gorm.tools.security.password.historyLength:4}")
    private int passwordHistoryLength;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PasswordValidator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Result validate(AppUser user, String pass, String passConfirm) {
        List problemKeys = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (!DefaultTypeTransformation.booleanUnbox((Object)pass) || ScriptBytecodeAdapter.compareLessThan((Object)pass.length(), (Object)this.passwordMinLength)) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.minlength", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", this.passwordMinLength})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)passConfirm, (Object)pass)) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.match"));
        }
        if (this.passwordMustContainLowercaseLetter && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*[a-z].*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.mustcontain.lowercase"));
        }
        if (this.passwordMustContainUpperaseLetter && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*[A-Z].*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.mustcontain.uppercase"));
        }
        if (this.passwordMustContainNumbers && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*[0-9].*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.mustcontain.numbers"));
        }
        if (this.passwordMustContainSymbols && !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)pass, (Object)"^.*\\W.*$"))) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.mustcontain.symbol"));
        }
        if (this.passwordHistoryEnabled && this.passwordExistInHistory(user, pass)) {
            DefaultGroovyMethods.leftShift((List)problemKeys, (Object)MsgKey.of((String)"security.validation.password.minlength", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", this.passwordHistoryLength})));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)problemKeys)) {
            return ApiProblem.of((MsgKey)MsgKey.of((String)"security.validation.password.error")).addErrors(problemKeys);
        }
        return Result.OK();
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    public boolean passwordExistInHistory(AppUser user, String password) {
        void var2_2;
        Reference user2 = new Reference((Object)user);
        Reference password2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        boolean bl = true;
        $transactionAttribute.setReadOnly(bl);
        String string = "gorm.tools.security.PasswordValidator.passwordExistInHistory";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _passwordExistInHistory_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference user;
            private /* synthetic */ Reference password;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _passwordExistInHistory_closure1(Object _outerInstance, Object _thisObject, Reference user, Reference password) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.user = reference2 = user;
                this.password = reference = password;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((PasswordValidator)this.getThisObject()), (String)"$tt__passwordExistInHistory", (Object)new Object[]{this.user.get(), this.password.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public AppUser getUser() {
                return (AppUser)ScriptBytecodeAdapter.castToType((Object)this.user.get(), AppUser.class);
            }

            @Generated
            public String getPassword() {
                return ShortTypeHandling.castToString((Object)this.password.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _passwordExistInHistory_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new _passwordExistInHistory_closure1(this, this, user2, password2)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PasswordValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(PasswordValidator.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(PasswordValidator.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected boolean $tt__passwordExistInHistory(AppUser user, String password, TransactionStatus transactionStatus) {
        Reference password2 = new Reference((Object)password);
        List<SecPasswordHistory> passwordHistoryList = SecPasswordHistory.findAllByUser(user);
        public final class __tt__passwordExistInHistory_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference password;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__passwordExistInHistory_closure2(Object _outerInstance, Object _thisObject, Reference password) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.password = reference = password;
            }

            public Object doCall(Object it) {
                return ((PasswordValidator)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PasswordValidator.class)).getPasswordEncoder().matches((CharSequence)((SecPasswordHistory)it).getPassword(), ShortTypeHandling.castToString((Object)this.password.get()));
            }

            @Generated
            public String getPassword() {
                return ShortTypeHandling.castToString((Object)this.password.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__passwordExistInHistory_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.any(passwordHistoryList, (Closure)new __tt__passwordExistInHistory_closure2(this, this, password2));
    }

    public static /* synthetic */ PasswordEncoder pfaccess$0(PasswordValidator $that) {
        return $that.getPasswordEncoder();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Generated
    public Integer getPasswordMinLength() {
        return this.passwordMinLength;
    }

    @Generated
    public void setPasswordMinLength(Integer n) {
        this.passwordMinLength = n;
    }

    @Generated
    public boolean getPasswordMustContainNumbers() {
        return this.passwordMustContainNumbers;
    }

    @Generated
    public boolean isPasswordMustContainNumbers() {
        return this.passwordMustContainNumbers;
    }

    @Generated
    public void setPasswordMustContainNumbers(boolean bl) {
        this.passwordMustContainNumbers = bl;
    }

    @Generated
    public boolean getPasswordMustContainSymbols() {
        return this.passwordMustContainSymbols;
    }

    @Generated
    public boolean isPasswordMustContainSymbols() {
        return this.passwordMustContainSymbols;
    }

    @Generated
    public void setPasswordMustContainSymbols(boolean bl) {
        this.passwordMustContainSymbols = bl;
    }

    @Generated
    public boolean getPasswordMustContainUpperaseLetter() {
        return this.passwordMustContainUpperaseLetter;
    }

    @Generated
    public boolean isPasswordMustContainUpperaseLetter() {
        return this.passwordMustContainUpperaseLetter;
    }

    @Generated
    public void setPasswordMustContainUpperaseLetter(boolean bl) {
        this.passwordMustContainUpperaseLetter = bl;
    }

    @Generated
    public boolean getPasswordMustContainLowercaseLetter() {
        return this.passwordMustContainLowercaseLetter;
    }

    @Generated
    public boolean isPasswordMustContainLowercaseLetter() {
        return this.passwordMustContainLowercaseLetter;
    }

    @Generated
    public void setPasswordMustContainLowercaseLetter(boolean bl) {
        this.passwordMustContainLowercaseLetter = bl;
    }

    @Generated
    public boolean getPasswordHistoryEnabled() {
        return this.passwordHistoryEnabled;
    }

    @Generated
    public boolean isPasswordHistoryEnabled() {
        return this.passwordHistoryEnabled;
    }

    @Generated
    public void setPasswordHistoryEnabled(boolean bl) {
        this.passwordHistoryEnabled = bl;
    }

    @Generated
    public int getPasswordHistoryLength() {
        return this.passwordHistoryLength;
    }

    @Generated
    public void setPasswordHistoryLength(int n) {
        this.passwordHistoryLength = n;
    }
}

