/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.api.problem;

import gorm.tools.api.problem.DefaultProblem;
import gorm.tools.api.problem.Problem;
import gorm.tools.api.problem.ProblemFieldError;
import gorm.tools.api.problem.ValidationProblem;
import gorm.tools.repository.RepoMessage;
import gorm.tools.repository.errors.EmptyErrors;
import gorm.tools.repository.errors.EntityNotFoundException;
import gorm.tools.repository.errors.EntityValidationException;
import gorm.tools.support.MsgService;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ProblemHandler
implements GroovyObject {
    @Autowired
    private MsgService msgService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ProblemHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Problem handleException(Throwable e) {
        return this.handleException("Entity", e);
    }

    public Problem handleException(Class entityClass, Throwable e) {
        return this.handleException(entityClass.getSimpleName(), e);
    }

    public Problem handleException(String entityName, Throwable e) {
        Object v1;
        HttpStatus status = HttpStatus.UNPROCESSABLE_ENTITY;
        if (e instanceof EntityNotFoundException) {
            return DefaultProblem.of(HttpStatus.NOT_FOUND, this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class)));
        }
        if (e instanceof EntityValidationException) {
            String detail = null;
            if (((ValidationException)ScriptBytecodeAdapter.castToType((Object)e, ValidationException.class)).getErrors() instanceof EmptyErrors) {
                String string;
                Throwable throwable = e.getCause();
                detail = string = throwable != null ? throwable.getMessage() : null;
            }
            return ValidationProblem.of(status, this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class)), detail).errors(this.toFieldErrorList(((ValidationException)ScriptBytecodeAdapter.castToType((Object)e, ValidationException.class)).getErrors()));
        }
        if (e instanceof grails.validation.ValidationException) {
            String msg = this.getMsg(RepoMessage.validationError(entityName));
            return ValidationProblem.of(status, msg).errors(this.toFieldErrorList(((grails.validation.ValidationException)ScriptBytecodeAdapter.castToType((Object)e, grails.validation.ValidationException.class)).getErrors()));
        }
        if (e instanceof MessageSourceResolvable) {
            return DefaultProblem.of(status, this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class)));
        }
        if (e instanceof IllegalArgumentException) {
            return DefaultProblem.of(status, "Illegal Argument", e.getMessage());
        }
        if (e instanceof DataAccessException) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"UNEXPECTED Data Access Exception ", ""})), (Object)e);
                v0 = null;
            } else {
                v0 = null;
            }
            return DefaultProblem.of(status, "Data Access Exception", e.getMessage());
        }
        if (log.isErrorEnabled()) {
            log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"UNEXPECTED Internal Server Error ", ""})), e);
            v1 = null;
        } else {
            v1 = null;
        }
        return DefaultProblem.of(HttpStatus.INTERNAL_SERVER_ERROR).detail(e.getMessage());
    }

    public String getMsg(MessageSourceResolvable msr) {
        return this.msgService.getMessage(msr);
    }

    public List<ProblemFieldError> toFieldErrorList(Errors errs) {
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ObjectError err = null;
        Iterator iterator = errs.getAllErrors().iterator();
        while (iterator.hasNext()) {
            err = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
            ProblemFieldError fieldError = new ProblemFieldError(this.getMsg((MessageSourceResolvable)err));
            if (err instanceof FieldError) {
                String string;
                ((FieldError)ScriptBytecodeAdapter.castToType((Object)err, FieldError.class)).getField();
                fieldError.setField(string);
            }
            DefaultGroovyMethods.leftShift((List)errors, (Object)fieldError);
        }
        return errors;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProblemHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.api.problem.ProblemHandler");
    }

    @Generated
    public MsgService getMsgService() {
        return this.msgService;
    }

    @Generated
    public void setMsgService(MsgService msgService) {
        this.msgService = msgService;
    }
}

