/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.problem;

import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.errors.EmptyErrors;
import gorm.tools.support.MsgSourceResolvable;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.dao.DataAccessException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import yakworks.api.ApiStatus;
import yakworks.api.HttpStatus;
import yakworks.i18n.icu.ICUMessageSource;
import yakworks.problem.Problem;
import yakworks.problem.ProblemException;
import yakworks.problem.ProblemTrait;
import yakworks.problem.UnexpectedProblem;
import yakworks.problem.Violation;
import yakworks.problem.ViolationFieldError;
import yakworks.problem.data.DataProblem;
import yakworks.problem.data.DataProblemCodes;

public class ProblemHandler
implements GroovyObject {
    @Autowired
    private ICUMessageSource messageSource;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ProblemHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ProblemTrait<?> handleException(Class entityClass, Throwable e) {
        return this.handleException(e, entityClass.getSimpleName());
    }

    public ProblemTrait<?> handleException(Throwable e, String simpleName) {
        HttpStatus status400 = HttpStatus.BAD_REQUEST;
        HttpStatus status404 = HttpStatus.NOT_FOUND;
        HttpStatus status422 = HttpStatus.UNPROCESSABLE_ENTITY;
        if (e instanceof ValidationProblem.Exception) {
            ValidationProblem valProblem = ((ValidationProblem.Exception)((Object)ScriptBytecodeAdapter.castToType((Object)e, ValidationProblem.Exception.class))).getValidationProblem();
            if (valProblem.getErrors() instanceof EmptyErrors) {
                Throwable throwable = e.getCause();
                valProblem.detail(throwable != null ? throwable.getMessage() : null);
            }
            valProblem.violations(this.transateErrorsToViolations(valProblem.getErrors()));
            return valProblem;
        }
        if (e instanceof ProblemTrait) {
            return (ProblemTrait)ScriptBytecodeAdapter.castToType((Object)e, ProblemTrait.class);
        }
        if (e instanceof ProblemException) {
            return ((ProblemException)ScriptBytecodeAdapter.castToType((Object)e, ProblemException.class)).getProblem();
        }
        if (e instanceof grails.validation.ValidationException || e instanceof ValidationException) {
            return this.buildFromErrorException(e, simpleName);
        }
        if (e instanceof MsgSourceResolvable) {
            return (ProblemTrait)ScriptBytecodeAdapter.castToType((Object)((Problem)Problem.ofCode((String)((MsgSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MsgSourceResolvable.class)).getCode()).status((ApiStatus)status400)).detail(this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class))), ProblemTrait.class);
        }
        if (e instanceof IllegalArgumentException) {
            return (ProblemTrait)ScriptBytecodeAdapter.castToType((Object)((Problem)Problem.ofCode((String)"error.illegalArgument").status((ApiStatus)status400)).detail(e.getMessage()), ProblemTrait.class);
        }
        if (e instanceof DataAccessException) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"UNEXPECTED Data Access Exception ", ""})), (Object)e);
                v0 = null;
            } else {
                v0 = null;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)ProblemHandler.isUniqueIndexViolation((DataAccessException)ScriptBytecodeAdapter.castToType((Object)e, DataAccessException.class)))) {
                return DataProblemCodes.UniqueConstraint.ofCause(e);
            }
            return DataProblem.ofCause((Throwable)e);
        }
        return this.handleUnexpected(e);
    }

    public ProblemTrait<?> handleUnexpected(Throwable e) {
        Object v0;
        if (log.isErrorEnabled()) {
            log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"UNEXPECTED Internal Server Error ", ""})), e);
            v0 = null;
        } else {
            v0 = null;
        }
        return (ProblemTrait)ScriptBytecodeAdapter.castToType((Object)UnexpectedProblem.ofCause((Throwable)e).detail(e.getMessage()), ProblemTrait.class);
    }

    public ValidationProblem buildFromErrorException(Throwable valEx, String entityName) {
        Errors ers = (Errors)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)valEx, (String)"errors"), Errors.class);
        ValidationProblem valProb = ValidationProblem.ofCause(valEx).errors(ers);
        if (DefaultTypeTransformation.booleanUnbox((Object)entityName)) {
            valProb.name(entityName);
        }
        return (ValidationProblem)ScriptBytecodeAdapter.castToType((Object)valProb.violations(this.transateErrorsToViolations(ers)), ValidationProblem.class);
    }

    public String getMsg(MessageSourceResolvable msr) {
        String msg = this.messageSource.getMessage(msr);
        return msg;
    }

    public List<Violation> transateErrorsToViolations(Errors errs) {
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Errors errors2 = errs;
        if (!DefaultTypeTransformation.booleanUnbox((Object)(errors2 != null ? errors2.getAllErrors() : null))) {
            return errors;
        }
        ObjectError err = null;
        Iterator iterator = errs.getAllErrors().iterator();
        while (iterator.hasNext()) {
            err = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
            ViolationFieldError fieldError = ViolationFieldError.of((String)err.getCode(), (String)this.getMsg((MessageSourceResolvable)err));
            if (err instanceof FieldError) {
                String string;
                ((FieldError)ScriptBytecodeAdapter.castToType((Object)err, FieldError.class)).getField();
                fieldError.setField(string);
            }
            DefaultGroovyMethods.leftShift((List)errors, (Object)fieldError);
        }
        return errors;
    }

    public static String isUniqueIndexViolation(DataAccessException dax) {
        String rootMessage = dax.getRootCause().getMessage();
        if (rootMessage.contains("Unique index or primary key violation") || rootMessage.contains("Duplicate entry") || rootMessage.contains("Violation of UNIQUE KEY constraint") || rootMessage.contains("unique constraint")) {
            return rootMessage;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String formatErrors(Errors errors, String msg) {
        String ls = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        if (msg != null) {
            b.append(msg).append(" : ");
        }
        ObjectError error = null;
        Iterator iterator = errors.getAllErrors().iterator();
        while (iterator.hasNext()) {
            error = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
            b.append(ls).append(" - ").append(error).append(ls);
        }
        return b.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProblemHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public ProblemTrait<?> handleException(Throwable e) {
        return this.handleException(e, null);
    }

    @Generated
    public ValidationProblem buildFromErrorException(Throwable valEx) {
        return this.buildFromErrorException(valEx, null);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.problem.ProblemHandler");
    }

    @Generated
    public ICUMessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public void setMessageSource(ICUMessageSource iCUMessageSource) {
        this.messageSource = iCUMessageSource;
    }
}

