/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.repository.events;

import gorm.tools.beans.AppCtx;
import gorm.tools.databinding.BindAction;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.RepoUtil;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.AfterPersistEvent;
import gorm.tools.repository.events.AfterRemoveEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforePersistEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.BeforeValidateEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.events.RepositoryEvent;
import gorm.tools.repository.events.RepositoryEventType;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Errors;

public class RepoEventPublisher
implements GroovyObject {
    private final Map<String, Map<String, Method>> repoEventMethodCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public RepoEventPublisher() {
        MetaClass metaClass;
        ConcurrentHashMap<String, Map<String, Method>> concurrentHashMap = new ConcurrentHashMap<String, Map<String, Method>>();
        this.repoEventMethodCache = concurrentHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PostConstruct
    public void init() {
        this.scanAndCacheEventsMethods();
    }

    public void scanAndCacheEventsMethods() {
        Class repoClass = null;
        Iterator<Class> iterator = RepoUtil.getRepoClasses().iterator();
        while (iterator.hasNext()) {
            repoClass = ShortTypeHandling.castToClass((Object)iterator.next());
            this.cacheEventsMethods(repoClass);
        }
    }

    public void cacheEventsMethods(Class repoClass) {
        Reference repoClass2 = new Reference((Object)repoClass);
        Reference eventMethodMap = new Reference(new ConcurrentHashMap());
        this.repoEventMethodCache.put(((Class)repoClass2.get()).getSimpleName(), (ConcurrentHashMap)eventMethodMap.get());
        public final class _cacheEventsMethods_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repoClass;
            private /* synthetic */ Reference eventMethodMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cacheEventsMethods_closure1(Object _outerInstance, Object _thisObject, Reference repoClass, Reference eventMethodMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.repoClass = reference2 = repoClass;
                this.eventMethodMap = reference = eventMethodMap;
            }

            public Object doCall(RepositoryEventType et) {
                ((RepoEventPublisher)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), RepoEventPublisher.class)).findAndCacheEventMethods(et.getEventKey(), ShortTypeHandling.castToClass((Object)this.repoClass.get()), (Map)ScriptBytecodeAdapter.castToType((Object)this.eventMethodMap.get(), Map.class));
                return null;
            }

            public Object call(RepositoryEventType et) {
                return this.doCall(et);
            }

            @Generated
            public Class getRepoClass() {
                return ShortTypeHandling.castToClass((Object)this.repoClass.get());
            }

            @Generated
            public Map getEventMethodMap() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.eventMethodMap.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cacheEventsMethods_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)RepositoryEventType.values(), Object[].class)), (Closure)new _cacheEventsMethods_closure1(this, this, repoClass2, eventMethodMap));
    }

    private void findAndCacheEventMethods(String eventKey, Class repoClass, Map<String, Method> events) {
        Method method = ReflectionUtils.findMethod((Class)repoClass, (String)eventKey, null);
        Method method2 = method;
        RepoListener ann = (RepoListener)ScriptBytecodeAdapter.castToType((Object)(method2 != null ? method2.getAnnotation(RepoListener.class) : null), RepoListener.class);
        if (method != null && DefaultTypeTransformation.booleanUnbox((Object)ann)) {
            Method method3 = method;
            ScriptBytecodeAdapter.invokeMethodN(RepoEventPublisher.class, events, (String)"putAt", (Object[])new Object[]{eventKey, method3});
        }
    }

    public <D> void publishEvents(GormRepo<D> repo, RepositoryEvent<D> event, Object ... methodArgs) {
        this.invokeEventMethod(repo, event.getEventKey(), methodArgs);
        if (!DefaultTypeTransformation.booleanUnbox((Object)repo.getEnableEvents())) {
            return;
        }
        AppCtx.publishEvent(event);
    }

    public void invokeEventMethod(GormRepo repo, String eventKey, Object ... methodArgs) {
        Map eventMethodMap = (Map)ScriptBytecodeAdapter.castToType(this.repoEventMethodCache.get(repo.getClass().getSimpleName()), Map.class);
        Map map = eventMethodMap;
        Method method = (Method)ScriptBytecodeAdapter.castToType(map != null ? map.get(eventKey) : null, Method.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)method)) {
            return;
        }
        Object[] truncMethArgs = (Object[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Object[])methodArgs, (IntRange)new IntRange(true, 0, method.getParameterCount() - 1)), Object[].class);
        ReflectionUtils.invokeMethod((Method)method, (Object)repo, (Object[])truncMethArgs);
    }

    public <D> void doBeforeValidate(GormRepo<D> repo, D entity, Map args) {
        BeforeValidateEvent<D> event = new BeforeValidateEvent<D>(repo, entity, PersistArgs.of(args));
        this.publishEvents(repo, event, entity);
    }

    public <D> void doBeforeValidate(GormRepo<D> repo, D entity, Errors errors, Map args) {
        BeforeValidateEvent<D> event = new BeforeValidateEvent<D>(repo, entity, PersistArgs.of(args));
        this.publishEvents(repo, event, entity, errors);
    }

    public <D> void doBeforePersist(GormRepo<D> repo, D entity, PersistArgs args) {
        BeforePersistEvent<D> event = new BeforePersistEvent<D>(repo, entity, args);
        this.publishEvents(repo, event, new Object[]{entity, event});
    }

    public <D> void doAfterPersist(GormRepo<D> repo, D entity, PersistArgs args) {
        AfterPersistEvent<D> event = new AfterPersistEvent<D>(repo, entity, args);
        this.publishEvents(repo, event, new Object[]{entity, event});
    }

    public <D> void doBeforeBind(GormRepo<D> repo, D entity, Map data, BindAction bindAction, PersistArgs args) {
        BeforeBindEvent<D> event = new BeforeBindEvent<D>(repo, entity, data, bindAction, args);
        this.publishEvents(repo, event, new Object[]{entity, data, event});
    }

    public <D> void doAfterBind(GormRepo<D> repo, D entity, Map data, BindAction bindAction, PersistArgs args) {
        AfterBindEvent<D> event = new AfterBindEvent<D>(repo, entity, data, bindAction, args);
        this.publishEvents(repo, event, new Object[]{entity, data, event});
    }

    public <D> void doBeforeRemove(GormRepo<D> repo, D entity, PersistArgs args) {
        BeforeRemoveEvent<D> event = new BeforeRemoveEvent<D>(repo, entity, args);
        this.publishEvents(repo, event, new Object[]{entity, event});
    }

    public <D> void doAfterRemove(GormRepo<D> repo, D entity, PersistArgs args) {
        AfterRemoveEvent<D> event = new AfterRemoveEvent<D>(repo, entity, args);
        this.publishEvents(repo, event, new Object[]{entity, event});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RepoEventPublisher.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

