/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.job;

import gorm.tools.job.SyncJobArgs;
import gorm.tools.job.SyncJobEntity;
import gorm.tools.job.SyncJobFinishedEvent;
import gorm.tools.job.SyncJobService;
import gorm.tools.job.SyncJobState;
import gorm.tools.repository.model.IdGeneratorRepo;
import gorm.tools.utils.BenchmarkHelper;
import groovy.json.StreamingJsonBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import groovy.transform.builder.Builder;
import groovy.transform.builder.SimpleStrategy;
import java.beans.Transient;
import java.io.BufferedWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.groovy.nio.extensions.NioExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yakworks.api.ApiResults;
import yakworks.api.Result;
import yakworks.api.ResultUtils;
import yakworks.api.problem.Problem;
import yakworks.commons.io.IOUtils;
import yakworks.commons.lang.Validate;
import yakworks.i18n.icu.ICUMessageSource;
import yakworks.json.groovy.JsonEngine;
import yakworks.json.groovy.JsonStreaming;
import yakworks.message.spi.MsgService;
import yakworks.spring.AppCtx;

@Builder(builderStrategy=SimpleStrategy.class, prefix="")
@ToString(includeNames=true, includes={"ok", "startTime", "jobId"})
public class SyncJobContext
implements GroovyObject {
    private AtomicBoolean ok;
    private SyncJobService syncJobService;
    private SyncJobArgs args;
    private Long startTime;
    private ApiResults results;
    private List<Problem> problems;
    private Object payload;
    private int payloadSize;
    private AtomicInteger processedCount;
    private AtomicInteger problemCount;
    private Path dataPath;
    private Closure transformResultsClosure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SyncJobContext() {
        this(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public SyncJobContext(Map args) {
        MetaClass metaClass;
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2;
        List list;
        AtomicBoolean atomicBoolean;
        this.ok = atomicBoolean = new AtomicBoolean(true);
        this.problems = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.processedCount = atomicInteger2 = new AtomicInteger();
        this.problemCount = atomicInteger = new AtomicInteger();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (args == null) {
            Map map;
            args = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
        if (args.containsKey("ok")) {
            Object v = args.get("ok");
            this.ok = (AtomicBoolean)ScriptBytecodeAdapter.castToType(v, AtomicBoolean.class);
        }
        if (args.containsKey("syncJobService")) {
            Object v = args.get("syncJobService");
            this.syncJobService = (SyncJobService)ScriptBytecodeAdapter.castToType(v, SyncJobService.class);
        }
        if (args.containsKey("args")) {
            Object v = args.get("args");
            this.args = (SyncJobArgs)ScriptBytecodeAdapter.castToType(v, SyncJobArgs.class);
        }
        if (args.containsKey("startTime")) {
            Object v = args.get("startTime");
            this.startTime = (Long)ScriptBytecodeAdapter.castToType(v, Long.class);
        }
        if (args.containsKey("results")) {
            Object v = args.get("results");
            this.results = (ApiResults)ScriptBytecodeAdapter.castToType(v, ApiResults.class);
        }
        if (args.containsKey("problems")) {
            Object v = args.get("problems");
            this.problems = (List)ScriptBytecodeAdapter.castToType(v, List.class);
        }
        if (args.containsKey("payload")) {
            Object v = args.get("payload");
            this.payload = v;
        }
        if (args.containsKey("payloadSize")) {
            Object v = args.get("payloadSize");
            this.payloadSize = DefaultTypeTransformation.intUnbox(v);
        }
        if (args.containsKey("processedCount")) {
            Object v = args.get("processedCount");
            this.processedCount = (AtomicInteger)ScriptBytecodeAdapter.castToType(v, AtomicInteger.class);
        }
        if (args.containsKey("problemCount")) {
            Object v = args.get("problemCount");
            this.problemCount = (AtomicInteger)ScriptBytecodeAdapter.castToType(v, AtomicInteger.class);
        }
        if (args.containsKey("dataPath")) {
            Object v = args.get("dataPath");
            this.dataPath = (Path)ScriptBytecodeAdapter.castToType(v, Path.class);
        }
        if (args.containsKey("transformResultsClosure")) {
            Object v = args.get("transformResultsClosure");
            this.transformResultsClosure = (Closure)ScriptBytecodeAdapter.castToType(v, Closure.class);
        }
    }

    public static SyncJobContext of(SyncJobArgs args) {
        SyncJobContext sjc = new SyncJobContext(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"args", args}));
        SyncJobContext syncJobContext = sjc;
        args.setContext(syncJobContext);
        return sjc;
    }

    public Long getJobId() {
        return this.args.getJobId();
    }

    public SyncJobContext createJob() {
        ApiResults apiResults;
        Validate.notNull((Object)this.payload);
        Long l = ((IdGeneratorRepo)ScriptBytecodeAdapter.castToType(this.syncJobService.getRepo(), IdGeneratorRepo.class)).generateId();
        this.args.setJobId(l);
        this.setPayloadSize(this.payload);
        Map data = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.args.getJobId(), "source", this.args.getSource(), "sourceId", this.args.getSourceId(), "state", SyncJobState.Running, "payload", this.payload});
        if (this.payload instanceof Collection && ((Collection)this.payload).size() > 1000) {
            boolean bl = true;
            this.args.setSavePayloadAsFile(bl);
            boolean bl2 = true;
            this.args.setSaveDataAsFile(bl2);
        }
        Boolean bl = this.args.getSavePayload();
        if (bl == null ? false : bl) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.payload) && DefaultTypeTransformation.booleanUnbox((Object)this.args.getSavePayloadAsFile())) {
                Long l2 = this.writePayloadFile((Collection)ScriptBytecodeAdapter.asType((Object)this.payload, Collection.class));
                ScriptBytecodeAdapter.setProperty((Object)l2, null, (Object)data, (String)"payloadId");
            } else {
                String res = JsonEngine.toJson((Object)this.payload);
                byte[] byArray = res.getBytes();
                ScriptBytecodeAdapter.setProperty((Object)byArray, null, (Object)data, (String)"payloadBytes");
            }
        }
        SyncJobEntity jobEntity = (SyncJobEntity)ScriptBytecodeAdapter.asType(this.syncJobService.getRepo().create(data, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true, "bindId", true})), SyncJobEntity.class);
        this.results = apiResults = ApiResults.create();
        return this;
    }

    public void updateJobResults(Result apiResults, boolean throwEx) {
        try {
            if (!DefaultTypeTransformation.booleanUnbox((Object)apiResults.getOk())) {
                this.ok.set(false);
                int probCnt = apiResults instanceof ApiResults ? ((ApiResults)ScriptBytecodeAdapter.castToType((Object)apiResults, ApiResults.class)).getProblems().size() : 1;
                this.problemCount.addAndGet(probCnt);
            }
            int processedCnt = apiResults instanceof ApiResults ? ((ApiResults)ScriptBytecodeAdapter.castToType((Object)apiResults, ApiResults.class)).getList().size() : 1;
            this.processedCount.addAndGet(processedCnt);
            String message = this.getJobUpdateMessage(DefaultTypeTransformation.booleanUnbox((Object)apiResults.getOk()));
            this.updateJob(apiResults, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.getJobId(), "ok", this.ok.get(), "message", message}));
        }
        catch (Exception e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error("Unexpected error during updateJobResults", StackTraceUtils.deepSanitize((Throwable)((Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class))));
                v0 = null;
            } else {
                v0 = null;
            }
            if (throwEx) {
                throw (Throwable)e;
            }
        }
    }

    public void updateMessage(int processedCnt, int probCnt) {
        block7: {
            try {
                if (processedCnt != 0) {
                    this.processedCount.addAndGet(probCnt);
                }
                if (probCnt != 0) {
                    this.problemCount.addAndGet(probCnt);
                }
                String message = this.getJobUpdateMessage(probCnt > 0);
                this.updateJob(null, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.getJobId(), "ok", this.ok.get(), "message", message}));
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error("Unexpected error during updateJobResults", StackTraceUtils.deepSanitize((Throwable)((Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class))));
                    v0 = null;
                    break block7;
                }
                v0 = null;
            }
        }
    }

    public void updateWithResult(Result result) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)result.getOk())) {
            this.ok.set(false);
            this.problemCount.addAndGet(1);
        }
        this.updateJob(result, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.getJobId(), "ok", this.ok.get()}));
    }

    public SyncJobEntity finishJob() {
        Map data = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.getJobId()});
        Boolean bl = this.args.getSaveDataAsFile();
        if (bl == null ? false : bl) {
            public final class _finishJob_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _finishJob_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object wr) {
                    ((BufferedWriter)wr).write("\n]\n");
                    return null;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _finishJob_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            NioExtensions.withWriterAppend((Path)this.dataPath, (Closure)new _finishJob_closure1(this, this));
            Long l = this.syncJobService.createAttachment(this.dataPath, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getJobId()}, new String[]{"SyncJobData_", "_.json"})));
            ScriptBytecodeAdapter.invokeMethodN(SyncJobContext.class, (Object)data, (String)"putAt", (Object[])new Object[]{"dataId", l});
        } else {
            List<Map> renderResults = this.transformResults((Result)this.results);
            byte[] byArray = JsonEngine.toJson(renderResults).getBytes();
            ScriptBytecodeAdapter.setProperty((Object)byArray, null, (Object)data, (String)"dataBytes");
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.args.getDataFormat()), (Object)((Object)SyncJobArgs.DataFormat.Payload)) && this.problems.size() > 0) {
            ArrayList<Map> arrayList = new ArrayList<Map>();
            if (this.problems != null) {
                Problem for$it$1 = null;
                Iterator<Problem> iterator = this.problems.iterator();
                while (iterator.hasNext()) {
                    for$it$1 = (Problem)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Problem.class);
                    Problem problem = for$it$1;
                    arrayList.add(problem != null ? problem.asMap() : null);
                }
            }
            ArrayList<Map> arrayList2 = arrayList;
            ScriptBytecodeAdapter.setProperty(arrayList2, null, (Object)data, (String)"problems");
        }
        this.syncJobService.updateJob(data);
        SyncJobEntity entity = this.syncJobService.updateJob(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.getJobId(), "ok", this.ok.get(), "state", SyncJobState.Finished}));
        AppCtx.publishEvent((Object)((Object)SyncJobFinishedEvent.of(this)));
        return entity;
    }

    public List<Map> transformResults(Result resultToTransform) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.transformResultsClosure)) {
            return (List)ScriptBytecodeAdapter.asType((Object)this.transformResultsClosure.call((Object)resultToTransform), List.class);
        }
        List resultList = resultToTransform instanceof ApiResults ? ((ApiResults)ScriptBytecodeAdapter.castToType((Object)resultToTransform, ApiResults.class)).getList() : ScriptBytecodeAdapter.createList((Object[])new Object[]{resultToTransform});
        List<Map> ret = ScriptBytecodeAdapter.compareEqual((Object)((Object)this.args.getDataFormat()), (Object)((Object)SyncJobArgs.DataFormat.Payload)) ? this.transformResultPayloads(resultList) : this.transformResultToMap(resultList);
        return ret;
    }

    public List<Map> transformResultToMap(List<Result> resultList) {
        ICUMessageSource msgService = this.syncJobService.getMessageSource();
        List resMapList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Result r = null;
        Iterator<Result> iterator = resultList.iterator();
        while (iterator.hasNext()) {
            r = (Result)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Result.class);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ok", r.getOk(), "status", r.getStatus().getCode(), "data", r.getPayload()});
            if (r instanceof Problem) {
                map.putAll(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"code", r.getCode(), "title", ResultUtils.getMessage((MsgService)msgService, (Result)r), "detail", r.getDetail()}));
                if (DefaultTypeTransformation.booleanUnbox((Object)((Problem)ScriptBytecodeAdapter.castToType((Object)r, Problem.class)).getViolations())) {
                    List list = ((Problem)ScriptBytecodeAdapter.castToType((Object)r, Problem.class)).getViolations();
                    ScriptBytecodeAdapter.invokeMethodN(SyncJobContext.class, (Object)map, (String)"putAt", (Object[])new Object[]{"errors", list});
                }
            }
            DefaultGroovyMethods.leftShift((List)resMapList, (Object)map);
        }
        return resMapList;
    }

    public List<Map> transformResultPayloads(List<Result> resultList) {
        List resMapList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Result r = null;
        Iterator<Result> iterator = resultList.iterator();
        while (iterator.hasNext()) {
            r = (Result)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Result.class);
            if (r instanceof Problem) {
                this.problems.add((Problem)r);
                continue;
            }
            resMapList.add((Map)ScriptBytecodeAdapter.asType((Object)r.getPayload(), Map.class));
        }
        return resMapList;
    }

    protected String getJobUpdateMessage(boolean resOk) {
        String timing = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)this.startTime) ? new GStringImpl(new Object[]{BenchmarkHelper.elapsedTime(this.startTime)}, new String[]{" | ", ""}) : ""));
        String mem = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BenchmarkHelper.getUsedMem()}, new String[]{" | used mem: ", ""}));
        String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resOk, this.processedCount.get(), this.payloadSize, timing, mem}, new String[]{"slice ok: ", " | processed ", " of ", "", "", ""}));
        int problemSize = this.problemCount.get();
        if (problemSize != 0) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{message, problemSize}, new String[]{"", " | Has ", " problems so far"});
            message = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        if (log.isDebugEnabled()) {
            log.debug(message);
        }
        return message;
    }

    protected void setPayloadSize(Object payload) {
        if (payload instanceof Collection) {
            int n;
            this.payloadSize = n = ((Collection)payload).size();
        }
    }

    protected void updateJob(Result currentResults, Map data) {
        String string = new GStringImpl(new Object[]{this.getJobId()}, new String[]{"SyncJob", ""}).toString().intern();
        synchronized (string) {
            this.syncJobService.updateJob(data);
            if (DefaultTypeTransformation.booleanUnbox((Object)currentResults)) {
                this.appendDataResults(currentResults);
            }
        }
    }

    protected void appendDataResults(Result currentResults) {
        Boolean bl = this.args.getSaveDataAsFile();
        if (bl == null ? false : bl) {
            Reference isFirstWrite = new Reference((Object)false);
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.dataPath)) {
                boolean bl2 = true;
                isFirstWrite.set((Object)bl2);
                this.initJsonDataFile();
            }
            Reference writer = new Reference((Object)NioExtensions.newWriter((Path)this.dataPath, (boolean)true));
            Reference sjb = new Reference((Object)new StreamingJsonBuilder((Writer)((BufferedWriter)writer.get()), JsonEngine.getGenerator()));
            List<Map> dataList = this.transformResults(currentResults);
            public final class _appendDataResults_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference isFirstWrite;
                private /* synthetic */ Reference writer;
                private /* synthetic */ Reference sjb;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _appendDataResults_closure2(Object _outerInstance, Object _thisObject, Reference isFirstWrite, Reference writer, Reference sjb) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.isFirstWrite = reference3 = isFirstWrite;
                    this.writer = reference2 = writer;
                    this.sjb = reference = sjb;
                }

                public Boolean doCall(Object it) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)this.isFirstWrite.get())) {
                        ((BufferedWriter)this.writer.get()).write(",\n");
                    }
                    ((StreamingJsonBuilder)this.sjb.get()).call((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class));
                    boolean bl = false;
                    this.isFirstWrite.set((Object)bl);
                    return bl;
                }

                @Generated
                public Boolean getIsFirstWrite() {
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.isFirstWrite.get(), Boolean.class);
                }

                @Generated
                public Object getWriter() {
                    return this.writer.get();
                }

                @Generated
                public Object getSjb() {
                    return this.sjb.get();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Boolean doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _appendDataResults_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(dataList, (Closure)new _appendDataResults_closure2(this, this, isFirstWrite, writer, sjb));
            IOUtils.flushAndClose((Writer)((BufferedWriter)writer.get()));
        } else {
            this.results.merge(currentResults);
        }
    }

    protected void initJsonDataFile() {
        Path path;
        String filename = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getJobId()}, new String[]{"SyncJobData_", "_.json"}));
        this.dataPath = path = this.syncJobService.createTempFile(filename);
        public final class _initJsonDataFile_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _initJsonDataFile_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object wr) {
                ((BufferedWriter)wr).write("[\n");
                return null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initJsonDataFile_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        NioExtensions.withWriter((Path)this.dataPath, (Closure)new _initJsonDataFile_closure3(this, this));
    }

    protected Long writePayloadFile(Collection payload) {
        String filename = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getJobId()}, new String[]{"SyncJobPayload_", "_.json"}));
        Path path = this.syncJobService.createTempFile(filename);
        JsonStreaming.streamToFile((Collection)payload, (Path)path);
        return this.syncJobService.createAttachment(path, filename);
    }

    public static BigDecimal getUsedMem() {
        int gb = 1024 * 1024 * 1024;
        Runtime runtime = Runtime.getRuntime();
        return (BigDecimal)ScriptBytecodeAdapter.castToType((Object)NumberNumberDiv.div((Number)(runtime.totalMemory() - runtime.freeMemory()), (Number)gb), BigDecimal.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SyncJobContext.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public SyncJobContext ok(AtomicBoolean ok) {
        AtomicBoolean atomicBoolean;
        this.ok = atomicBoolean = ok;
        return this;
    }

    @Generated
    public SyncJobContext syncJobService(SyncJobService syncJobService) {
        SyncJobService syncJobService2;
        this.syncJobService = syncJobService2 = syncJobService;
        return this;
    }

    @Generated
    public SyncJobContext args(SyncJobArgs args) {
        SyncJobArgs syncJobArgs;
        this.args = syncJobArgs = args;
        return this;
    }

    @Generated
    public SyncJobContext startTime(Long startTime) {
        Long l;
        this.startTime = l = startTime;
        return this;
    }

    @Generated
    public SyncJobContext results(ApiResults results) {
        ApiResults apiResults;
        this.results = apiResults = results;
        return this;
    }

    @Generated
    public SyncJobContext problems(List<Problem> problems) {
        List<Problem> list = problems;
        this.problems = list;
        return this;
    }

    @Generated
    public SyncJobContext payload(Object payload) {
        Object object;
        this.payload = object = payload;
        return this;
    }

    @Generated
    public SyncJobContext payloadSize(int payloadSize) {
        int n;
        this.payloadSize = n = payloadSize;
        return this;
    }

    @Generated
    public SyncJobContext processedCount(AtomicInteger processedCount) {
        AtomicInteger atomicInteger;
        this.processedCount = atomicInteger = processedCount;
        return this;
    }

    @Generated
    public SyncJobContext problemCount(AtomicInteger problemCount) {
        AtomicInteger atomicInteger;
        this.problemCount = atomicInteger = problemCount;
        return this;
    }

    @Generated
    public SyncJobContext dataPath(Path dataPath) {
        Path path;
        this.dataPath = path = dataPath;
        return this;
    }

    @Generated
    public SyncJobContext transformResultsClosure(Closure transformResultsClosure) {
        Closure closure;
        this.transformResultsClosure = closure = transformResultsClosure;
        return this;
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("gorm.tools.job.SyncJobContext(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("ok:");
        _result.append(InvokerHelper.toString((Object)this.getOk()));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("startTime:");
        _result.append(InvokerHelper.toString((Object)this.getStartTime()));
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("jobId:");
        _result.append(InvokerHelper.toString((Object)this.getJobId()));
        _result.append(")");
        return _result.toString();
    }

    @Generated
    public void updateJobResults(Result apiResults) {
        CallSite[] callSiteArray = SyncJobContext.$getCallSiteArray();
        this.updateJobResults(apiResults, true);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.job.SyncJobContext");
    }

    @Generated
    public AtomicBoolean getOk() {
        return this.ok;
    }

    @Generated
    public void setOk(AtomicBoolean atomicBoolean) {
        this.ok = atomicBoolean;
    }

    @Generated
    public SyncJobService getSyncJobService() {
        return this.syncJobService;
    }

    @Generated
    public void setSyncJobService(SyncJobService syncJobService) {
        this.syncJobService = syncJobService;
    }

    @Generated
    public SyncJobArgs getArgs() {
        return this.args;
    }

    @Generated
    public void setArgs(SyncJobArgs syncJobArgs) {
        this.args = syncJobArgs;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public void setStartTime(Long l) {
        this.startTime = l;
    }

    @Generated
    public ApiResults getResults() {
        return this.results;
    }

    @Generated
    public void setResults(ApiResults apiResults) {
        this.results = apiResults;
    }

    @Generated
    public List<Problem> getProblems() {
        return this.problems;
    }

    @Generated
    public void setProblems(List<Problem> list) {
        this.problems = list;
    }

    @Generated
    public Object getPayload() {
        return this.payload;
    }

    @Generated
    public void setPayload(Object object) {
        this.payload = object;
    }

    @Generated
    public int getPayloadSize() {
        return this.payloadSize;
    }

    @Generated
    public AtomicInteger getProcessedCount() {
        return this.processedCount;
    }

    @Generated
    public void setProcessedCount(AtomicInteger atomicInteger) {
        this.processedCount = atomicInteger;
    }

    @Generated
    public AtomicInteger getProblemCount() {
        return this.problemCount;
    }

    @Generated
    public void setProblemCount(AtomicInteger atomicInteger) {
        this.problemCount = atomicInteger;
    }

    @Generated
    public Path getDataPath() {
        return this.dataPath;
    }

    @Generated
    public void setDataPath(Path path) {
        this.dataPath = path;
    }

    @Generated
    public Closure getTransformResultsClosure() {
        return this.transformResultsClosure;
    }

    @Generated
    public void setTransformResultsClosure(Closure closure) {
        this.transformResultsClosure = closure;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(SyncJobContext.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SyncJobContext.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

