/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.problem;

import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.errors.EmptyErrors;
import groovy.json.JsonException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.validation.ValidationException;
import org.hibernate.QueryTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import yakworks.api.ApiStatus;
import yakworks.api.HttpStatus;
import yakworks.api.problem.GenericProblem;
import yakworks.api.problem.Problem;
import yakworks.api.problem.ProblemResult;
import yakworks.api.problem.ThrowableProblem;
import yakworks.api.problem.UnexpectedProblem;
import yakworks.api.problem.data.DataProblem;
import yakworks.api.problem.data.DataProblemCodes;
import yakworks.i18n.icu.ICUMessageSource;
import yakworks.message.MsgServiceRegistry;

public class ProblemHandler
implements GroovyObject {
    @Autowired
    private ICUMessageSource messageSource;
    public static List NOISY_PACKAGES;
    public static List NOISY_TEST_PACKAGES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ProblemHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Logger logger;
        List list;
        List list2;
        NOISY_PACKAGES = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"jdk.internal.reflect.NativeMethodAccessorImpl", "jdk.internal.reflect.DelegatingMethodAccessorImpl", "jdk.internal.reflect.GeneratedMethodAccessor", "org.springframework.web.filter.OncePerRequestFilter", "org.springframework.web.filter.CharacterEncodingFilter", "org.springframework.web.filter.DelegatingFilterProxy", "org.springframework.security.web", "org.grails.core.DefaultGrailsControllerClass", "org.grails.web.servlet.mvc.GrailsWebRequestFilter", "org.grails.web.filters.HiddenHttpMethodFilter", "org.grails.datastore.mapping.reflect.FieldEntityAccess", "org.apache.catalina.core", "org.apache.tomcat.websocket.server.WsFilter", "org.apache.tomcat.util.net", "org.apache.tomcat.util.threads", "org.apache.coyote"});
        NOISY_TEST_PACKAGES = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"jdk.internal.reflect.NativeConstructorAccessorImpl", "org.spockframework.runtime", "org.spockframework.util.ReflectionUtil", "org.spockframework.junit4.ExceptionAdapterInterceptor", "org.junit.platform.engine.support.hierarchical", "org.junit.platform.launcher.core.EngineExecutionOrchestrator"});
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.problem.ProblemHandler");
        ProblemHandler.stackTraceUtilsDefaultFilters();
    }

    public GenericProblem handleException(Class entityClass, Throwable e) {
        return this.handleException(e, entityClass.getSimpleName());
    }

    public GenericProblem handleException(Throwable e, String simpleName) {
        HttpStatus status400 = HttpStatus.BAD_REQUEST;
        HttpStatus status404 = HttpStatus.NOT_FOUND;
        HttpStatus status422 = HttpStatus.UNPROCESSABLE_ENTITY;
        if (e instanceof ValidationProblem.Exception) {
            Errors errors;
            ValidationProblem valProblem = ((ValidationProblem.Exception)((Object)ScriptBytecodeAdapter.castToType((Object)e, ValidationProblem.Exception.class))).getValidationProblem();
            if (valProblem.getErrors() instanceof EmptyErrors) {
                Throwable throwable = ((ThrowableProblem)ScriptBytecodeAdapter.castToType((Object)e, ThrowableProblem.class)).getCause();
                valProblem.detail(throwable != null ? throwable.getMessage() : null);
            }
            if (!DefaultTypeTransformation.booleanUnbox(valProblem.getViolations()) && DefaultTypeTransformation.booleanUnbox((errors = valProblem.getErrors()) != null ? Boolean.valueOf(errors.hasErrors()) : null)) {
                valProblem.violations(ValidationProblem.transateErrorsToViolations(valProblem.getErrors()));
            }
            return valProblem;
        }
        if (e instanceof ThrowableProblem) {
            return ((ThrowableProblem)ScriptBytecodeAdapter.castToType((Object)e, ThrowableProblem.class)).getProblem();
        }
        if (e instanceof GenericProblem) {
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)e, GenericProblem.class);
        }
        if (e instanceof grails.validation.ValidationException || e instanceof ValidationException) {
            return this.buildFromErrorException(e, simpleName);
        }
        if (e instanceof IllegalArgumentException) {
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)((ProblemResult)Problem.of((String)"error.illegalArgument").status((ApiStatus)status400)).detail(e.getMessage()), GenericProblem.class);
        }
        if (ProblemHandler.isQueryTimeout(e)) {
            return DataProblem.of((String)"error.query.timeout");
        }
        if (e instanceof DataAccessException) {
            return ProblemHandler.buildFromDataAccessException((DataAccessException)ScriptBytecodeAdapter.castToType((Object)e, DataAccessException.class));
        }
        if (e instanceof HttpMessageNotReadableException || e instanceof JsonException) {
            return DataProblem.of((Throwable)e);
        }
        if (e instanceof AssertionError) {
            return DataProblem.of((Throwable)e);
        }
        return this.handleUnexpected(e);
    }

    public GenericProblem handleUnexpected(Throwable e) {
        Object v0;
        if (log.isErrorEnabled()) {
            log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"UNEXPECTED Internal Server Error\n", ""})), ProblemHandler.deepSanitize(e));
            v0 = null;
        } else {
            v0 = null;
        }
        if (e instanceof GenericProblem) {
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)e, GenericProblem.class);
        }
        if (e instanceof ThrowableProblem) {
            return ((ThrowableProblem)ScriptBytecodeAdapter.castToType((Object)e, ThrowableProblem.class)).getProblem();
        }
        if (e instanceof NullPointerException) {
            String stackLine1 = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)e.getStackTrace()) ? new GStringImpl(new Object[]{((StackTraceElement)BytecodeInterface8.objectArrayGet((Object[])e.getStackTrace(), (int)0)).toString()}, new String[]{"at ", ""}) : ""));
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)((UnexpectedProblem)new UnexpectedProblem().cause(e)).detail(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stackLine1}, new String[]{"NullPointerException ", ""}))), GenericProblem.class);
        }
        return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)((UnexpectedProblem)new UnexpectedProblem().cause(e)).detail(e.getMessage()), GenericProblem.class);
    }

    public static DataProblem buildFromDataAccessException(DataAccessException e) {
        Object v0;
        if (DefaultTypeTransformation.booleanUnbox((Object)ProblemHandler.isUniqueIndexViolation(e))) {
            return DataProblemCodes.UniqueConstraint.of((Throwable)e);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)ProblemHandler.isForeignKeyViolation(e))) {
            return DataProblemCodes.ReferenceKey.of((Throwable)e);
        }
        Throwable throwable = e.getRootCause();
        String rootMessage = throwable != null ? throwable.getMessage() : null;
        String msgInfo = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), rootMessage}, new String[]{"===  message: ", " \n === rootMessage: ", " "}));
        if (log.isErrorEnabled()) {
            log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msgInfo}, new String[]{"MAYBE UNEXPECTED? Data Access Exception ", ""})), ProblemHandler.deepSanitize((Throwable)e));
            v0 = null;
        } else {
            v0 = null;
        }
        return DataProblem.of((Throwable)e);
    }

    public ValidationProblem buildFromErrorException(Throwable valEx, String entityName) {
        Errors ers = (Errors)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)valEx, (String)"errors"), Errors.class);
        ValidationProblem valProb = ValidationProblem.of(valEx).errors(ers);
        if (DefaultTypeTransformation.booleanUnbox((Object)entityName)) {
            valProb.name(entityName);
        }
        return (ValidationProblem)ScriptBytecodeAdapter.castToType((Object)valProb.violations(ValidationProblem.transateErrorsToViolations(ers)), ValidationProblem.class);
    }

    public static String getMsg(MessageSourceResolvable msr) {
        ICUMessageSource msgService = (ICUMessageSource)ScriptBytecodeAdapter.asType((Object)MsgServiceRegistry.getService(), ICUMessageSource.class);
        String string = msgService.getMessage(msr);
        try {
            return string;
        }
        catch (Exception e) {
            String string2 = msr.getDefaultMessage();
            return string2;
        }
    }

    public static boolean isQueryTimeout(Throwable ex) {
        return ex instanceof QueryTimeoutException || ex instanceof DataAccessResourceFailureException && ex.getMessage().contains("canceling statement due to statement timeout\"");
    }

    public static String isUniqueIndexViolation(DataAccessException dax) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)dax.getRootCause())) {
            return ShortTypeHandling.castToString(null);
        }
        String rootMessage = dax.getRootCause().getMessage();
        if (rootMessage.contains("Unique index or primary key violation") || rootMessage.contains("Duplicate entry") || rootMessage.contains("Violation of UNIQUE KEY constraint") || rootMessage.contains("unique constraint")) {
            return rootMessage;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String isForeignKeyViolation(DataAccessException dax) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)dax.getRootCause()) || !(dax instanceof DataIntegrityViolationException)) {
            return ShortTypeHandling.castToString(null);
        }
        String rootMessage = dax.getRootCause().getMessage().toLowerCase();
        if (rootMessage.contains("foreign key")) {
            return rootMessage;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static boolean isBrokenPipe(Throwable ex) {
        return DefaultTypeTransformation.booleanUnbox((Object)ex.getMessage()) && ex.getMessage().toLowerCase().contains("broken pipe");
    }

    public static String formatErrors(Errors errors, String msg) {
        List list;
        String ls = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        if (msg != null) {
            b.append(msg).append(" : ");
        }
        Iterator iterator = (list = errors.getAllErrors()) != null ? list.iterator() : null;
        ObjectError error = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                error = (ObjectError)ScriptBytecodeAdapter.castToType(iterator2.next(), ObjectError.class);
                b.append(ls).append(" - ").append(error).append(ls);
            }
        }
        return b.toString();
    }

    public static Throwable deepSanitize(Throwable t) {
        return StackTraceUtils.deepSanitize((Throwable)t);
    }

    public static void stackTraceUtilsDefaultFilters() {
        public final class _stackTraceUtilsDefaultFilters_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _stackTraceUtilsDefaultFilters_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(String className) {
                List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(_stackTraceUtilsDefaultFilters_closure1.class, ProblemHandler.class, (String)"NOISY_PACKAGES"), List.class)), (Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(_stackTraceUtilsDefaultFilters_closure1.class, ProblemHandler.class, (String)"NOISY_TEST_PACKAGES"), Collection.class)));
                Iterator iterator = list != null ? list.iterator() : null;
                String groovyPackage = null;
                Iterator iterator2 = iterator;
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        groovyPackage = ShortTypeHandling.castToString(iterator2.next());
                        if (!className.startsWith(groovyPackage)) continue;
                        return false;
                    }
                }
                return (Boolean)ScriptBytecodeAdapter.castToType(null, Boolean.class);
            }

            @Generated
            public Boolean call(String className) {
                return this.doCall(className);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _stackTraceUtilsDefaultFilters_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        StackTraceUtils.addClassTest((Closure)new _stackTraceUtilsDefaultFilters_closure1(ProblemHandler.class, ProblemHandler.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProblemHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public GenericProblem handleException(Throwable e) {
        CallSite[] callSiteArray = ProblemHandler.$getCallSiteArray();
        return this.handleException(e, null);
    }

    @Generated
    public ValidationProblem buildFromErrorException(Throwable valEx) {
        CallSite[] callSiteArray = ProblemHandler.$getCallSiteArray();
        return this.buildFromErrorException(valEx, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public ICUMessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public void setMessageSource(ICUMessageSource iCUMessageSource) {
        this.messageSource = iCUMessageSource;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(ProblemHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProblemHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

