/*
 * Decompiled with CFR 0.152.
 */
package yakworks.gorm.api.bulk;

import gorm.tools.job.SyncJobContext;
import gorm.tools.job.SyncJobEntity;
import gorm.tools.job.SyncJobService;
import gorm.tools.job.SyncJobState;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.RepoLookup;
import gorm.tools.transaction.TrxService;
import gorm.tools.utils.ServiceLookup;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import yakworks.api.problem.Problem;
import yakworks.api.problem.ThrowableProblem;
import yakworks.api.problem.data.DataProblem;
import yakworks.api.problem.data.DataProblemCodes;
import yakworks.api.problem.data.DataProblemException;
import yakworks.api.problem.data.DataProblemTrait;
import yakworks.commons.lang.Validate;
import yakworks.etl.DataMimeTypes;
import yakworks.gorm.api.IncludesConfig;
import yakworks.gorm.api.IncludesKey;
import yakworks.gorm.api.bulk.BulkImportJobArgs;
import yakworks.gorm.api.bulk.BulkImporter;
import yakworks.gorm.api.bulk.CsvToMapTransformer;
import yakworks.gorm.config.GormConfig;
import yakworks.json.groovy.JsonEngine;

public class BulkImportService<D>
implements GroovyObject {
    @Autowired
    private SyncJobService syncJobService;
    @Autowired
    private IncludesConfig includesConfig;
    @Autowired
    private ProblemHandler problemHandler;
    @Autowired
    private CsvToMapTransformer csvToMapTransformer;
    @Autowired
    private GormConfig gormConfig;
    private BulkImporter<D> bulkImporter;
    private Class<D> entityClass;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public BulkImportService(Class<D> entityClass) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Class<D> clazz = entityClass;
        this.entityClass = clazz;
    }

    public static <D> BulkImportService<D> lookup(Class<D> entityClass) {
        return (BulkImportService)ScriptBytecodeAdapter.castToType((Object)ServiceLookup.lookup(entityClass, BulkImportService.class, "defaultBulkImportService"), BulkImportService.class);
    }

    public BulkImporter<D> getBulkImporter() {
        if (!DefaultTypeTransformation.booleanUnbox(this.bulkImporter)) {
            BulkImporter<D> bulkImporter = BulkImporter.lookup(this.getEntityClass());
            this.bulkImporter = bulkImporter;
        }
        return this.bulkImporter;
    }

    public SyncJobEntity process(BulkImportJobArgs jobParams, List<Map> payloadList) {
        if (this.gormConfig.isLegacyBulk()) {
            return this.bulkImportLegacy(jobParams, payloadList);
        }
        return this.bulkImport(jobParams, payloadList);
    }

    public SyncJobEntity queueJob(BulkImportJobArgs jobParams, List<Map> payloadBody) {
        String string = this.getEntityClass().getName();
        jobParams.setEntityClassName(string);
        if (DefaultTypeTransformation.booleanUnbox((Object)jobParams.getAttachmentId())) {
            Long l = jobParams.getAttachmentId();
            jobParams.setPayloadId(l);
        } else if (DefaultTypeTransformation.booleanUnbox(payloadBody)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)jobParams.getSavePayloadAsFile()) || payloadBody.size() > 1000) {
                Long l = this.syncJobService.generateId();
                jobParams.setJobId(l);
                Long l2 = this.syncJobService.writePayloadFile(jobParams.getJobId(), payloadBody);
                jobParams.setPayloadId(l2);
            } else {
                List<Map> list = payloadBody;
                jobParams.setPayload(list);
            }
        } else {
            throw (Throwable)DataProblemCodes.EmptyPayload.get().toException();
        }
        return this.syncJobService.queueJob(jobParams);
    }

    public SyncJobEntity runJob(Long jobId) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Long l = jobId;
            valueRecorder.record((Object)l, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)l)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert jobId", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        SyncJobContext jobContext = this.runJobInit(jobId);
        if (jobContext.getOk().get()) {
            this.getBulkImporter().bulkImport((List)ScriptBytecodeAdapter.asType((Object)jobContext.getArgs().getPayload(), List.class), jobContext);
        }
        return this.syncJobService.getJob(jobId);
    }

    public SyncJobEntity queueAndRun(BulkImportJobArgs jobParams, List<Map> payloadBody) {
        SyncJobEntity jobEnt = this.queueJob(jobParams, payloadBody);
        return this.runJob(jobEnt.getId());
    }

    protected SyncJobContext runJobInit(Long jobId) {
        Validate.notNull((Object)jobId);
        SyncJobEntity job = this.syncJobService.getJob(jobId);
        BulkImportJobArgs jobParams = BulkImportJobArgs.fromParams(job.getParams());
        List<Map> payloadList = null;
        try {
            payloadList = this.getPayloadData(job, jobParams);
        }
        catch (DataProblemException dex) {
            this.syncJobService.updateJob(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", jobId, "ok", false, "state", SyncJobState.WTF, "message", StringGroovyMethods.take((String)dex.getMessage(), (int)499)}));
            SyncJobContext syncJobContext = new SyncJobContext(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ok", new AtomicBoolean(false), "problems", ScriptBytecodeAdapter.createList((Object[])new Object[]{(Problem)dex.getProblem()})}));
            return syncJobContext;
        }
        BulkImportJobArgs sargs = this.setupJobArgs(job);
        sargs.payload(payloadList);
        SyncJobContext jobContext = this.syncJobService.startJobInit(job, sargs);
        int n = payloadList.size();
        jobContext.setPayloadSize(n);
        return jobContext;
    }

    @Deprecated
    protected SyncJobEntity bulkImportLegacy(BulkImportJobArgs jobParams, List<Map> payloadList) {
        SyncJobEntity job = this.queueJob(jobParams, payloadList);
        Long jobId = job.getId();
        Reference jobContext = new Reference((Object)this.runJobInit(jobId));
        if (!((SyncJobContext)jobContext.get()).getOk().get()) {
            throw (Throwable)((DataProblemTrait)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt(((SyncJobContext)jobContext.get()).getProblems(), (int)0), DataProblemTrait.class)).toException();
        }
        BulkImportService bulkImportService = this;
        public final class _bulkImportLegacy_lambda1
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference jobContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _bulkImportLegacy_lambda1(Object _outerInstance, Object _thisObject, Reference jobContext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.jobContext = reference = jobContext;
            }

            public void doCall() {
                ((BulkImportService)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BulkImportService.class)).getBulkImporter().doBulkParallel((List)ScriptBytecodeAdapter.asType((Object)((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).getArgs().getPayload(), List.class), (SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class));
            }

            @Generated
            public SyncJobContext getJobContext() {
                return (SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _bulkImportLegacy_lambda1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.syncJobService.runJob((SyncJobContext)jobContext.get(), new _bulkImportLegacy_lambda1(bulkImportService, bulkImportService, jobContext)::doCall);
        TrxService.bean().flushAndClear();
        job = this.syncJobService.getJob(jobId);
        return job;
    }

    protected SyncJobEntity bulkImport(BulkImportJobArgs jobParams, List<Map> payloadList) {
        SyncJobEntity job = this.queueJob(jobParams, payloadList);
        Long jobId = job.getId();
        Boolean bl = jobParams.getAsync();
        if (!(bl == null ? false : bl)) {
            LocalDateTime startTime = LocalDateTime.now();
            DefaultGroovyStaticMethods.sleep(null, (long)1000);
            while (true) {
                this.syncJobService.getJob(jobId);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)job.getState()), (Object)((Object)SyncJobState.Running)) && ScriptBytecodeAdapter.compareNotEqual((Object)((Object)job.getState()), (Object)((Object)SyncJobState.Queued))) break;
                long elapsedSeconds = Duration.between(startTime, LocalDateTime.now()).toSeconds();
                if (elapsedSeconds >= this.gormConfig.getBulk().getAsyncTimeout().toSeconds()) {
                    throw (Throwable)((DataProblem)DataProblem.of((String)"error.timeout").detail(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{jobId}, new String[]{"Job is still running but request timeout has occurred. Do not re-run. Check job status on ", " for current state"})))).payload((Object)jobId).toException();
                }
                long sleepTime = elapsedSeconds < (long)10 ? 1000 : 5000;
                DefaultGroovyStaticMethods.sleep(null, (long)sleepTime);
            }
        }
        return job;
    }

    protected List<Map> getPayloadData(SyncJobEntity job, BulkImportJobArgs jobParams) {
        List payloadList = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)jobParams.getAttachmentId())) {
            if (!(jobParams.getPayloadFormat() != null) || ScriptBytecodeAdapter.compareEqual((Object)((Object)jobParams.getPayloadFormat()), (Object)((Object)DataMimeTypes.csv))) {
                payloadList = this.transformCsvToBulkList(job, jobParams);
            } else if (ScriptBytecodeAdapter.compareEqual((Object)((Object)jobParams.getPayloadFormat()), (Object)((Object)DataMimeTypes.json))) {
                throw (Throwable)DataProblem.ex((String)"JSON attachment not yet supported").payload((Object)job.getId());
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)job.getPayloadId()) || DefaultTypeTransformation.booleanUnbox((Object)job.getPayloadBytes())) {
            payloadList = (List)ScriptBytecodeAdapter.castToType((Object)JsonEngine.parseJson((String)job.payloadToString(), List.class), List.class);
        }
        return payloadList;
    }

    protected List<Map> transformCsvToBulkList(SyncJobEntity job, BulkImportJobArgs jobArgs) {
        List<Map> list = this.getCsvToMapTransformer().process(jobArgs);
        try {
            return list;
        }
        catch (Exception ex) {
            if (ex instanceof ThrowableProblem) {
                throw (Throwable)ex;
            }
            throw (Throwable)((DataProblem)DataProblem.of((Throwable)ex).msg("error.data.csv")).payload((Object)job.getId()).toException();
        }
    }

    protected List<Map> parseJsonPayload(SyncJobEntity job) {
        List list = (List)ScriptBytecodeAdapter.castToType((Object)JsonEngine.parseJson((String)job.payloadToString(), List.class), List.class);
        try {
            return list;
        }
        catch (Exception e) {
            throw (Throwable)DataProblem.of((Throwable)e).payload((Object)job.getId()).toException();
        }
    }

    protected BulkImportJobArgs setupJobArgs(SyncJobEntity job) {
        BulkImportJobArgs jobArgs = BulkImportJobArgs.fromParams(job.getParams());
        Long l = job.getId();
        jobArgs.setJobId(l);
        List<String> list = jobArgs.getIncludes();
        List<String> bulkIncludes = DefaultTypeTransformation.booleanUnbox(list) ? list : this.includesConfig.findByKeys(this.getEntityClass(), ScriptBytecodeAdapter.createList((Object[])new Object[]{IncludesKey.bulk, IncludesKey.get}));
        List<String> bulkErrorIncludes = this.includesConfig.getByKey(this.getEntityClass(), "bulkError");
        List<String> list2 = bulkIncludes;
        jobArgs.setIncludes(list2);
        List<String> list3 = bulkErrorIncludes;
        jobArgs.setErrorIncludes(list3);
        Class<D> clazz = this.getEntityClass();
        jobArgs.setEntityClass(clazz);
        return jobArgs;
    }

    public GormRepo<D> getRepo() {
        return RepoLookup.findRepo(this.getEntityClass());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BulkImportService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.gorm.api.bulk.BulkImportService");
    }

    @Generated
    public SyncJobService getSyncJobService() {
        return this.syncJobService;
    }

    @Generated
    public void setSyncJobService(SyncJobService syncJobService) {
        this.syncJobService = syncJobService;
    }

    @Generated
    public IncludesConfig getIncludesConfig() {
        return this.includesConfig;
    }

    @Generated
    public void setIncludesConfig(IncludesConfig includesConfig) {
        this.includesConfig = includesConfig;
    }

    @Generated
    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Generated
    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    @Generated
    public CsvToMapTransformer getCsvToMapTransformer() {
        return this.csvToMapTransformer;
    }

    @Generated
    public void setCsvToMapTransformer(CsvToMapTransformer csvToMapTransformer) {
        this.csvToMapTransformer = csvToMapTransformer;
    }

    @Generated
    public GormConfig getGormConfig() {
        return this.gormConfig;
    }

    @Generated
    public void setGormConfig(GormConfig gormConfig) {
        this.gormConfig = gormConfig;
    }

    @Generated
    public void setBulkImporter(BulkImporter<D> bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    @Generated
    public Class<D> getEntityClass() {
        return this.entityClass;
    }

    @Generated
    public void setEntityClass(Class<D> clazz) {
        this.entityClass = clazz;
    }
}

