/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.job;

import gorm.tools.async.AsyncArgs;
import gorm.tools.async.AsyncService;
import gorm.tools.job.SyncJobArgs;
import gorm.tools.job.SyncJobContext;
import gorm.tools.job.SyncJobEntity;
import gorm.tools.job.SyncJobState;
import gorm.tools.job.events.SyncJobQueueEvent;
import gorm.tools.job.events.SyncJobStateEvent;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.model.IdGeneratorRepo;
import gorm.tools.transaction.TrxService;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import yakworks.api.ApiResults;
import yakworks.api.Result;
import yakworks.gorm.api.bulk.BulkImportFinishedEvent;
import yakworks.gorm.api.bulk.BulkImportJobArgs;
import yakworks.i18n.icu.ICUMessageSource;
import yakworks.json.groovy.JsonStreaming;
import yakworks.spring.AppCtx;

public abstract class SyncJobService<D>
implements GroovyObject {
    private static final Logger LOG;
    @Autowired
    private ICUMessageSource messageSource;
    @Autowired
    private TrxService trxService;
    @Autowired
    private ProblemHandler problemHandler;
    @Autowired
    private AsyncService asyncService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public SyncJobService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public abstract GormRepo<D> getRepo();

    public SyncJobContext startJobInit(SyncJobEntity job, SyncJobArgs syncJobArgs) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SyncJobEntity syncJobEntity = job;
            valueRecorder.record((Object)syncJobEntity, 8);
            SyncJobState syncJobState = syncJobEntity.getState();
            valueRecorder.record((Object)syncJobState, -1);
            valueRecorder.record((Object)syncJobState, 12);
            SyncJobState syncJobState2 = SyncJobState.Queued;
            valueRecorder.record((Object)syncJobState2, 34);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)((Object)syncJobState), (Object)((Object)syncJobState2));
            valueRecorder.record((Object)bl, -1);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert job.state == SyncJobState.Queued", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        job = this.changeJobStatus(job.getId(), SyncJobState.Running);
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            SyncJobEntity syncJobEntity = job;
            valueRecorder2.record((Object)syncJobEntity, 8);
            SyncJobState syncJobState = syncJobEntity.getState();
            valueRecorder2.record((Object)syncJobState, -1);
            valueRecorder2.record((Object)syncJobState, 12);
            SyncJobState syncJobState3 = SyncJobState.Running;
            valueRecorder2.record((Object)syncJobState3, 34);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)((Object)syncJobState), (Object)((Object)syncJobState3));
            valueRecorder2.record((Object)bl, -1);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert job.state == SyncJobState.Running", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        Long l = job.getId();
        syncJobArgs.setJobId(l);
        SyncJobContext jobContext = SyncJobContext.of(syncJobArgs).syncJobService(this);
        ApiResults apiResults = ApiResults.create();
        jobContext.setResults(apiResults);
        long l2 = System.currentTimeMillis();
        jobContext.setStartTime(l2);
        AppCtx.publishEvent((Object)((Object)SyncJobStateEvent.of(job.getId(), jobContext, job.getState())));
        return jobContext;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public SyncJobEntity queueJob(SyncJobArgs syncJobArgs) {
        Reference syncJobArgs2 = new Reference((Object)syncJobArgs);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        int n = Propagation.REQUIRES_NEW.value();
        $transactionAttribute.setPropagationBehavior(n);
        String string = "gorm.tools.job.SyncJobService.queueJob";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _queueJob_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference syncJobArgs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _queueJob_closure1(Object _outerInstance, Object _thisObject, Reference syncJobArgs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.syncJobArgs = reference = syncJobArgs;
            }

            public SyncJobEntity doCall(TransactionStatus transactionStatus) {
                return (SyncJobEntity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((SyncJobService)this.getThisObject()), (String)"$tt__queueJob", (Object)new Object[]{(SyncJobArgs)ScriptBytecodeAdapter.castToType((Object)this.syncJobArgs.get(), SyncJobArgs.class), transactionStatus}), SyncJobEntity.class);
            }

            @Generated
            public SyncJobEntity call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public SyncJobArgs getSyncJobArgs() {
                return (SyncJobArgs)ScriptBytecodeAdapter.castToType((Object)this.syncJobArgs.get(), SyncJobArgs.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queueJob_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (SyncJobEntity)$transactionTemplate.execute((Closure)new _queueJob_closure1(this, this, syncJobArgs2));
    }

    public Long generateId() {
        return ((IdGeneratorRepo)ScriptBytecodeAdapter.castToType(this.getRepo(), IdGeneratorRepo.class)).generateId();
    }

    @Deprecated
    public SyncJobContext createJob(SyncJobArgs args, Object payload) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)args.getPayload())) {
            Object object = payload;
            args.setPayload(object);
        }
        SyncJobEntity syncJobEntity = this.queueJob(args);
        SyncJobContext jobContext = this.startJobInit(syncJobEntity, args);
        if (payload instanceof Collection) {
            int n = ((Collection)payload).size();
            jobContext.setPayloadSize(n);
        }
        return jobContext;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public SyncJobEntity updateJob(Map data) {
        Reference data2 = new Reference((Object)data);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        int n = Propagation.REQUIRES_NEW.value();
        $transactionAttribute.setPropagationBehavior(n);
        String string = "gorm.tools.job.SyncJobService.updateJob";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _updateJob_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference data;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateJob_closure2(Object _outerInstance, Object _thisObject, Reference data) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.data = reference = data;
            }

            public SyncJobEntity doCall(TransactionStatus transactionStatus) {
                return (SyncJobEntity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((SyncJobService)this.getThisObject()), (String)"$tt__updateJob", (Object)new Object[]{(Map)ScriptBytecodeAdapter.castToType((Object)this.data.get(), Map.class), transactionStatus}), SyncJobEntity.class);
            }

            @Generated
            public SyncJobEntity call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Map getData() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.data.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateJob_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (SyncJobEntity)$transactionTemplate.execute((Closure)new _updateJob_closure2(this, this, data2));
    }

    public SyncJobEntity changeJobStatus(Serializable jobId, SyncJobState syncJobState) {
        return this.updateJob(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", jobId, "state", syncJobState}));
    }

    public SyncJobEntity getJob(Serializable id) {
        return (SyncJobEntity)ScriptBytecodeAdapter.asType(this.getRepo().getWithTrx(id), SyncJobEntity.class);
    }

    public abstract Path createTempFile(String var1);

    public abstract Long createAttachment(Path var1, String var2);

    public abstract D createSyncJob(SyncJobArgs var1);

    /*
     * WARNING - void declaration
     */
    public Long runJob(SyncJobContext jobContext, Runnable runnable) {
        void var2_2;
        Reference jobContext2 = new Reference((Object)jobContext);
        Reference runnable2 = new Reference((Object)var2_2);
        AsyncArgs asyncArgs = ((SyncJobContext)jobContext2.get()).getArgs().getAsyncArgs();
        public final class _runJob_lambda3
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference runnable;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _runJob_lambda3(Object _outerInstance, Object _thisObject, Reference runnable) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.runnable = reference = runnable;
            }

            public T doCall() {
                ((Runnable)ScriptBytecodeAdapter.castToType((Object)this.runnable.get(), Runnable.class)).run();
                return null;
            }

            @Generated
            public Runnable getRunnable() {
                return (Runnable)ScriptBytecodeAdapter.castToType((Object)this.runnable.get(), Runnable.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _runJob_lambda3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _runJob_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference jobContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _runJob_closure4(Object _outerInstance, Object _thisObject, Reference jobContext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.jobContext = reference = jobContext;
            }

            public Void doCall(T res, Throwable ex) {
                if (DefaultTypeTransformation.booleanUnbox((Object)ex)) {
                    SyncJobService.getLOG().error("Unhandled exception while running job");
                    ((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).updateWithResult((Result)((SyncJobService)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SyncJobService.class)).getProblemHandler().handleUnexpected(ex));
                }
                ((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).finishJob();
                if (ScriptBytecodeAdapter.compareEqual((Object)((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).getArgs().getJobType(), (Object)BulkImportJobArgs.JOB_TYPE)) {
                    BulkImportJobArgs impJobArgs = (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).getArgs(), BulkImportJobArgs.class);
                    BulkImportFinishedEvent evt = new BulkImportFinishedEvent((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class), impJobArgs, impJobArgs.getEntityClass());
                    AppCtx.publishEvent(evt);
                    return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                }
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Void call(T res, Throwable ex) {
                return this.doCall(res, ex);
            }

            @Generated
            public SyncJobContext getJobContext() {
                return (SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _runJob_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.asyncService.supplyAsync(asyncArgs, new _runJob_lambda3(SyncJobService.class, SyncJobService.class, runnable2)::doCall).whenComplete((BiConsumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _runJob_closure4(this, this, jobContext2)), BiConsumer.class));
        return ((SyncJobContext)jobContext2.get()).getJobId();
    }

    public Long writePayloadFile(Serializable jobId, Collection payload) {
        String filename = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{jobId}, new String[]{"SyncJobPayload_", "_.json"}));
        Path path = this.createTempFile(filename);
        JsonStreaming.streamToFile((Collection)payload, (Path)path);
        return this.createAttachment(path, filename);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SyncJobService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(SyncJobService.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(SyncJobService.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected SyncJobEntity $tt__queueJob(SyncJobArgs syncJobArgs, TransactionStatus transactionStatus) {
        SyncJobEntity jobEntity = (SyncJobEntity)ScriptBytecodeAdapter.asType(this.createSyncJob(syncJobArgs), SyncJobEntity.class);
        AppCtx.publishEvent((Object)((Object)new SyncJobQueueEvent(jobEntity)));
        return jobEntity;
    }

    protected SyncJobEntity $tt__updateJob(Map data, TransactionStatus transactionStatus) {
        this.getRepo().clear();
        SyncJobEntity syncJobEntity = (SyncJobEntity)ScriptBytecodeAdapter.asType(this.getRepo().update(data, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true})), SyncJobEntity.class);
        try {
            return syncJobEntity;
        }
        catch (Exception e) {
            LOG.error("Critical error updating SyncJob", (Throwable)e);
            throw (Throwable)e;
        }
    }

    public static /* synthetic */ Logger pfaccess$0(SyncJobService $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(SyncJobService.class, SyncJobService.class, (String)"LOG"), Logger.class);
    }

    public static /* synthetic */ ProblemHandler pfaccess$1(SyncJobService $that) {
        return $that.problemHandler;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        LOG = logger = LoggerFactory.getLogger(SyncJobService.class);
    }

    @Generated
    public static Logger getLOG() {
        return LOG;
    }

    @Generated
    public ICUMessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public void setMessageSource(ICUMessageSource iCUMessageSource) {
        this.messageSource = iCUMessageSource;
    }

    @Generated
    public TrxService getTrxService() {
        return this.trxService;
    }

    @Generated
    public void setTrxService(TrxService trxService) {
        this.trxService = trxService;
    }

    @Generated
    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Generated
    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    @Generated
    public AsyncService getAsyncService() {
        return this.asyncService;
    }

    @Generated
    public void setAsyncService(AsyncService asyncService) {
        this.asyncService = asyncService;
    }
}

