/*
 * Decompiled with CFR 0.152.
 */
package yakworks.gorm.api.bulk;

import gorm.tools.async.AsyncArgs;
import gorm.tools.async.ParallelTools;
import gorm.tools.job.SyncJobContext;
import gorm.tools.metamap.services.MetaMapService;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.RepoLookup;
import gorm.tools.repository.events.AfterBulkSaveEntityEvent;
import gorm.tools.repository.events.BeforeBulkSaveEntityEvent;
import gorm.tools.repository.events.RepoEventPublisher;
import gorm.tools.repository.model.DataOp;
import gorm.tools.repository.model.EntityResult;
import gorm.tools.utils.ServiceLookup;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import yakworks.api.ApiResults;
import yakworks.api.HttpStatus;
import yakworks.api.OkResult;
import yakworks.api.Result;
import yakworks.api.problem.data.DataProblem;
import yakworks.commons.lang.Validate;
import yakworks.commons.map.LazyPathKeyMap;
import yakworks.commons.map.Maps;
import yakworks.gorm.api.bulk.BulkImportFinishedEvent;
import yakworks.gorm.api.bulk.BulkImportJobArgs;
import yakworks.meta.MetaMap;
import yakworks.spring.AppCtx;

public class BulkImporter<D>
implements GroovyObject {
    @Autowired
    @Qualifier(value="parallelTools")
    private ParallelTools parallelTools;
    @Autowired
    private MetaMapService metaMapService;
    @Autowired
    private ProblemHandler problemHandler;
    @Autowired
    private RepoEventPublisher repoEventPublisher;
    private Class<D> entityClass;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public BulkImporter(Class<D> entityClass) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Class<D> clazz = entityClass;
        this.entityClass = clazz;
    }

    public static <D> BulkImporter<D> lookup(Class<D> entityClass) {
        return (BulkImporter)ScriptBytecodeAdapter.castToType((Object)ServiceLookup.lookup(entityClass, BulkImporter.class, "defaultBulkImporter"), BulkImporter.class);
    }

    public GormRepo<D> getRepo() {
        return RepoLookup.findRepo(this.entityClass);
    }

    public Long bulkImport(List<Map> dataList, SyncJobContext jobContext) {
        if (dataList == null || dataList.isEmpty()) {
            throw (Throwable)((DataProblem)DataProblem.of((String)"error.data.emptyPayload").detail("Bulk Data is Empty")).toException();
        }
        Validate.notNull((Object)jobContext.getJobId());
        try {
            try {
                this.doBulkParallel(dataList, jobContext);
            }
            catch (Exception ex) {
                jobContext.updateWithResult((Result)this.problemHandler.handleUnexpected(ex));
            }
        }
        finally {
            jobContext.finishJob();
            BulkImportFinishedEvent<D> evt = new BulkImportFinishedEvent<D>(jobContext, (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)jobContext.getArgs(), BulkImportJobArgs.class), this.entityClass);
            AppCtx.publishEvent(evt);
        }
        return jobContext.getJobId();
    }

    public void doBulkParallel(List<Map> dataList, SyncJobContext jobContext) {
        Reference jobContext2 = new Reference((Object)jobContext);
        Reference sliceErrors = new Reference(Collections.synchronizedList(ScriptBytecodeAdapter.createList((Object[])new Object[0])));
        Reference jobArgs = new Reference((Object)((BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)((SyncJobContext)jobContext2.get()).getArgs(), BulkImportJobArgs.class)));
        AsyncArgs pconfig = AsyncArgs.of(this.getRepo().getDatastore());
        Boolean bl = ((BulkImportJobArgs)jobArgs.get()).getParallel();
        pconfig.setEnabled(bl);
        public final class _doBulkParallel_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference jobArgs;
            private /* synthetic */ Reference jobContext;
            private /* synthetic */ Reference sliceErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doBulkParallel_closure1(Object _outerInstance, Object _thisObject, Reference jobArgs, Reference jobContext, Reference sliceErrors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.jobArgs = reference3 = jobArgs;
                this.jobContext = reference2 = jobContext;
                this.sliceErrors = reference = sliceErrors;
            }

            public Boolean doCall(Object dataSlice) {
                Reference dataSlice2;
                block8: {
                    dataSlice2 = new Reference(dataSlice);
                    Reference results = new Reference(null);
                    ApiResults cfr_ignored_0 = (ApiResults)results.get();
                    public final class _closure4
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference results;
                        private /* synthetic */ Reference dataSlice;
                        private /* synthetic */ Reference jobArgs;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure4(Object _outerInstance, Object _thisObject, Reference results, Reference dataSlice, Reference jobArgs) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.results = reference3 = results;
                            this.dataSlice = reference2 = dataSlice;
                            this.jobArgs = reference = jobArgs;
                        }

                        public ApiResults doCall(Object it) {
                            Object object = InvokerHelper.invokeMethodSafe((Object)((BulkImporter)this.getThisObject()), (String)"doBulkSlice", (Object)new Object[]{(List)ScriptBytecodeAdapter.castToType((Object)((Collection)ScriptBytecodeAdapter.castToType((Object)this.dataSlice.get(), Collection.class)), List.class), (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)});
                            this.results.set((Object)((ApiResults)ScriptBytecodeAdapter.castToType((Object)object, ApiResults.class)));
                            return (ApiResults)ScriptBytecodeAdapter.castToType((Object)object, ApiResults.class);
                        }

                        @Generated
                        public ApiResults getResults() {
                            return (ApiResults)ScriptBytecodeAdapter.castToType((Object)this.results.get(), ApiResults.class);
                        }

                        @Generated
                        public Collection getDataSlice() {
                            return (Collection)ScriptBytecodeAdapter.castToType((Object)this.dataSlice.get(), Collection.class);
                        }

                        @Generated
                        public BulkImportJobArgs getJobArgs() {
                            return (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public ApiResults doCall() {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[]{};
                            return new CallSiteArray(_closure4.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure4.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    ((BulkImporter)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BulkImporter.class)).getRepo().withTrx(new _closure4((Object)this, this.getThisObject(), results, dataSlice2, this.jobArgs));
                    ApiResults apiResults = (ApiResults)results.get();
                    Boolean bl = apiResults != null ? apiResults.getOk() : null;
                    if (!(bl == null ? false : bl)) break block8;
                    ((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).updateJobResults((Result)((ApiResults)results.get()), false);
                    Boolean bl2 = (Boolean)ScriptBytecodeAdapter.castToType(null, Boolean.class);
                    return bl2;
                }
                Boolean bl = (Boolean)ScriptBytecodeAdapter.castToType(null, Boolean.class);
                try {
                    return bl;
                }
                catch (Exception e) {
                    Boolean bl3 = ((List)ScriptBytecodeAdapter.castToType((Object)this.sliceErrors.get(), List.class)).add(dataSlice2.get());
                    return bl3;
                }
            }

            @Generated
            public BulkImportJobArgs getJobArgs() {
                return (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class);
            }

            @Generated
            public SyncJobContext getJobContext() {
                return (SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class);
            }

            @Generated
            public List getSliceErrors() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.sliceErrors.get(), List.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doBulkParallel_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.parallelTools.eachSlice(pconfig, dataList, new _doBulkParallel_closure1(this, this, jobArgs, jobContext2, sliceErrors));
        if (((List)sliceErrors.get()).size() != 0) {
            AsyncArgs asynArgsNoTrx = AsyncArgs.of(this.getRepo().getDatastore());
            Boolean bl2 = ((BulkImportJobArgs)jobArgs.get()).getParallel();
            asynArgsNoTrx.setEnabled(bl2);
            public final class _doBulkParallel_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference jobArgs;
                private /* synthetic */ Reference jobContext;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _doBulkParallel_closure2(Object _outerInstance, Object _thisObject, Reference jobArgs, Reference jobContext) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.jobArgs = reference2 = jobArgs;
                    this.jobContext = reference = jobContext;
                }

                public Object doCall(Object dataSlice) {
                    ApiResults results = (ApiResults)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((BulkImporter)this.getThisObject()), (String)"doBulkSlice", (Object)new Object[]{(List)ScriptBytecodeAdapter.castToType((Object)dataSlice, List.class), (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class), true}), ApiResults.class);
                    ((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).updateJobResults((Result)results, false);
                    Object var3_3 = null;
                    try {
                        return var3_3;
                    }
                    catch (Exception ex) {
                        ((SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class)).updateWithResult((Result)((BulkImporter)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BulkImporter.class)).getProblemHandler().handleUnexpected(ex));
                        Object var5_5 = null;
                        return var5_5;
                    }
                }

                @Generated
                public BulkImportJobArgs getJobArgs() {
                    return (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class);
                }

                @Generated
                public SyncJobContext getJobContext() {
                    return (SyncJobContext)ScriptBytecodeAdapter.castToType((Object)this.jobContext.get(), SyncJobContext.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doBulkParallel_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.parallelTools.each(asynArgsNoTrx, (List)sliceErrors.get(), new _doBulkParallel_closure2(this, this, jobArgs, jobContext2));
        }
    }

    protected ApiResults doBulkSlice(List<Map> dataList, BulkImportJobArgs jobArgs, boolean transactionPerItem) {
        ApiResults results = ApiResults.create((boolean)false);
        List<Map> list = dataList;
        Iterator<Map> iterator = list != null ? list.iterator() : null;
        Map item = null;
        Iterator<Map> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                item = (Map)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Map.class);
                try {
                    EntityResult<Map> entResult = this.bulkSaveEntity(item, jobArgs, transactionPerItem);
                    results.leftShift((Result)((OkResult)Result.OK().payload((Object)entResult.getEntity())).status(entResult.getStatus()));
                }
                catch (Exception e) {
                    if (transactionPerItem) {
                        results.leftShift((Result)this.problemHandler.handleException(e).payload((Object)this.buildErrorMap(item, jobArgs.getErrorIncludes())));
                        continue;
                    }
                    this.getRepo().clear();
                    throw (Throwable)e;
                }
            }
        }
        if (this.getRepo().getDatastore().hasCurrentSession()) {
            void void_;
            if (transactionPerItem) {
                this.getRepo().clear();
                void_ = null;
            } else {
                this.getRepo().flushAndClear();
                void_ = null;
            }
        }
        return results;
    }

    protected EntityResult<Map> bulkSaveEntity(Map data, BulkImportJobArgs jobArgs, boolean transactional) {
        Reference jobArgs2 = new Reference((Object)jobArgs);
        Reference dataClone = new Reference(null);
        Map cfr_ignored_0 = (Map)dataClone.get();
        if (data instanceof LazyPathKeyMap) {
            dataClone.set((Object)((LazyPathKeyMap)ScriptBytecodeAdapter.castToType((Object)data, LazyPathKeyMap.class)).cloneMap());
        } else {
            dataClone.set((Object)Maps.clone((Map)data));
        }
        public final class _bulkSaveEntity_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dataClone;
            private /* synthetic */ Reference jobArgs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _bulkSaveEntity_closure3(Object _outerInstance, Object _thisObject, Reference dataClone, Reference jobArgs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.dataClone = reference2 = dataClone;
                this.jobArgs = reference = jobArgs;
            }

            public EntityResult doCall(Object it) {
                InvokerHelper.invokeMethodSafe((Object)((BulkImporter)this.getThisObject()), (String)"doBeforeBulkSaveEntity", (Object)new Object[]{(Map)ScriptBytecodeAdapter.castToType((Object)this.dataClone.get(), Map.class), (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)});
                PersistArgs pargs = DefaultTypeTransformation.booleanUnbox((Object)((BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)).getPersistArgs()) ? ((BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)).getPersistArgs().clone() : PersistArgs.of();
                Object entityInstance = null;
                DataOp op = ((BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)).getOp();
                int statusCode = 0;
                if (ScriptBytecodeAdapter.compareEqual((Object)((Object)op), (Object)((Object)DataOp.add))) {
                    entityInstance = ((BulkImporter)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BulkImporter.class)).getRepo().doCreate((Map)ScriptBytecodeAdapter.castToType((Object)this.dataClone.get(), Map.class), pargs);
                    statusCode = HttpStatus.CREATED.getCode();
                } else if (ScriptBytecodeAdapter.compareEqual((Object)((Object)op), (Object)((Object)DataOp.update))) {
                    entityInstance = ((BulkImporter)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BulkImporter.class)).getRepo().doUpdate((Map)ScriptBytecodeAdapter.castToType((Object)this.dataClone.get(), Map.class), pargs);
                    statusCode = HttpStatus.OK.getCode();
                } else if (ScriptBytecodeAdapter.compareEqual((Object)((Object)op), (Object)((Object)DataOp.upsert))) {
                    EntityResult res = ((BulkImporter)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BulkImporter.class)).getRepo().upsert((Map)ScriptBytecodeAdapter.castToType((Object)this.dataClone.get(), Map.class), pargs);
                    entityInstance = res.getEntity();
                    statusCode = res.getStatus().getCode();
                } else {
                    throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{op}, new String[]{"DataOp ", " not supported"})));
                }
                InvokerHelper.invokeMethodSafe((Object)((BulkImporter)this.getThisObject()), (String)"doAfterBulkSaveEntity", (Object)new Object[]{entityInstance, (Map)ScriptBytecodeAdapter.castToType((Object)this.dataClone.get(), Map.class), (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)});
                Map successMap = (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((BulkImporter)this.getThisObject()), (String)"buildSuccessMap", (Object)new Object[]{entityInstance, ((BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class)).getIncludes()}), Map.class);
                return (EntityResult)ScriptBytecodeAdapter.castToType((Object)EntityResult.of(successMap).status(statusCode), EntityResult.class);
            }

            @Generated
            public Map getDataClone() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.dataClone.get(), Map.class);
            }

            @Generated
            public BulkImportJobArgs getJobArgs() {
                return (BulkImportJobArgs)ScriptBytecodeAdapter.castToType((Object)this.jobArgs.get(), BulkImportJobArgs.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public EntityResult doCall() {
                CallSite[] callSiteArray = _bulkSaveEntity_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _bulkSaveEntity_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_bulkSaveEntity_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _bulkSaveEntity_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Closure closure = new _bulkSaveEntity_closure3(this, this, dataClone, jobArgs2);
        return transactional ? (EntityResult)ScriptBytecodeAdapter.castToType(this.getRepo().withTrx(closure), EntityResult.class) : (EntityResult)ScriptBytecodeAdapter.castToType((Object)closure.call(), EntityResult.class);
    }

    protected Map buildSuccessMap(D entityInstance, List<String> includes) {
        return this.createMetaMap(entityInstance, includes);
    }

    protected Map buildErrorMap(Map originalData, List<String> errorIncludes) {
        if (DefaultTypeTransformation.booleanUnbox(errorIncludes)) {
            return DefaultGroovyMethods.subMap((Map)originalData, errorIncludes);
        }
        return originalData;
    }

    protected Map createMetaMap(D entityInstance, List<String> includes) {
        MetaMap entityMapData = this.metaMapService.createMetaMap(entityInstance, includes);
        return (Map)ScriptBytecodeAdapter.castToType((Object)entityMapData.clone(), Map.class);
    }

    protected void doBeforeBulkSaveEntity(Map data, BulkImportJobArgs jobArgs) {
        BeforeBulkSaveEntityEvent<D> event = new BeforeBulkSaveEntityEvent<D>(this.getRepo(), data, jobArgs);
        this.repoEventPublisher.publishEvents(this.getRepo(), event, new Object[]{event});
    }

    protected void doAfterBulkSaveEntity(D entity, Map data, BulkImportJobArgs jobArgs) {
        AfterBulkSaveEntityEvent<D> event = new AfterBulkSaveEntityEvent<D>(this.getRepo(), entity, data, jobArgs);
        this.repoEventPublisher.publishEvents(this.getRepo(), event, new Object[]{event});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BulkImporter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ ProblemHandler pfaccess$0(BulkImporter $that) {
        return $that.problemHandler;
    }

    @Generated
    protected ApiResults doBulkSlice(List<Map> dataList, BulkImportJobArgs jobArgs) {
        CallSite[] callSiteArray = BulkImporter.$getCallSiteArray();
        return this.doBulkSlice(dataList, jobArgs, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.gorm.api.bulk.BulkImporter");
    }

    @Generated
    public ParallelTools getParallelTools() {
        return this.parallelTools;
    }

    @Generated
    public void setParallelTools(ParallelTools parallelTools) {
        this.parallelTools = parallelTools;
    }

    @Generated
    public MetaMapService getMetaMapService() {
        return this.metaMapService;
    }

    @Generated
    public void setMetaMapService(MetaMapService metaMapService) {
        this.metaMapService = metaMapService;
    }

    @Generated
    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Generated
    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    @Generated
    public RepoEventPublisher getRepoEventPublisher() {
        return this.repoEventPublisher;
    }

    @Generated
    public void setRepoEventPublisher(RepoEventPublisher repoEventPublisher) {
        this.repoEventPublisher = repoEventPublisher;
    }

    @Generated
    public Class<D> getEntityClass() {
        return this.entityClass;
    }

    @Generated
    public void setEntityClass(Class<D> clazz) {
        this.entityClass = clazz;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(BulkImporter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BulkImporter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

