/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.externalconfig;

import grails.plugin.externalconfig.WriteFilteringMap;
import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.beans.Transient;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.config.PropertySourcesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.AntPathMatcher;

public class ExternalConfigRunListener
implements SpringApplicationRunListener,
GroovyObject {
    private ResourceLoader defaultResourceLoader;
    private YamlPropertySourceLoader yamlPropertySourceLoader;
    private PropertiesPropertySourceLoader propertiesPropertySourceLoader;
    private String userHome;
    private String separator;
    private final SpringApplication application;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ExternalConfigRunListener(SpringApplication application, String ... args) {
        SpringApplication springApplication;
        MetaClass metaClass;
        String string;
        String string2;
        PropertiesPropertySourceLoader propertiesPropertySourceLoader;
        YamlPropertySourceLoader yamlPropertySourceLoader;
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        this.defaultResourceLoader = defaultResourceLoader;
        this.yamlPropertySourceLoader = yamlPropertySourceLoader = new YamlPropertySourceLoader();
        this.propertiesPropertySourceLoader = propertiesPropertySourceLoader = new PropertiesPropertySourceLoader();
        this.userHome = string2 = System.getProperties().getProperty("user.home");
        this.separator = string = System.getProperties().getProperty("file.separator");
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.application = springApplication = application;
    }

    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        Reference environment2 = new Reference((Object)environment);
        List<Object> locations = this.getLocations((ConfigurableEnvironment)environment2.get());
        String encoding = ShortTypeHandling.castToString((Object)((ConfigurableEnvironment)environment2.get()).getProperty("grails.config.encoding", String.class, (Object)"UTF-8"));
        Object location2 = null;
        for (Object location2 : locations) {
            List<PropertySource<?>> propertySources = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            Map currentProperties = ExternalConfigRunListener.getCurrentConfig((ConfigurableEnvironment)environment2.get());
            if (location2 instanceof Class) {
                List<PropertySource<?>> list;
                propertySources = list = ExternalConfigRunListener.loadClassConfig((Class)ScriptBytecodeAdapter.asType((Object)location2, Class.class), currentProperties);
            } else {
                Object v0;
                Resource resource = null;
                if (location2 instanceof Resource) {
                    Object object = location2;
                    resource = (Resource)ScriptBytecodeAdapter.castToType((Object)object, Resource.class);
                } else {
                    Resource resource2;
                    String finalLocation = ((ConfigurableEnvironment)environment2.get()).resolvePlaceholders((String)ScriptBytecodeAdapter.asType((Object)location2, String.class));
                    resource = resource2 = this.defaultResourceLoader.getResource(finalLocation);
                }
                if (resource.exists()) {
                    String fname = resource.getFilename();
                    if (fname.endsWith(".groovy")) {
                        List<PropertySource<?>> list = ExternalConfigRunListener.loadGroovyConfig(resource, encoding, currentProperties);
                        propertySources = list;
                    } else if (fname.endsWith(".yml") || fname.endsWith(".yaml")) {
                        ((ConfigurableEnvironment)environment2.get()).getActiveProfiles();
                        List<PropertySource<?>> list = this.loadYamlConfig(resource);
                        propertySources = list;
                    } else {
                        List<PropertySource<?>> list = this.loadPropertiesConfig(resource);
                        propertySources = list;
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Config file {} not found", new Object[]{resource});
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
            public final class _environmentPrepared_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference environment;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _environmentPrepared_closure1(Object _outerInstance, Object _thisObject, Reference environment) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.environment = reference = environment;
                }

                public Object doCall(Object it) {
                    ((ConfigurableEnvironment)this.environment.get()).getPropertySources().addFirst((PropertySource)ScriptBytecodeAdapter.castToType((Object)it, PropertySource.class));
                    return null;
                }

                @Generated
                public ConfigurableEnvironment getEnvironment() {
                    return (ConfigurableEnvironment)ScriptBytecodeAdapter.castToType((Object)this.environment.get(), ConfigurableEnvironment.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _environmentPrepared_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(propertySources, (Closure)new _environmentPrepared_closure1(this, this, environment2));
        }
    }

    private List<Object> getLocations(ConfigurableEnvironment environment) {
        List locations = (List)environment.getProperty("grails.config.locations", List.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        String environmentString = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Environment.getCurrent().getName()}, new String[]{"environments.", ".grails.config.locations"}));
        Object object = environment.getProperty(environmentString, List.class, (Object)locations);
        locations = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        public final class _getLocations_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLocations_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<Object> doCall(Object location) {
                if (location instanceof CharSequence) {
                    String string = ((ExternalConfigRunListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExternalConfigRunListener.class)).replaceUserHomePrefix((String)ScriptBytecodeAdapter.asType((Object)location, String.class));
                    location = string;
                    List<Object> expandedLocations = ((ExternalConfigRunListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExternalConfigRunListener.class)).handleWildcardLocation((String)ScriptBytecodeAdapter.asType((Object)location, String.class));
                    if (DefaultTypeTransformation.booleanUnbox(expandedLocations)) {
                        return expandedLocations;
                    }
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{location});
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLocations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collectMany((Iterable)locations, (Closure)new _getLocations_closure2(this, this));
    }

    private List<Object> handleWildcardLocation(String location) {
        block7: {
            block8: {
                if (!location.startsWith("file:")) break block8;
                String locationFileName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)location, (CharSequence)this.separator), (int)-1));
                if (!locationFileName.contains("*")) break block7;
                String parentLocation = StringGroovyMethods.minus((CharSequence)location, (Object)locationFileName);
                Resource resource = this.defaultResourceLoader.getResource(parentLocation);
                if (!(resource.getFile().exists() && resource.getFile().isDirectory())) break block7;
                Path dir = resource.getFile().toPath();
                DirectoryStream<Path> stream = Files.newDirectoryStream(dir, locationFileName);
                public final class _handleWildcardLocation_closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handleWildcardLocation_closure3(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public GString doCall(Path p) {
                        return new GStringImpl(new Object[]{p.toAbsolutePath()}, new String[]{"file:", ""});
                    }

                    @Generated
                    public GString call(Path p) {
                        return this.doCall(p);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handleWildcardLocation_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                List list = DefaultGroovyMethods.collect(stream, (Closure)new _handleWildcardLocation_closure3(this, this));
                try {
                    return list;
                }
                catch (FileNotFoundException ignore) {
                    List list2 = (List)ScriptBytecodeAdapter.castToType(null, List.class);
                    return list2;
                }
            }
            if (location.startsWith("classpath") && ((String)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)location, (CharSequence)this.separator), (int)-1)).contains("*")) {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.defaultResourceLoader);
                ((AntPathMatcher)ScriptBytecodeAdapter.asType((Object)resolver.getPathMatcher(), AntPathMatcher.class)).setCaseSensitive(false);
                List resourceList = DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)resolver.getResources(location), Object[].class)));
                return resourceList;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(null, List.class);
    }

    private String replaceUserHomePrefix(String location) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.userHome) && location.startsWith("~/")) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.userHome, StringGroovyMethods.getAt((String)location, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()))}, new String[]{"file:", "", ""});
            location = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return location;
    }

    private static List<PropertySource<?>> loadClassConfig(Class location, Map currentConfig) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading config class {}", (Object)location.getName());
            v0 = null;
        } else {
            v0 = null;
        }
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding((Map)writeFilteringMap);
        ConfigObject configObject = slurper.parse(location);
        Map properties = configObject != null ? configObject.flatten() : null;
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{new MapPropertySource(location.toString(), properties)});
    }

    private static List<PropertySource<?>> loadGroovyConfig(Resource resource, String encoding, Map currentConfig) {
        ConfigObject configObject;
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading groovy config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        String configText = IOGroovyMethods.getText((InputStream)resource.getInputStream(), (String)encoding);
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding((Map)writeFilteringMap);
        ConfigObject configObject2 = slurper.parse(configText);
        Map properties = DefaultTypeTransformation.booleanUnbox((Object)configText) ? ((configObject = configObject2) != null ? configObject.flatten() : null) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{new MapPropertySource(resource.getFilename(), properties)});
    }

    private List<PropertySource<?>> loadYamlConfig(Resource resource) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading YAML config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        return this.yamlPropertySourceLoader.load(resource.getFilename(), resource);
    }

    private List<PropertySource<?>> loadPropertiesConfig(Resource resource) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading properties config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        return this.propertiesPropertySourceLoader.load(resource.getFilename(), resource);
    }

    private void setMicronautConfigLocations(List<Object> newSources) {
        Object v0;
        List<String> list;
        String string = System.getenv("MICRONAUT_CONFIG_FILES");
        List<String> sources = StringGroovyMethods.tokenize((CharSequence)System.getProperty("micronaut.config.files", DefaultTypeTransformation.booleanUnbox((Object)string) ? string : ""), (CharSequence)",");
        public final class _setMicronautConfigLocations_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setMicronautConfigLocations_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return DefaultGroovyMethods.toString((Object)it);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setMicronautConfigLocations_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        sources.addAll(DefaultGroovyMethods.collect(newSources, (Closure)new _setMicronautConfigLocations_closure4(this, this)));
        sources = list = this.filterMissingMicronautLocations(sources);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join(sources, (String)",")}, new String[]{"---> Setting 'micronaut.config.files' to ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        System.setProperty("micronaut.config.files", DefaultGroovyMethods.join(sources, (String)","));
    }

    private List<String> filterMissingMicronautLocations(List<String> sources) {
        public final class _filterMissingMicronautLocations_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _filterMissingMicronautLocations_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(String location) {
                block10: {
                    Object v0;
                    Resource resource = ((ExternalConfigRunListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExternalConfigRunListener.class)).getDefaultResourceLoader().getResource(location);
                    if (!(!resource.exists())) break block10;
                    if (ExternalConfigRunListener.pfaccess$1(null).isDebugEnabled()) {
                        ExternalConfigRunListener.pfaccess$1(null).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{location}, new String[]{"Configuration file ", " not found, ignoring."})));
                        v0 = null;
                    } else {
                        v0 = null;
                    }
                    Boolean bl = false;
                    try {
                        return bl;
                    }
                    catch (FileNotFoundException ignore) {
                        Object v1;
                        if (ExternalConfigRunListener.pfaccess$1(null).isDebugEnabled()) {
                            ExternalConfigRunListener.pfaccess$1(null).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{location}, new String[]{"Configuration file ", " not found, ignoring."})));
                            v1 = null;
                        } else {
                            v1 = null;
                        }
                        Boolean bl2 = false;
                        return bl2;
                    }
                }
                return true;
            }

            @Generated
            public Boolean call(String location) {
                return this.doCall(location);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterMissingMicronautLocations_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll(sources, (Closure)new _filterMissingMicronautLocations_closure5(this, this));
    }

    public static Map getCurrentConfig(ConfigurableEnvironment environment) {
        return new PropertySourcesConfig((PropertySources)environment.getPropertySources());
    }

    public static /* synthetic */ ResourceLoader pfaccess$0(ExternalConfigRunListener $that) {
        return $that.defaultResourceLoader;
    }

    public static /* synthetic */ Logger pfaccess$1(ExternalConfigRunListener $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(ExternalConfigRunListener.class, ExternalConfigRunListener.class, (String)"log"), Logger.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExternalConfigRunListener.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"grails.plugin.externalconfig.ExternalConfig");
    }

    @Generated
    public ResourceLoader getDefaultResourceLoader() {
        return this.defaultResourceLoader;
    }

    @Generated
    public void setDefaultResourceLoader(ResourceLoader resourceLoader) {
        this.defaultResourceLoader = resourceLoader;
    }

    @Generated
    public final SpringApplication getApplication() {
        return this.application;
    }
}

