/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.freemarker;

import freemarker.template.Configuration;
import freemarker.template.TemplateModelException;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsTagLibClass;
import grails.core.support.GrailsApplicationAware;
import grails.plugin.freemarker.TagLibToDirectiveAndFunction;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public abstract class AbstractTagLibAwareConfigurer
extends FreeMarkerConfigurer
implements GrailsApplicationAware {
    public static final String CONFIGURED_ATTRIBUTE_NAME = "_" + AbstractTagLibAwareConfigurer.class.getName() + ".configured";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private GrailsApplication grailsApplication;

    public void setConfiguration(Configuration configuration) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setConfiguration(): configuration " + configuration));
        }
        super.setConfiguration(configuration);
    }

    public Configuration getConfiguration() {
        Configuration configuration = super.getConfiguration();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getConfiguration(): configuration " + configuration));
        }
        this.reconfigure(configuration);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigure() {
        Configuration configuration = super.getConfiguration();
        if (configuration != null) {
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                configuration.removeCustomAttribute(CONFIGURED_ATTRIBUTE_NAME);
                this.reconfigure(configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigure(Configuration configuration) {
        if (configuration != null) {
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                Boolean isConfigured = (Boolean)configuration.getCustomAttribute(CONFIGURED_ATTRIBUTE_NAME);
                if (isConfigured == null || !isConfigured.booleanValue()) {
                    try {
                        ApplicationContext springContext = this.grailsApplication.getMainContext();
                        LinkedHashMap sharedVars = new LinkedHashMap();
                        GrailsClass[] tagLibClasses = this.grailsApplication.getArtefacts("TagLib");
                        for (GrailsClass grailsClass : tagLibClasses) {
                            Set tagNamesWithReturn;
                            GrailsTagLibClass tagLibClass = (GrailsTagLibClass)grailsClass;
                            String namespace = tagLibClass.getNamespace();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("reconfigure(): Exposing tag '" + namespace + "' (" + tagLibClass.getFullName() + ")"));
                            }
                            GroovyObject tagLibInstance = this.getTagLibInstance(springContext, tagLibClass.getFullName());
                            LinkedHashMap<String, TagLibToDirectiveAndFunction> sharedVar = (LinkedHashMap<String, TagLibToDirectiveAndFunction>)sharedVars.get(namespace);
                            if (sharedVar == null) {
                                sharedVar = new LinkedHashMap<String, TagLibToDirectiveAndFunction>();
                                sharedVars.put(namespace, sharedVar);
                            }
                            if ((tagNamesWithReturn = tagLibClass.getTagNamesThatReturnObject()) == null) {
                                tagNamesWithReturn = Collections.emptySet();
                            } else if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("found TagNamesThatReturnObject" + tagNamesWithReturn));
                            }
                            for (String tagName : tagLibClass.getTagNames()) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("reconfigure(): tag " + tagName));
                                }
                                if (tagName.equals("grailsApplication")) continue;
                                Object tagInstanceObject = null;
                                try {
                                    tagInstanceObject = tagLibInstance.getProperty(tagName);
                                }
                                catch (IllegalStateException e) {
                                    this.log.debug((Object)("reconfigure() error on " + tagName), (Throwable)e);
                                }
                                if (tagInstanceObject == null || !(tagInstanceObject instanceof Closure)) continue;
                                Closure tagInstance = (Closure)tagInstanceObject;
                                sharedVar.put(tagName, new TagLibToDirectiveAndFunction(namespace, tagLibInstance, tagName, tagInstance, tagNamesWithReturn.contains(tagName)));
                            }
                        }
                        for (Map.Entry entry : sharedVars.entrySet()) {
                            configuration.setSharedVariable((String)entry.getKey(), entry.getValue());
                        }
                        configuration.setCustomAttribute(CONFIGURED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
                    }
                    catch (TemplateModelException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    protected abstract GroovyObject getTagLibInstance(ApplicationContext var1, String var2);
}

