/*
 * Decompiled with CFR 0.152.
 */
package yakworks.grails.resource;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.core.support.GrailsConfigurationAware;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.groovy.dateutil.extensions.DateUtilExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import yakworks.commons.json.JsonEngine;
import yakworks.commons.lang.Validate;

public class AppResourceLoader
implements ResourceLoader,
GrailsConfigurationAware,
GroovyObject {
    public static final String ATTACHMENT_LOCATION_KEY = "attachments.location";
    private GrailsApplication grailsApplication;
    private ResourceLoader resourceLoader;
    private String resourcesConfigRootKey;
    private Closure rootLocationClosure;
    private Closure currentTenantClosure;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AppResourceLoader() {
        MetaClass metaClass;
        String string;
        this.resourcesConfigRootKey = string = "app.resources";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PostConstruct
    public void init() {
        ApplicationContext applicationContext = this.grailsApplication.getMainContext();
        this.resourceLoader = applicationContext;
    }

    public Resource getResource(String location) {
        Object v0;
        String urlToUse = location;
        if (!location.startsWith("/") && !location.startsWith("file:")) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.getRootLocation().getCanonicalPath(), location}, new String[]{"file:", "/", "/"});
            urlToUse = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{urlToUse}, new String[]{"appResourceLoader.getResource with ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return this.resourceLoader.getResource(urlToUse);
    }

    public Resource getResourceRelative(String locationBase, String location) {
        if (location.startsWith("/")) {
            return this.getResource(location);
        }
        String locationKey = location;
        String string = locationBase;
        Boolean bl = string != null ? Boolean.valueOf(string.startsWith("config:")) : null;
        if (bl == null ? false : bl) {
            String configKey = locationBase.substring("config:".length());
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.getResourceConfig(configKey), location}, new String[]{"", "/", ""});
            locationKey = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)locationBase)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{locationBase, location}, new String[]{"", "/", ""});
            locationKey = ShortTypeHandling.castToString((Object)gStringImpl);
        } else {
            String string2;
            locationKey = string2 = ATTACHMENT_LOCATION_KEY;
        }
        return this.getResource(locationKey);
    }

    public ClassLoader getClassLoader() {
        return this.resourceLoader.getClassLoader();
    }

    public Map createAttachmentFile(Long attachmentId, String name, String extension, Object data, String location) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)location)) {
            String string;
            location = string = ATTACHMENT_LOCATION_KEY;
        }
        String prefix = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)name)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{name}, new String[]{"", "_"});
            prefix = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (data instanceof File) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{((File)data).getName()}, new String[]{"", "_"});
            prefix = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        String destFileName = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)extension) ? new GStringImpl(new Object[]{prefix, attachmentId, extension}, new String[]{"", "", ".", ""}) : new GStringImpl(new Object[]{prefix, attachmentId}, new String[]{"", "", ""})));
        File monthDir = this.getMonthDirectory(location);
        File file = new File(monthDir, destFileName);
        if (DefaultTypeTransformation.booleanUnbox((Object)data)) {
            if (data instanceof File) {
                FileUtils.moveFile((File)((File)ScriptBytecodeAdapter.castToType((Object)data, File.class)), (File)file);
            }
            if (data instanceof byte[]) {
                FileUtils.writeByteArrayToFile((File)file, (byte[])((byte[])ScriptBytecodeAdapter.castToType((Object)data, byte[].class)));
            }
            if (data instanceof String) {
                FileUtils.writeStringToFile((File)file, (String)ShortTypeHandling.castToString((Object)data));
            }
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"location", this.getRelativePath(ATTACHMENT_LOCATION_KEY, file), "file", file});
    }

    public File createTempFile(String originalFileName, Object data) {
        Reference data2 = new Reference(data);
        String baseName = FilenameUtils.getBaseName((String)originalFileName);
        if (baseName.length() < 3) {
            String string;
            baseName = string = StringGroovyMethods.plus((String)baseName, (CharSequence)"tmp");
        }
        String extension = FilenameUtils.getExtension((String)originalFileName);
        String string = DefaultTypeTransformation.booleanUnbox((Object)extension) ? new GStringImpl(new Object[]{extension}, new String[]{".", ""}) : "";
        extension = ShortTypeHandling.castToString((Object)string);
        File tempDir = this.getTempDir();
        File tmpFile = File.createTempFile(baseName, extension, tempDir);
        if (DefaultTypeTransformation.booleanUnbox((Object)data2.get())) {
            if (data2.get() instanceof String) {
                FileUtils.writeStringToFile((File)tmpFile, (String)ShortTypeHandling.castToString((Object)data2.get()));
            } else if (data2.get() instanceof byte[]) {
                FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])((byte[])ScriptBytecodeAdapter.castToType((Object)data2.get(), byte[].class)));
            } else if (data2.get() instanceof ByteArrayOutputStream) {
                public final class _createTempFile_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference data;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _createTempFile_closure1(Object _outerInstance, Object _thisObject, Reference data) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.data = reference = data;
                    }

                    public Object doCall(Object it) {
                        ((ByteArrayOutputStream)ScriptBytecodeAdapter.asType((Object)this.data.get(), ByteArrayOutputStream.class)).writeTo((OutputStream)ScriptBytecodeAdapter.castToType((Object)it, OutputStream.class));
                        return null;
                    }

                    @Generated
                    public Object getData() {
                        return this.data.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createTempFile_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ResourceGroovyMethods.withOutputStream((File)tmpFile, (Closure)new _createTempFile_closure1(this, this, data2));
            }
        }
        return tmpFile;
    }

    public File getTempDir() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = AppResourceLoader.$getCallSiteArray();
        File tempDir = null;
        Object tmpDirPath = null;
        tmpDirPath = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[0].callCurrent((GroovyObject)this, (Object)"tempDir")) : (object = this.getResourceConfig("tempDir"));
        if (DefaultTypeTransformation.booleanUnbox((Object)tmpDirPath)) {
            if (tmpDirPath instanceof Closure) {
                Object object3 = callSiteArray[1].callConstructor(File.class, callSiteArray[2].call(tmpDirPath));
                tempDir = (File)ScriptBytecodeAdapter.castToType((Object)object3, File.class);
            } else {
                Object object4 = callSiteArray[3].callConstructor(File.class, tmpDirPath);
                tempDir = (File)ScriptBytecodeAdapter.castToType((Object)object4, File.class);
            }
        } else {
            Object object5 = callSiteArray[4].callConstructor(File.class, callSiteArray[5].call(System.class, (Object)"java.io.tmpdir"));
            tempDir = (File)ScriptBytecodeAdapter.castToType((Object)object5, File.class);
        }
        return tempDir;
    }

    public void deleteTempUploadedFiles(String attachmentListJson) {
        if (DefaultTypeTransformation.booleanUnbox((Object)attachmentListJson)) {
            List fileDetailsList = (List)ScriptBytecodeAdapter.castToType((Object)JsonEngine.parseJson((String)attachmentListJson, List.class), List.class);
            public final class _deleteTempUploadedFiles_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _deleteTempUploadedFiles_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object fileDetails) {
                    FileUtils.forceDelete((File)new File(((AppResourceLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AppResourceLoader.class)).getTempDir(), (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)fileDetails, (String)"tempFilename"), String.class)));
                    return null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deleteTempUploadedFiles_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)fileDetailsList, (Closure)new _deleteTempUploadedFiles_closure2(this, this));
        }
    }

    public void deleteTempUploadedFiles(List attachmentList) {
        public final class _deleteTempUploadedFiles_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteTempUploadedFiles_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object file) {
                FileUtils.forceDelete((File)new File(((AppResourceLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AppResourceLoader.class)).getTempDir(), (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)file, (String)"tempFilename"), String.class)));
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteTempUploadedFiles_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)attachmentList, (Closure)new _deleteTempUploadedFiles_closure3(this, this));
    }

    public File getFile(String location) {
        File file = new File(this.getLocation(ATTACHMENT_LOCATION_KEY), location);
        return file;
    }

    public String getAttachmentsRelativePath(File file) {
        return this.getRelativePath(ATTACHMENT_LOCATION_KEY, file);
    }

    public Object getCurrentTenant() {
        Validate.notNull((Object)this.currentTenantClosure);
        return this.currentTenantClosure.call();
    }

    public String getTenantUniqueKey() {
        Object client = this.getCurrentTenant();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.getAt((Object)client, (String)"num"), DefaultGroovyMethods.getAt((Object)client, (String)"id")}, new String[]{"", "-", ""}));
    }

    public void forceMkdir(String path) {
        FileUtils.forceMkdir((File)new File(path));
    }

    public File getRootLocation() {
        String rootName = ShortTypeHandling.castToString((Object)this.rootLocationClosure.call(new Object[]{this.mergeClientValues()}));
        File rootLocation = new File(rootName);
        return this.verifyOrCreateLocation(rootLocation, "rootLocation", false);
    }

    public File getLocation(String key, Map args, boolean create) {
        Object value = this.getResourceConfig(key);
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Application resource key '", "' is not defined or returns an empty value."})));
        }
        String fileName = null;
        if (value instanceof Closure) {
            Object object = ((Closure)value).call((Object)this.mergeClientValues(args));
            fileName = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            fileName = string = (String)ScriptBytecodeAdapter.asType((Object)value, String.class);
        }
        return this.getProperFile(fileName, key, create);
    }

    public List getScripts(Map args) {
        Reference key = new Reference((Object)"scripts.locations");
        Closure closure = (Closure)ScriptBytecodeAdapter.asType((Object)this.getResourceConfig((String)key.get()), Closure.class);
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{closure}, new String[]{"getScripts:  closure is ", ""})));
        if (!DefaultTypeTransformation.booleanUnbox((Object)closure)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)key.get()}, new String[]{"Application resource key '", "' is not defined or returns an empty value."})));
        }
        Reference files = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getScripts_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference files;
            private /* synthetic */ Reference key;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getScripts_closure4(Object _outerInstance, Object _thisObject, Reference files, Reference key) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.files = reference2 = files;
                this.key = reference = key;
            }

            public Object doCall(Object name) {
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.files.get(), List.class)), (Object)((AppResourceLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AppResourceLoader.class)).getProperFile((String)ScriptBytecodeAdapter.asType((Object)name, String.class), ShortTypeHandling.castToString((Object)this.key.get()), true));
            }

            @Generated
            public List getFiles() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.files.get(), List.class);
            }

            @Generated
            public String getKey() {
                return ShortTypeHandling.castToString((Object)this.key.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getScripts_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Object)closure.call((Object)this.mergeClientValues(args)), (Closure)new _getScripts_closure4(this, this, files, key));
        return (List)files.get();
    }

    public File getSubDirectory(String key, String relativePath, boolean create, Map args) {
        File base = this.getLocation(key, args, create);
        File subDirectory = new File(base, relativePath);
        return this.verifyOrCreateLocation(subDirectory, key, create, false);
    }

    public File getProperFile(String fileName, String key, boolean create) {
        boolean wasAbsolute = false;
        if (!DefaultTypeTransformation.booleanUnbox((Object)fileName)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Application resource key '", "' is not defined or returns an empty value."})));
        }
        File dir = new File(this.getRootLocation(), fileName);
        File justName = new File(fileName);
        if (justName.isAbsolute()) {
            boolean bl;
            File file;
            dir = file = justName;
            wasAbsolute = bl = true;
        }
        return this.verifyOrCreateLocation(dir.getCanonicalFile(), key, create, wasAbsolute);
    }

    public File verifyOrCreateLocation(File dir, String key, boolean create, boolean wasAbsolute) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)dir)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Application resource key ", " is not defined or returns an empty value."})));
        }
        if (!dir.exists()) {
            if (!create) {
                throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Application resource ", " defines a missing directory at "}).plus((GString)new GStringImpl(new Object[]{dir.getCanonicalPath()}, new String[]{"", " which does not exist and must be manually created."}))));
            }
            if (wasAbsolute) {
                throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Application resource ", " defines a missing directory at "}).plus((GString)new GStringImpl(new Object[]{dir.getCanonicalPath()}, new String[]{"", " but the location does not exist.  It must be manually created."}))));
            }
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key, dir.getCanonicalPath()}, new String[]{"Application resource ", " should be a directory but ", " is not."})));
        }
        return dir.getCanonicalFile();
    }

    public Map mergeClientValues(Map args) {
        Object client = this.getCurrentTenant();
        Map localEnv = DefaultGroovyMethods.leftShift((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tenantId", DefaultGroovyMethods.getAt((Object)client, (String)"id"), "tenantSubDomain", DefaultGroovyMethods.getAt((Object)client, (String)"num")}), (Map)args);
        return localEnv;
    }

    public File getMonthDirectory(String configKey, boolean create) {
        String datePart = DateUtilExtensions.format((Date)new Date(), (String)"yyyy-MM");
        File baseDir = this.getLocation(configKey);
        File monthDir = new File(baseDir, datePart);
        return this.verifyOrCreateLocation(monthDir, configKey, create, false);
    }

    public String getRelativePath(String key, File child) {
        return this.getRelativePath(this.getLocation(key), child);
    }

    public String getRelativePath(File parent, File child) {
        return parent.getCanonicalFile().toURI().relativize(child.getCanonicalFile().toURI()).getPath();
    }

    public String getRelativeTempPath(File file) {
        return this.getRelativePath(this.getTempDir(), file);
    }

    public Object getResourceConfig(String subKey) {
        return this.grailsApplication.getConfig().getProperty(this.buildResourceKey(subKey), Object.class);
    }

    public String buildResourceKey(String subKey) {
        Validate.notEmpty((Object)subKey);
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.resourcesConfigRootKey, (CharSequence)"."), (CharSequence)subKey);
    }

    public void setConfiguration(Config co) {
        Object object = co.getProperty(this.buildResourceKey("rootLocation"), Closure.class);
        this.rootLocationClosure = (Closure)ScriptBytecodeAdapter.castToType((Object)object, Closure.class);
        Object object2 = co.getProperty(this.buildResourceKey("currentTenant"), Closure.class);
        this.currentTenantClosure = (Closure)ScriptBytecodeAdapter.castToType((Object)object2, Closure.class);
    }

    @Generated
    public Map createAttachmentFile(Long attachmentId, String name, String extension, Object data) {
        return this.createAttachmentFile(attachmentId, name, extension, data, null);
    }

    @Generated
    public File getLocation(String key, Map args) {
        return this.getLocation(key, args, true);
    }

    @Generated
    public File getLocation(String key) {
        return this.getLocation(key, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), true);
    }

    @Generated
    public List getScripts() {
        return this.getScripts(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public File getSubDirectory(String key, String relativePath, boolean create) {
        return this.getSubDirectory(key, relativePath, create, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public File getSubDirectory(String key, String relativePath) {
        return this.getSubDirectory(key, relativePath, true, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public File getProperFile(String fileName, String key) {
        return this.getProperFile(fileName, key, true);
    }

    @Generated
    public File verifyOrCreateLocation(File dir, String key, boolean create) {
        return this.verifyOrCreateLocation(dir, key, create, false);
    }

    @Generated
    public Map mergeClientValues() {
        return this.mergeClientValues(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public File getMonthDirectory(String configKey) {
        return this.getMonthDirectory(configKey, true);
    }

    @Generated
    public String getRelativePath(File child) {
        return this.getRelativePath("rootLocation", child);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AppResourceLoader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.grails.resource.AppResourceLoader");
    }

    @Generated
    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    @Generated
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    @Generated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Generated
    public String getResourcesConfigRootKey() {
        return this.resourcesConfigRootKey;
    }

    @Generated
    public void setResourcesConfigRootKey(String string) {
        this.resourcesConfigRootKey = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getResourceConfig";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "call";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "getProperty";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[6];
        AppResourceLoader.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AppResourceLoader.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AppResourceLoader.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

