/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import yakworks.commons.util.StringUtils;

public class NameUtils
implements GroovyObject {
    private static final Pattern DOT_UPPER;
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    public static final String DOLLAR_SEPARATOR;
    private static final Pattern SERVICE_ID_REGEX;
    private static final Pattern KEBAB_REPLACEMENTS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public NameUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String camelCase(String str) {
        return NameUtils.camelCase(str, true);
    }

    public static String toCamelCase(String text) {
        String string;
        public final class _toCamelCase_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toCamelCase_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(List<String> it) {
                return ((String)DefaultGroovyMethods.getAt(it, (int)2)).toUpperCase();
            }

            @Generated
            public String call(List<String> it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toCamelCase_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        text = string = StringGroovyMethods.replaceAll((CharSequence)text.toLowerCase(), (CharSequence)"(_)([A-Za-z0-9])", (Closure)new _toCamelCase_closure1(NameUtils.class, NameUtils.class));
        return text;
    }

    public static String camelCase(String str, boolean lowerCaseFirstLetter) {
        String string;
        public final class _camelCase_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _camelCase_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(List<String> it) {
                return ((String)DefaultGroovyMethods.getAt(it, (int)2)).toUpperCase();
            }

            @Generated
            public String call(List<String> it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _camelCase_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        str = string = StringGroovyMethods.replaceAll((CharSequence)str.toLowerCase(), (CharSequence)"(_)([A-Za-z0-9])", (Closure)new _camelCase_closure2(NameUtils.class, NameUtils.class));
        StringBuilder sb = new StringBuilder(str.length());
        String s2 = null;
        String[] stringArray = str.split("[\\s_-]");
        if (stringArray != null) {
            for (String s2 : stringArray) {
                String capitalize = NameUtils.capitalize(s2);
                sb.append(capitalize);
            }
        }
        String result = sb.toString();
        if (lowerCaseFirstLetter) {
            return NameUtils.decapitalize(result);
        }
        return result;
    }

    public static String getSetterName(String propertyName) {
        String suffix = NameUtils.getSuffixForGetterOrSetter(propertyName);
        return StringGroovyMethods.plus((String)PROPERTY_SET_PREFIX, (CharSequence)suffix);
    }

    public static String getGetterName(String propertyName) {
        String suffix = NameUtils.getSuffixForGetterOrSetter(propertyName);
        return StringGroovyMethods.plus((String)PROPERTY_GET_PREFIX, (CharSequence)suffix);
    }

    public static String getSuffixForGetterOrSetter(String propertyName) {
        String suffix = null;
        if (propertyName.length() > 1 && Character.isLowerCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1))) {
            String string;
            suffix = string = propertyName;
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)}, new String[]{"", "", ""});
            suffix = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return suffix;
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (NameUtils.isBlank(logicalName)) {
            throw (Throwable)new IllegalArgumentException("Argument [logicalName] cannot be null or blank");
        }
        String className = StringGroovyMethods.plus((String)logicalName.substring(0, 1).toUpperCase(Locale.ENGLISH), (CharSequence)logicalName.substring(1));
        if (trailingName != null) {
            String string;
            className = string = StringGroovyMethods.plus((String)className, (CharSequence)trailingName);
        }
        return className;
    }

    public static String getFullClassName(Class cls) {
        String className = cls.getName();
        return NameUtils.getFullClassName(className);
    }

    public static String getFullClassName(String className) {
        int i = className.indexOf("$");
        if (i > -1) {
            String string;
            className = string = className.substring(0, i);
        }
        return className;
    }

    public static String getClassName(String logicalName) {
        return NameUtils.getClassName(logicalName, "");
    }

    public static String getClassName(Class clazz) {
        String sn = clazz.getSimpleName();
        if (sn.contains(DOLLAR_SEPARATOR)) {
            return clazz.getSuperclass().getName();
        }
        return clazz.getName();
    }

    public static String getClassNameRepresentation(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String[] tokens = name.split("[^\\w\\d]");
        String token12 = null;
        String[] stringArray = tokens;
        if (tokens != null) {
            for (String token12 : stringArray) {
                String token = token12.trim();
                int length = token.length();
                if (!(length > 0)) continue;
                buf.append(token.substring(0, 1).toUpperCase(Locale.ENGLISH));
                if (!(length > 1)) continue;
                buf.append(token.substring(1));
            }
        }
        return buf.toString();
    }

    public static String capitalize(String name) {
        if (NameUtils.isBlank(name)) {
            return name;
        }
        return StringGroovyMethods.plus((String)name.substring(0, 1).toUpperCase(), (CharSequence)name.substring(1));
    }

    public static String getClassNameFromKebabCase(String name) {
        if (NameUtils.isBlank(name)) {
            return name;
        }
        if (name.indexOf("-") == -1) {
            return StringGroovyMethods.plus((String)name.substring(0, 1).toUpperCase(), (CharSequence)name.substring(1));
        }
        StringBuilder buf = new StringBuilder();
        String[] tokens = name.split("-");
        String token2 = null;
        String[] stringArray = tokens;
        if (tokens != null) {
            for (String token2 : stringArray) {
                if (token2 == null || token2.length() == 0) continue;
                buf.append(token2.substring(0, 1).toUpperCase()).append(token2.substring(1));
            }
        }
        return buf.toString();
    }

    public static String getPropertyName(String name) {
        return NameUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return NameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        return NameUtils.getPropertyNameRepresentation(NameUtils.getShortName(targetClass));
    }

    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            String string;
            name = string = name.substring(pos + 1);
        }
        if (name.isEmpty()) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = StringGroovyMethods.plus((String)name.substring(0, 1).toLowerCase(Locale.ENGLISH), (CharSequence)name.substring(1));
        if (propertyName.indexOf(" ") > -1) {
            String string;
            propertyName = string = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameFromKebabCase(String name) {
        return NameUtils.getPropertyName(NameUtils.getClassNameFromKebabCase(name));
    }

    public static String getShortName(Class<?> targetClass) {
        return NameUtils.getShortName(targetClass.getName());
    }

    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (i > -1) {
            String string;
            className = string = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getPackageName(String className) {
        int i = className.lastIndexOf(".");
        String packageName = "";
        if (i > -1) {
            String string;
            packageName = string = className.substring(0, i);
        }
        return packageName;
    }

    public static boolean isHyphenatedLowerCase(String name) {
        return StringUtils.isNotEmpty(name) && SERVICE_ID_REGEX.matcher(name).matches() && Character.isLetter(name.charAt(0));
    }

    public static String hyphenate(String name) {
        return NameUtils.hyphenate(name, true);
    }

    public static String hyphenate(String name, boolean lowerCase) {
        if (NameUtils.isHyphenatedLowerCase(name)) {
            return KEBAB_REPLACEMENTS.matcher(name).replaceAll("-");
        }
        char separatorChar = '-';
        return NameUtils.separateCamelCase(KEBAB_REPLACEMENTS.matcher(name).replaceAll("-"), lowerCase, separatorChar);
    }

    public static String getNaturalName(String name) {
        String string;
        name = string = NameUtils.getShortName(name);
        List words = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        int i = 0;
        char[] chars = name.toCharArray();
        int j = 0;
        while (j < chars.length) {
            char c = BytecodeInterface8.cArrayGet((char[])chars, (int)j);
            String w = null;
            if (i >= words.size()) {
                String string2;
                w = string2 = "";
                words.add(i, w);
            } else {
                Object e = words.get(i);
                w = ShortTypeHandling.castToString(e);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    char c2;
                    c = c2 = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    String string3;
                    w = string3 = "";
                    words.add(++i, w);
                }
                words.set(i, StringGroovyMethods.plus((CharSequence)w, (Object)Character.valueOf(c)));
            } else if (Character.isUpperCase(c)) {
                if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1)) && Character.isUpperCase(BytecodeInterface8.cArrayGet((char[])chars, (int)(j - 1)))) {
                    words.set(i, StringGroovyMethods.plus((CharSequence)w, (Object)Character.valueOf(c)));
                } else {
                    words.add(++i, String.valueOf(c));
                }
            }
            int n = j;
            int cfr_ignored_0 = n + 1;
        }
        StringBuilder buf = new StringBuilder();
        Iterator j2 = words.iterator();
        while (j2.hasNext()) {
            String word = ShortTypeHandling.castToString(j2.next());
            buf.append(word);
            if (!j2.hasNext()) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String getPropertyNameConvention(Object object) {
        String suffix = "";
        return NameUtils.getPropertyNameConvention(object, suffix);
    }

    public static boolean isValidJavaPackage(String packageName) {
        if (NameUtils.isBlank(packageName)) {
            return false;
        }
        String[] parts = packageName.split("\\.");
        String part2 = null;
        String[] stringArray = parts;
        if (parts != null) {
            for (String part2 : stringArray) {
                if (!(!NameUtils.isValidJavaIdentifier(part2))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String name) {
        if (NameUtils.isBlank(name)) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(BytecodeInterface8.cArrayGet((char[])chars, (int)0))) {
            return false;
        }
        char c2 = '\u0000';
        char[] cArray = chars;
        if (chars != null) {
            for (char c2 : cArray) {
                if (!(!Character.isJavaIdentifierPart(c2))) continue;
                return false;
            }
        }
        return true;
    }

    public static String getPropertyNameConvention(Object object, String suffix) {
        if (object != null) {
            Class<?> type = object.getClass();
            if (type.isArray()) {
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(type.getComponentType()), (CharSequence)suffix), (CharSequence)"Array");
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
                if (coll.isEmpty()) {
                    return "emptyCollection";
                }
                Object first = coll.iterator().next();
                if (coll instanceof List) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(first.getClass()), (CharSequence)suffix), (CharSequence)"List");
                }
                if (coll instanceof Set) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(first.getClass()), (CharSequence)suffix), (CharSequence)"Set");
                }
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(first.getClass()), (CharSequence)suffix), (CharSequence)"Collection");
            }
            if (object instanceof Map) {
                Map map = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
                if (map.isEmpty()) {
                    return "emptyMap";
                }
                Object entry = map.values().iterator().next();
                if (entry != null) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)NameUtils.getPropertyName(entry.getClass()), (CharSequence)suffix), (CharSequence)"Map");
                }
            } else {
                return StringGroovyMethods.plus((String)NameUtils.getPropertyName(object.getClass()), (CharSequence)suffix);
            }
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String getPropertyForGetter(String getterName) {
        return NameUtils.getPropertyForGetter(getterName, Boolean.TYPE);
    }

    public static String getPropertyForGetter(String getterName, Class returnType) {
        if (getterName == null || getterName.length() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        if (getterName.startsWith(PROPERTY_GET_PREFIX)) {
            String prop = getterName.substring(3);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        if (getterName.startsWith("is") && ScriptBytecodeAdapter.compareEqual((Object)returnType, Boolean.TYPE)) {
            String prop = getterName.substring(2);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String convertValidPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return ShortTypeHandling.castToString(null);
        }
        if (suffix.length() == 1) {
            return ShortTypeHandling.castToString((Object)(Character.isUpperCase(suffix.charAt(0)) ? suffix.toLowerCase() : null));
        }
        if (Character.isUpperCase(suffix.charAt(1))) {
            return suffix;
        }
        if (Character.isUpperCase(suffix.charAt(0))) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Character.valueOf(Character.toLowerCase(suffix.charAt(0))), suffix.substring(1)}, new String[]{"", "", ""}));
        }
        if ('_' == suffix.charAt(0)) {
            return suffix;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static boolean isGetter(String name, Class<?> ... args) {
        return NameUtils.isGetter(name, Boolean.TYPE, args);
    }

    public static boolean isGetter(String name, Class returnType, Class<?> ... args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        if (name.startsWith(PROPERTY_GET_PREFIX)) {
            String string;
            name = string = name.substring(3);
            if (NameUtils.isPropertyMethodSuffix(name)) {
                return true;
            }
        } else if (name.startsWith("is") && ScriptBytecodeAdapter.compareEqual((Object)returnType, Boolean.TYPE)) {
            String string;
            name = string = name.substring(2);
            if (NameUtils.isPropertyMethodSuffix(name)) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return false;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0));
        }
        return Character.isUpperCase(suffix.charAt(0)) || Character.isUpperCase(suffix.charAt(1));
    }

    public static String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        if (setterName.startsWith(PROPERTY_SET_PREFIX)) {
            String prop = setterName.substring(3);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String decapitalize(String name) {
        if (name == null) {
            return ShortTypeHandling.castToString(null);
        }
        int length = name.length();
        if (length == 0) {
            return name;
        }
        boolean firstUpper = Character.isUpperCase(name.charAt(0));
        if (firstUpper) {
            if (length == 1) {
                return Character.toString(Character.toLowerCase(name.charAt(0)));
            }
            int i = 1;
            while (i < Math.min(length, 3)) {
                if (Character.isLowerCase(name.charAt(i))) {
                    char[] chars = name.toCharArray();
                    char c = Character.toLowerCase(BytecodeInterface8.cArrayGet((char[])chars, (int)0));
                    BytecodeInterface8.cArraySet((char[])chars, (int)0, (char)c);
                    return new String(chars);
                }
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        return name;
    }

    public static String getSimpleName(String className) {
        Matcher matcher = DOT_UPPER.matcher(className);
        if (matcher.find()) {
            int position = matcher.start();
            return className.substring(position + 1);
        }
        return className;
    }

    private static String separateCamelCase(String name, boolean lowerCase, char separatorChar) {
        if (!lowerCase) {
            StringBuilder newName = new StringBuilder();
            boolean first = true;
            char last = '0';
            char c = '\u0000';
            char[] cArray = name.toCharArray();
            if (cArray != null) {
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c2;
                    c = cArray[n2];
                    ++n2;
                    if (first) {
                        boolean bl;
                        newName.append(c);
                        first = bl = false;
                    } else if (Character.isUpperCase(c) && !Character.isUpperCase(last)) {
                        if (c != separatorChar) {
                            newName.append(separatorChar);
                        }
                        newName.append(c);
                    } else {
                        if (c == '.') {
                            boolean bl;
                            first = bl = true;
                        }
                        if (c != separatorChar) {
                            if (last == separatorChar) {
                                newName.append(separatorChar);
                            }
                            newName.append(c);
                        }
                    }
                    last = c2 = c;
                }
            }
            return newName.toString();
        }
        StringBuilder newName = new StringBuilder();
        char[] chars = name.toCharArray();
        boolean first = true;
        char last = '0';
        char secondLast = separatorChar;
        int i = 0;
        while (i < chars.length) {
            char c;
            char c3 = BytecodeInterface8.cArrayGet((char[])chars, (int)i);
            if (Character.isLowerCase(c3) || !Character.isLetter(c3)) {
                boolean bl;
                first = bl = false;
                if (c3 != separatorChar) {
                    if (last == separatorChar) {
                        newName.append(separatorChar);
                    }
                    newName.append(c3);
                }
            } else {
                char lowerCaseChar = Character.toLowerCase(c3);
                if (first) {
                    boolean bl;
                    first = bl = false;
                    newName.append(lowerCaseChar);
                } else if (Character.isUpperCase(last) || last == '.') {
                    newName.append(lowerCaseChar);
                } else if (Character.isDigit(last) && (Character.isUpperCase(secondLast) || secondLast == separatorChar)) {
                    newName.append(lowerCaseChar);
                } else {
                    newName.append(separatorChar).append(lowerCaseChar);
                }
            }
            if (i > 1) {
                char c4;
                secondLast = c4 = last;
            }
            last = c = c3;
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return newName.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NameUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        String string;
        DOLLAR_SEPARATOR = string = "$";
        DOT_UPPER = pattern3 = Pattern.compile("\\.[A-Z\\$]");
        SERVICE_ID_REGEX = pattern2 = Pattern.compile("[\\p{javaLowerCase}\\d-]+");
        KEBAB_REPLACEMENTS = pattern = Pattern.compile("[_ ]");
    }
}

