/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class LocalDateUtils
implements GroovyObject {
    private static final Pattern LOCAL_DATE;
    private static final Pattern ISO_YEAR_MONTH;
    private static final Pattern ISO_YEAR_MONTH_NO_HYPHEN;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public LocalDateUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static LocalDate parse(String date) {
        String string;
        String string2 = date;
        date = string = string2 != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (LocalDate)ScriptBytecodeAdapter.castToType(null, LocalDate.class);
        }
        LocalDate localDate = LocalDate.parse(date);
        try {
            return localDate;
        }
        catch (DateTimeParseException e) {
            LocalDate localDate2 = LocalDate.parse(date, DateTimeFormatter.ISO_DATE_TIME);
            return localDate2;
        }
    }

    public static LocalDateTime parseLocalDateTime(String date) {
        String string;
        String string2 = date;
        date = string = string2 != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (LocalDateTime)ScriptBytecodeAdapter.castToType(null, LocalDateTime.class);
        }
        if (StringGroovyMethods.matches((CharSequence)date, (Pattern)LOCAL_DATE)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{date}, new String[]{"", "T00:00"});
            date = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static Temporal parseTemporal(String date) {
        String string;
        String string2 = date;
        date = string = string2 != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (Temporal)ScriptBytecodeAdapter.castToType(null, Temporal.class);
        }
        if (LocalDateUtils.isLocalDate(date)) {
            return LocalDateUtils.parse(date);
        }
        LocalDateTime localDateTime = LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
        try {
            return localDateTime;
        }
        catch (DateTimeParseException e) {
            Temporal temporal = (Temporal)ScriptBytecodeAdapter.castToType(null, Temporal.class);
            return temporal;
        }
    }

    public static boolean isLocalDate(String date) {
        String string;
        String string2 = date;
        date = string = string2 != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)date) || !StringGroovyMethods.matches((CharSequence)date, (Pattern)LOCAL_DATE)) {
            return false;
        }
        return DefaultTypeTransformation.booleanUnbox(null);
    }

    public static boolean isLocalDateTime(String date) {
        String string;
        String string2 = date;
        date = string = string2 != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return false;
        }
        LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
        boolean bl = true;
        try {
            return bl;
        }
        catch (DateTimeParseException e) {
            boolean bl2 = false;
            return bl2;
        }
    }

    public static LocalDate getFirstDateOfMonth() {
        return LocalDateUtils.getFirstDateOfMonth(LocalDate.now());
    }

    public static LocalDate getFirstDateOfMonth(LocalDate locDate) {
        return locDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getLastDateOfMonth() {
        return LocalDateUtils.getLastDateOfMonth(LocalDate.now());
    }

    public static LocalDate getLastDateOfMonth(LocalDate locDate) {
        return locDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getLastDayOfWeek() {
        return LocalDateUtils.getLastDayOfWeek(LocalDate.now());
    }

    public static LocalDate getLastDayOfWeek(LocalDate locDate) {
        return locDate.with(DayOfWeek.SUNDAY);
    }

    public static int getDaysBetween(LocalDate start, LocalDate end) {
        return Period.between(start, end).getDays();
    }

    public static int getMonthDiff(LocalDate start, LocalDate end) {
        return Period.between(LocalDateUtils.getFirstDateOfMonth(start), LocalDateUtils.getFirstDateOfMonth(end)).getMonths();
    }

    public static boolean isTodayTheDate(ChronoUnit period, int dayNumber) {
        LocalDate thedate = LocalDate.now();
        ChronoUnit chronoUnit = period;
        if (ScriptBytecodeAdapter.isCase((Object)chronoUnit, (Object)ChronoUnit.DAYS)) {
            return true;
        }
        if (ScriptBytecodeAdapter.isCase((Object)chronoUnit, (Object)ChronoUnit.WEEKS)) {
            return DayOfWeek.from(thedate).getValue() == dayNumber;
        }
        if (ScriptBytecodeAdapter.isCase((Object)chronoUnit, (Object)ChronoUnit.MONTHS)) {
            return thedate.getDayOfMonth() == dayNumber;
        }
        return false;
    }

    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return ScriptBytecodeAdapter.compareEqual((Object)date1.toLocalDate(), (Object)date2.toLocalDate());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LocalDateUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[01])$");
        LOCAL_DATE = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        Object object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}-(0[1-9]|1[0-2])$");
        ISO_YEAR_MONTH = (Pattern)ScriptBytecodeAdapter.castToType((Object)object2, Pattern.class);
        Object object3 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\\d{4}(0[1-9]|1[0-2])$");
        ISO_YEAR_MONTH_NO_HYPHEN = (Pattern)ScriptBytecodeAdapter.castToType((Object)object3, Pattern.class);
    }

    @Generated
    public static Pattern getLOCAL_DATE() {
        return LOCAL_DATE;
    }

    @Generated
    public static Pattern getISO_YEAR_MONTH() {
        return ISO_YEAR_MONTH;
    }

    @Generated
    public static Pattern getISO_YEAR_MONTH_NO_HYPHEN() {
        return ISO_YEAR_MONTH_NO_HYPHEN;
    }
}

