/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class DateUtil
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DateUtil() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Calendar getCurrentCalendarInstance() {
        return DateUtil.getCalendarInstanceByDate(new Date());
    }

    public static Calendar getCalendarInstanceByDate(Date date) {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTime(date);
        return calendarDate;
    }

    public static String getMonthLetter(String periodToPost) {
        String monthLetter = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)periodToPost) && periodToPost.length() >= 5) {
            String string;
            String month = periodToPost.substring(4, 6);
            monthLetter = string = StringGroovyMethods.isInteger((CharSequence)month) ? DateUtil.getMonthLetterByNum(Integer.parseInt(month)) : "?";
        } else {
            String string;
            monthLetter = string = "?";
        }
        return monthLetter;
    }

    public static String getMonthLetterByNum(int monthNumber) {
        Object[] monthNames = new DateFormatSymbols().getMonths();
        return (new IntRange(true, 1, 12) == null ? false : DefaultGroovyMethods.isCase((Collection)new IntRange(true, 1, 12), (Object)monthNumber)) ? StringGroovyMethods.getAt((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])monthNames, (int)(monthNumber - 1))), (int)0) : "?";
    }

    public static Date convertStringToDateTime(String strDt, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
        Date dtTmp = null;
        try {
            Date date;
            dtTmp = date = df.parse(strDt);
        }
        catch (ParseException e) {
        }
        return dtTmp;
    }

    public static int getYearOf(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return gc.get(Calendar.YEAR);
    }

    public static int getYearOf(TemporalAccessor date) {
        return Year.from(date).getValue();
    }

    public static long getDateDifference_inHours(Date date) {
        Calendar lastModifiedDateCalendar = DateUtil.getCalendarInstanceByDate(date);
        long diff = DateUtil.getCurrentCalendarInstance().getTimeInMillis() - lastModifiedDateCalendar.getTimeInMillis();
        return DefaultTypeTransformation.longUnbox((Object)ScriptBytecodeAdapter.asType((Object)NumberNumberDiv.div((Number)Math.abs(diff), (Number)(60 * 60 * 1000)), Long.TYPE));
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (LocalDate)ScriptBytecodeAdapter.castToType(null, LocalDate.class);
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)date)) {
            return (LocalDateTime)ScriptBytecodeAdapter.castToType(null, LocalDateTime.class);
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDateTime();
    }

    public static Date fromLocalDate(LocalDate localDate, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)localDate)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        return Date.from(localDate.atStartOfDay(zoneId).toInstant());
    }

    public static Date fromLocalDateTime(LocalDateTime localDate, ZoneId zoneId) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)localDate)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        return Date.from(localDate.atZone(zoneId).toInstant());
    }

    public static Date convertToDate(Object temporal) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)temporal)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        if (temporal instanceof Date) {
            return (Date)ScriptBytecodeAdapter.castToType((Object)temporal, Date.class);
        }
        if (temporal instanceof LocalDate) {
            return DateUtil.fromLocalDate((LocalDate)ScriptBytecodeAdapter.castToType((Object)temporal, LocalDate.class));
        }
        if (temporal instanceof LocalDateTime) {
            return DateUtil.fromLocalDateTime((LocalDateTime)ScriptBytecodeAdapter.castToType((Object)temporal, LocalDateTime.class));
        }
        return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        LocalDate ld1 = LocalDateTime.ofInstant(date1.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate ld2 = LocalDateTime.ofInstant(date2.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return ScriptBytecodeAdapter.compareEqual((Object)ld1, (Object)ld2);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DateUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static LocalDate toLocalDate(Date date) {
        CallSite[] callSiteArray = DateUtil.$getCallSiteArray();
        return DateUtil.toLocalDate(date, (ZoneId)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(ZoneId.class), ZoneId.class));
    }

    @Generated
    public static LocalDateTime toLocalDateTime(Date date) {
        CallSite[] callSiteArray = DateUtil.$getCallSiteArray();
        return DateUtil.toLocalDateTime(date, (ZoneId)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(ZoneId.class), ZoneId.class));
    }

    @Generated
    public static Date fromLocalDate(LocalDate localDate) {
        CallSite[] callSiteArray = DateUtil.$getCallSiteArray();
        return DateUtil.fromLocalDate(localDate, (ZoneId)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(ZoneId.class), ZoneId.class));
    }

    @Generated
    public static Date fromLocalDateTime(LocalDateTime localDate) {
        CallSite[] callSiteArray = DateUtil.$getCallSiteArray();
        return DateUtil.fromLocalDateTime(localDate, (ZoneId)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(ZoneId.class), ZoneId.class));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "systemDefault";
        stringArray[1] = "systemDefault";
        stringArray[2] = "systemDefault";
        stringArray[3] = "systemDefault";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[4];
        DateUtil.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DateUtil.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DateUtil.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

