/*
 * Decompiled with CFR 0.152.
 */
package yakworks.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import groovy.lang.GString;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class ObjectMapperWrapper
implements Serializable {
    public static final ObjectMapperWrapper instance = new ObjectMapperWrapper();
    private final ObjectMapper objectMapper;

    public ObjectMapperWrapper() {
        this(ObjectMapperWrapper.setupDefaultObjectMapper());
    }

    public ObjectMapperWrapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectMapper setupDefaultObjectMapper() {
        return new ObjectMapper().findAndRegisterModules().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new SimpleModule().addSerializer(OffsetDateTime.class, (JsonSerializer)OffsetDateTimeSerializer.INSTANCE).addDeserializer(OffsetDateTime.class, (JsonDeserializer)OffsetDateTimeDeserializer.INSTANCE));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public <T> T fromString(String string, Class<T> clazz) throws JsonProcessingException {
        return (T)this.objectMapper.readValue(string, clazz);
    }

    public <T> T fromString(String string, Type type) throws JsonProcessingException {
        return (T)this.objectMapper.readValue(string, this.objectMapper.getTypeFactory().constructType(type));
    }

    public <T> T fromBytes(byte[] value, Class<T> clazz) throws IOException {
        return (T)this.objectMapper.readValue(value, clazz);
    }

    public <T> T fromBytes(byte[] value, Type type) throws IOException {
        return (T)this.objectMapper.readValue(value, this.objectMapper.getTypeFactory().constructType(type));
    }

    public String toString(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(value);
    }

    public byte[] toBytes(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsBytes(value);
    }

    public JsonNode toJsonNode(String value) throws JsonProcessingException {
        return this.objectMapper.readTree(value);
    }

    public static class GStringJsonSerializer
    extends JsonSerializer<GString> {
        public static final GStringJsonSerializer INSTANCE = new GStringJsonSerializer();

        public void serialize(GString gstring, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (gstring == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(gstring.toString());
            }
        }

        public Class<GString> handledType() {
            return GString.class;
        }
    }

    public static class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        public static final OffsetDateTimeDeserializer INSTANCE = new OffsetDateTimeDeserializer();

        public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getText() != null) {
                try {
                    return OffsetDateTime.parse(jsonParser.getText(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                }
                catch (DateTimeParseException e) {
                    Date date = new Date((long)jsonParser.getDoubleValue() * 1000L);
                    return date.toInstant().atOffset(ZoneOffset.UTC);
                }
            }
            return null;
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }
    }

    public static class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        public static final OffsetDateTimeSerializer INSTANCE = new OffsetDateTimeSerializer();

        public void serialize(OffsetDateTime offsetDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (offsetDateTime == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }
    }
}

