/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.io;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import yakworks.commons.lang.Validate;

public abstract class PathTools
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public PathTools() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean deleteDirectory(Path root) {
        if (root == null) {
            return false;
        }
        boolean bl = DefaultTypeTransformation.booleanUnbox((Object)PathUtils.deleteDirectory((Path)root));
        try {
            return bl;
        }
        catch (IOException ex) {
            boolean bl2 = false;
            return bl2;
        }
    }

    public static long delete(Path fileOrDir) {
        if (fileOrDir == null) {
            return 0;
        }
        Counters.PathCounters cntr = PathUtils.delete((Path)fileOrDir);
        return cntr.getDirectoryCounter().get() + cntr.getFileCounter().get();
    }

    /*
     * WARNING - void declaration
     */
    public static void copyRecursively(Path src, Path dest) {
        void var1_1;
        Reference src2 = new Reference((Object)src);
        Reference dest2 = new Reference((Object)var1_1);
        Validate.notNull((Path)src2.get(), "[src]");
        Validate.notNull((Path)src2.get(), "[dest]");
        BasicFileAttributes srcAttr = Files.readAttributes((Path)src2.get(), BasicFileAttributes.class, new LinkOption[0]);
        if (srcAttr.isDirectory()) {
            Files.walkFileTree((Path)src2.get(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new GroovyObject(dest2, src2){
                public /* synthetic */ Reference src;
                public /* synthetic */ Reference dest;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    this.dest = reference2 = p0;
                    this.src = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Files.createDirectories(((Path)this.dest.get()).resolve(((Path)this.src.get()).relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Files.copy(file, ((Path)this.dest.get()).resolve(((Path)this.src.get()).relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    if (!(args instanceof Object[])) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                    }
                    if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                    }
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    if (!(args instanceof Object[])) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                    }
                    if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                    }
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, PathTools.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                @Transient
                public MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }
            });
        } else if (srcAttr.isRegularFile()) {
            Files.copy((Path)src2.get(), (Path)dest2.get(), new CopyOption[0]);
        } else {
            throw (Throwable)new IllegalArgumentException("Source File must denote a directory or file");
        }
    }

    public static Path createDirectories(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }

    public static Path createParentDirectories(Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return (Path)ScriptBytecodeAdapter.castToType(null, Path.class);
        }
        return Files.createDirectories(parent, new FileAttribute[0]);
    }

    public static String getBaseName(String filename) {
        return PathTools.getBaseName(Paths.get(filename, new String[0]));
    }

    public static String getBaseName(Path path) {
        return PathTools.removeFileExtension(path.getFileName().toString());
    }

    public static String removeFileExtension(String filename, boolean removeAllExtensions) {
        if (filename == null || filename.isEmpty()) {
            return filename;
        }
        return filename.replaceAll(PathTools.extensionPattern(removeAllExtensions), "");
    }

    public static String extensionPattern(boolean wholeExtension) {
        return StringGroovyMethods.plus((String)"(?<!^)[.]", (CharSequence)(wholeExtension ? ".*" : "[^.]*$"));
    }

    public static String getExtension(String fileName) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)fileName)) {
            return "";
        }
        return PathTools.getExtension(Paths.get(fileName, new String[0]));
    }

    public static String getExtension(Path path, boolean wholeExtension) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)path)) {
            return "";
        }
        String fileName = ShortTypeHandling.castToString((Object)path.getFileName());
        Matcher match = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)fileName, (Object)PathTools.extensionPattern(wholeExtension)), Matcher.class);
        return ShortTypeHandling.castToString(StringGroovyMethods.size((Matcher)match) != 0L ? ((String)ScriptBytecodeAdapter.asType((Object)StringGroovyMethods.getAt((Matcher)match, (int)0), String.class)).substring(1) : null);
    }

    public static String extractMimeType(String filename) {
        return PathTools.extractMimeType(Paths.get(filename, new String[0]));
    }

    public static String extractMimeType(Path path) {
        String string;
        String fileName = ShortTypeHandling.castToString((Object)path.getFileName());
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)mimeType)) {
            LinkedHashMap mimeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"doc", "application/msword", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "xls", "application/vnd.ms-excel", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}), LinkedHashMap.class);
            String exten = PathTools.getExtension(fileName);
            if (mimeMap.containsKey(exten)) {
                return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)mimeMap, (Object)exten));
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)(string = mimeType)) ? string : "application/octet-stream";
    }

    public static String changeExtension(String name, String newExtension) {
        String changed = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)name.substring(0, name.lastIndexOf(".")), (CharSequence)"."), (CharSequence)newExtension);
        return changed;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PathTools.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PathTools.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PathTools.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PathTools.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PathTools.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PathTools.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static String removeFileExtension(String filename) {
        CallSite[] callSiteArray = PathTools.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return PathTools.removeFileExtension(filename, false);
        }
        return PathTools.removeFileExtension(filename, false);
    }

    @Generated
    public static String extensionPattern() {
        CallSite[] callSiteArray = PathTools.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return PathTools.extensionPattern(false);
        }
        return PathTools.extensionPattern(false);
    }

    @Generated
    public static String getExtension(Path path) {
        CallSite[] callSiteArray = PathTools.$getCallSiteArray();
        return PathTools.getExtension(path, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(PathTools.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PathTools.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

