/*
 * Decompiled with CFR 0.152.
 */
package yakworks.hibernate.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyConfiguration;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;
import org.hibernate.type.CompositeType;
import yakworks.hibernate.proxy.ByteBuddyGroovyInterceptor;
import yakworks.hibernate.proxy.ReflectToStringHelper;

public class ByteBuddyGroovyProxyFactory
implements ProxyFactory,
Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ByteBuddyGroovyProxyFactory.class);
    protected final ByteBuddyProxyHelper byteBuddyProxyHelper;
    protected Class persistentClass;
    protected String entityName;
    protected Class[] interfaces;
    protected Method getIdentifierMethod;
    protected Method setIdentifierMethod;
    protected CompositeType componentIdType;
    protected boolean overridesEquals;
    protected boolean overridesToString;
    protected Class proxyClass;

    public ByteBuddyGroovyProxyFactory(ByteBuddyProxyHelper byteBuddyProxyHelper) {
        this.byteBuddyProxyHelper = byteBuddyProxyHelper;
    }

    public void postInstantiate(String entityName, Class persistentClass, Set<Class> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.interfaces = ByteBuddyGroovyProxyFactory.toArray(interfaces);
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.componentIdType = componentIdType;
        this.overridesEquals = ReflectHelper.overridesEquals((Class)persistentClass);
        this.overridesToString = ReflectToStringHelper.overridesToString(persistentClass);
        this.proxyClass = this.byteBuddyProxyHelper.buildProxy(persistentClass, this.interfaces);
    }

    public static Class[] toArray(Set<Class> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public HibernateProxy getProxy(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        ProxyConfiguration.Interceptor interceptor = this.buildInterceptor(id, session);
        try {
            HibernateProxy proxy = (HibernateProxy)this.proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ((ProxyConfiguration)proxy).$$_hibernate_set_interceptor(interceptor);
            return proxy;
        }
        catch (NoSuchMethodException e) {
            String logMessage = LOG.bytecodeEnhancementFailedBecauseOfDefaultConstructor(this.entityName);
            LOG.error((Object)logMessage, (Throwable)e);
            throw new HibernateException(logMessage, (Throwable)e);
        }
        catch (Throwable t) {
            String logMessage = LOG.bytecodeEnhancementFailed(this.entityName);
            LOG.error((Object)logMessage, t);
            throw new HibernateException(logMessage, t);
        }
    }

    ProxyConfiguration.Interceptor buildInterceptor(Serializable id, SharedSessionContractImplementor session) {
        ByteBuddyGroovyInterceptor interceptor = new ByteBuddyGroovyInterceptor(this.entityName, this.persistentClass, this.interfaces, id, this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType, session, this.overridesEquals, this.overridesToString);
        return interceptor;
    }
}

