/*
 * Decompiled with CFR 0.152.
 */
package yakworks.i18n;

import java.lang.reflect.Array;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import yakworks.i18n.DefaultMsgKey;

public interface MsgKey<E> {
    default public String getCode() {
        return null;
    }

    default public void setCode(String code) {
    }

    default public E code(String code) {
        this.setCode(code);
        return (E)this;
    }

    @Nullable
    default public Object getArgs() {
        return null;
    }

    default public void setArgs(Object args) {
    }

    default public E args(Object args) {
        if (MsgKey.isEmpty(args)) {
            args = Collections.emptyMap();
        } else if (MsgKey.isArray(args)) {
            Object[] argsray = (Object[])args;
            Object object = args = MsgKey.isFirstItemMap(argsray) ? (Map)argsray[0] : Arrays.asList(argsray);
        }
        if (!(args instanceof Map) && !(args instanceof List)) {
            throw new IllegalArgumentException("Message arguments must be a Map, List or Object array");
        }
        this.setArgs(args);
        return (E)this;
    }

    default public Map getArgsMap() {
        return this.getArgs() instanceof Map ? (Map)this.getArgs() : null;
    }

    public String getFallbackMessage();

    default public void setFallbackMessage(String defMsg) {
    }

    default public E fallbackMessage(String defMsg) {
        this.setFallbackMessage(defMsg);
        return (E)this;
    }

    default public boolean isEmpty() {
        return MsgKey.isEmpty(this.getArgs());
    }

    default public String formatWith(Format messageFormat) {
        return this.getArgs() instanceof Map ? messageFormat.format((Map)this.getArgs()) : messageFormat.format(this.toArray());
    }

    default public Object[] toArray() {
        if (this.getArgs() == null) {
            return new Object[0];
        }
        return ((List)this.getArgs()).toArray(new Object[((List)this.getArgs()).size()]);
    }

    default public Map getArgMap() {
        Object curArgs = this.getArgs();
        if (curArgs == null) {
            LinkedHashMap argMap = new LinkedHashMap();
            this.setArgs(argMap);
            return argMap;
        }
        if (curArgs instanceof Map) {
            return (Map)curArgs;
        }
        return null;
    }

    default public Map putArg(Object key, Object val) {
        Map argMap = this.getArgMap();
        argMap.put(key, val);
        return argMap;
    }

    public static boolean isFirstItemMap(Object ... args) {
        return args.length == 1 && args[0] instanceof Map;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static String getFallbackMessage(String fieldMessage, Object args) {
        Map argMap;
        if (fieldMessage != null) {
            return fieldMessage;
        }
        if (args instanceof Map && !(argMap = (Map)args).isEmpty()) {
            if (argMap.containsKey("fallbackMessage")) {
                return (String)argMap.get("fallbackMessage");
            }
            if (argMap.containsKey("defaultMessage")) {
                return (String)argMap.get("defaultMessage");
            }
        }
        return null;
    }

    public static DefaultMsgKey of(String code) {
        return new DefaultMsgKey(code);
    }

    public static DefaultMsgKey of(String code, Object args) {
        return (DefaultMsgKey)new DefaultMsgKey(code).args(args);
    }
}

