/*
 * Decompiled with CFR 0.152.
 */
package yakworks.i18n;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import yakworks.i18n.DefaultMsgContext;
import yakworks.i18n.MsgKey;

public interface MsgContext<E>
extends MsgKey {
    default public Locale getLocale() {
        return null;
    }

    public E locale(Locale var1);

    public static DefaultMsgContext of(Locale loc) {
        return new DefaultMsgContext().locale(loc);
    }

    public static DefaultMsgContext of(Object args) {
        return new DefaultMsgContext().args(args);
    }

    public static DefaultMsgContext of(MsgKey msgKey) {
        return new DefaultMsgContext().args(msgKey.getArgs()).fallbackMessage(msgKey.getFallbackMessage());
    }

    public static DefaultMsgContext withFallback(String fallback) {
        return new DefaultMsgContext().fallbackMessage(fallback);
    }

    public static DefaultMsgContext empty() {
        return new DefaultMsgContext();
    }

    default public E transform(Function transformation) {
        return this.getArgs().isMap() ? this.transformMap(transformation) : this.transformList(transformation);
    }

    default public E transformMap(Function transformation) {
        Map curArgMap = (Map)this.getArgs().get();
        LinkedHashMap newArgs = new LinkedHashMap(curArgMap.size());
        for (Map.Entry item : curArgMap.entrySet()) {
            newArgs.put(item.getKey(), transformation.apply(item.getValue()));
        }
        return (E)MsgContext.of(newArgs).locale(this.getLocale());
    }

    default public E transformList(Function transformation) {
        List curArgList = (List)this.getArgs().get();
        ArrayList newArgs = new ArrayList(curArgList.size());
        for (Object item : curArgList) {
            newArgs.add(transformation.apply(item));
        }
        return (E)MsgContext.of(newArgs).locale(this.getLocale());
    }
}

