/*
 * Decompiled with CFR 0.152.
 */
package yakworks.i18n;

import java.lang.reflect.Array;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class MsgArgs {
    private Object value;

    public static MsgArgs of(Object args) {
        return new MsgArgs().args(args);
    }

    public Object get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present, call args() to set first");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void setArgs(Object args) {
        if (MsgArgs.isEmpty(args)) {
            args = new LinkedHashMap();
        } else if (MsgArgs.isArray(args)) {
            Object[] argsray = (Object[])args;
            Object object = args = MsgArgs.isFirstItemMap(argsray) ? (Map)argsray[0] : Arrays.asList(argsray);
        }
        if (!(args instanceof Map) && !(args instanceof List)) {
            throw new IllegalArgumentException("Message arguments must be a Map, List or Object array");
        }
        this.value = args;
    }

    public MsgArgs args(Object args) {
        this.setArgs(args);
        return this;
    }

    public boolean isEmpty() {
        return MsgArgs.isEmpty(this.value);
    }

    public boolean isMap() {
        return this.value instanceof Map;
    }

    public String formatWith(Format messageFormat) {
        return this.isMap() ? messageFormat.format((Map)this.value) : messageFormat.format(this.toArray());
    }

    public Object[] toArray() {
        if (this.value == null) {
            return new Object[0];
        }
        return ((List)this.value).toArray(new Object[((List)this.value).size()]);
    }

    public Map asMap() {
        return this.isMap() ? (Map)this.value : null;
    }

    public Map putIfAbsent(Object key, Object val) {
        Map argsMap = this.asMap();
        if (argsMap != null) {
            argsMap.putIfAbsent(key, val);
        }
        return argsMap;
    }

    public Map put(Object key, Object val) {
        Map argMap = this.asMap();
        if (argMap != null) {
            argMap.put(key, val);
        }
        return argMap;
    }

    public String getFallbackMessage() {
        Map argMap;
        if (this.isMap() && !(argMap = this.asMap()).isEmpty()) {
            if (argMap.containsKey("fallbackMessage")) {
                return (String)argMap.get("fallbackMessage");
            }
            if (argMap.containsKey("defaultMessage")) {
                return (String)argMap.get("defaultMessage");
            }
        }
        return null;
    }

    public static MsgArgs empty() {
        return new MsgArgs().args(null);
    }

    public static boolean isFirstItemMap(Object ... args) {
        return args.length == 1 && args[0] instanceof Map;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }
}

