/*
 * Decompiled with CFR 0.152.
 */
package yakworks.i18n;

import java.util.Iterator;
import java.util.List;
import yakworks.i18n.MsgContext;
import yakworks.i18n.MsgKey;
import yakworks.i18n.MsgMultiKey;

public interface MsgService {
    public String getMessage(String var1, MsgContext var2);

    default public String get(String code, MsgContext msgContext) {
        return this.getMessage(code, msgContext);
    }

    default public String get(String code) {
        return this.get(MsgKey.ofCode(code));
    }

    default public String get(MsgKey msgKey) {
        return this.getMessage(msgKey.getCode(), MsgContext.of(msgKey));
    }

    default public String get(MsgContext context) {
        return this.getMessage(context.getCode(), context);
    }

    default public String get(String code, Object args, String fallbackMessage) {
        return this.getMessage(code, MsgContext.of(args).fallbackMessage(fallbackMessage));
    }

    default public String get(String code, Object args) {
        return this.getMessage(code, MsgContext.of(args));
    }

    default public String get(MsgMultiKey msgMultiKey) {
        List<String> codes = msgMultiKey.getCodes();
        if (codes != null) {
            String lastCode = "";
            Iterator<String> iterator = codes.iterator();
            while (iterator.hasNext()) {
                String code;
                lastCode = code = iterator.next();
                String message = this.get(code, MsgContext.of(msgMultiKey).useCodeAsDefaultMessage(false));
                if (message == null) continue;
                return message;
            }
            return this.get(lastCode, MsgContext.of(msgMultiKey).useCodeAsDefaultMessage(true));
        }
        return null;
    }

    public String interpolate(String var1, MsgContext var2);
}

