/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.common;

import gorm.tools.csv.CSVPathKeyMapReader;
import gorm.tools.csv.CsvToMapTransformer;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import yakworks.commons.io.FileUtil;
import yakworks.commons.lang.Validate;
import yakworks.rally.attachment.model.Attachment;

@Service
@Lazy
public class DefaultCsvToMapTransformer
implements CsvToMapTransformer,
GroovyObject {
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public DefaultCsvToMapTransformer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public List<Map> process(Map params) {
        Long attachmentId = (Long)ScriptBytecodeAdapter.asType(params.get("attachmentId"), Long.class);
        Object v = params.get("dataFilename");
        String dataFilename = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(v) ? v : "data.csv");
        Object v2 = params.get("headerPathDelimiter");
        String headerPathDelimiter = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(v2) ? v2 : ".");
        return this.processRows(attachmentId, dataFilename, headerPathDelimiter);
    }

    public List<Map<String, Object>> processRows(Long attachmentId, String dataFileName, String delim) {
        Attachment attachment = Attachment.get(attachmentId);
        Validate.notNull((Object)attachment, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{attachmentId}, new String[]{"Attachment not found : ", ""})));
        Resource zipR = attachment.getResource();
        Validate.notNull((Object)zipR);
        File zip = zipR.getFile();
        Validate.notNull((Object)zip);
        InputStream dataIn = FileUtil.getZipEntryInputStream((File)zip, (String)dataFileName);
        Validate.notNull((Object)dataIn, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dataFileName}, new String[]{"", " not found in zip"})));
        return this.processRows(dataIn, delim);
    }

    public List<Map<String, Object>> processRows(InputStream dataIn, String delim) {
        CSVPathKeyMapReader dataRowsReader = CSVPathKeyMapReader.of((Reader)new InputStreamReader(dataIn)).pathDelimiter(delim);
        return dataRowsReader.readAllRows();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultCsvToMapTransformer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.common.DefaultCsvToMapTransformer");
    }
}

