/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.orgs.repo;

import gorm.tools.async.AsyncService;
import gorm.tools.async.ParallelTools;
import gorm.tools.beans.map.MetaMapEntityService;
import gorm.tools.databinding.BindAction;
import gorm.tools.databinding.EntityMapBinder;
import gorm.tools.idgen.IdGenerator;
import gorm.tools.job.SyncJobArgs;
import gorm.tools.job.SyncJobContext;
import gorm.tools.job.SyncJobService;
import gorm.tools.mango.MangoDetachedCriteria;
import gorm.tools.mango.api.MangoQuery;
import gorm.tools.mango.api.QueryArgs;
import gorm.tools.mango.api.QueryMangoEntityApi;
import gorm.tools.model.Persistable;
import gorm.tools.model.SourceType;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.bulk.BulkableRepo;
import gorm.tools.repository.errors.RepoEntityErrors;
import gorm.tools.repository.events.AfterRemoveEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoEventPublisher;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.IdGeneratorRepo;
import grails.core.support.proxy.ProxyHandler;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidateable;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.mapping.core.Datastore;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.validation.Errors;
import yakworks.api.ApiResults;
import yakworks.rally.orgs.OrgMemberService;
import yakworks.rally.orgs.model.Contact;
import yakworks.rally.orgs.model.Location;
import yakworks.rally.orgs.model.Org;
import yakworks.rally.orgs.model.OrgSource;
import yakworks.rally.orgs.model.OrgType;
import yakworks.rally.orgs.repo.ContactRepo;
import yakworks.rally.orgs.repo.LocationRepo;
import yakworks.rally.orgs.repo.OrgSourceRepo;
import yakworks.rally.orgs.repo.OrgTagRepo;

public abstract class AbstractOrgRepo
implements GormRepo<Org>,
IdGeneratorRepo<Org>,
IdGeneratorRepo.Trait.FieldHelper,
GormRepo.Trait.FieldHelper,
QueryMangoEntityApi.Trait.FieldHelper,
BulkableRepo.Trait.FieldHelper,
GroovyObject {
    private LocationRepo locationRepo;
    private ContactRepo contactRepo;
    private OrgTagRepo orgTagRepo;
    private OrgSourceRepo orgSourceRepo;
    private OrgMemberService orgMemberService;
    private List<String> toOneAssociations;
    @Autowired(required=true)
    private RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher;
    @Resource(shareable=true, lookup="", name="idGenerator", description="", type=Object.class, mappedName="")
    private IdGenerator gorm_tools_repository_model_IdGeneratorRepo__idGenerator;
    private String gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey;
    @Autowired(required=true)
    private ProxyHandler gorm_tools_repository_GormRepo__proxyHandler;
    private Class<Org> gorm_tools_repository_GormRepo__entityClass;
    private Boolean gorm_tools_repository_GormRepo__enableEvents;
    @Autowired(required=true)
    private RepoEventPublisher gorm_tools_repository_GormRepo__repoEventPublisher;
    @Autowired(required=true)
    private EntityMapBinder gorm_tools_repository_GormRepo__entityMapBinder;
    @Autowired(required=true)
    @Qualifier(value="mangoQuery")
    private MangoQuery gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery;
    private static final Logger gorm_tools_repository_bulk_BulkableRepo__log;
    @Autowired(required=true)
    private AsyncService gorm_tools_repository_bulk_BulkableRepo__asyncService;
    @Autowired(required=false)
    private SyncJobService gorm_tools_repository_bulk_BulkableRepo__syncJobService;
    @Autowired(required=true)
    private ProblemHandler gorm_tools_repository_bulk_BulkableRepo__problemHandler;
    @Autowired(required=true)
    @Qualifier(value="parallelTools")
    private ParallelTools gorm_tools_repository_bulk_BulkableRepo__parallelTools;
    @Autowired(required=true)
    private MetaMapEntityService gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public AbstractOrgRepo() {
        MetaClass metaClass;
        List list;
        this.toOneAssociations = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"flex", "info", "calc", "member"});
        this.metaClass = metaClass = this.$getStaticMetaClass();
        IdGeneratorRepo.Trait.Helper.$init$((IdGeneratorRepo)this);
        GormRepo.Trait.Helper.$init$((GormRepo)this);
        QueryMangoEntityApi.Trait.Helper.$init$((QueryMangoEntityApi)this);
        RepoEntityErrors.Trait.Helper.$init$((RepoEntityErrors)this);
        BulkableRepo.Trait.Helper.$init$((BulkableRepo)this);
    }

    @RepoListener
    public void beforeValidate(Org org, Errors errors) {
        if (org.isNew() && !this.validateNotNull((GormValidateable)org, "type", errors)) {
            return;
        }
    }

    @RepoListener
    public void beforeBind(Org org, Map data, BeforeBindEvent be) {
        if (be.isBindCreate()) {
            OrgType orgType = this.getOrgTypeFromData(data);
            org.setType(orgType);
            if (DefaultTypeTransformation.booleanUnbox(data.get("id"))) {
                Long l = (Long)ScriptBytecodeAdapter.asType(data.get("id"), Long.class);
                org.setId(l);
            } else {
                this.generateId((Persistable)org);
            }
        }
    }

    public void doBeforePersistWithData(Org org, PersistArgs args) {
        Object v;
        Map data = args.getData();
        if (ScriptBytecodeAdapter.compareEqual((Object)args.getBindAction(), (Object)BindAction.Create)) {
            this.verifyNumAndOrgSource(org, data);
            if (DefaultTypeTransformation.booleanUnbox(data.get("member"))) {
                this.orgMemberService.setupMember(org, (Map)ScriptBytecodeAdapter.asType(data.remove("member"), Map.class));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("location"))) {
            this.createOrUpdatePrimaryLocation(org, (Map)ScriptBytecodeAdapter.asType(data.get("location"), Map.class));
        }
        Object contactData = DefaultTypeTransformation.booleanUnbox(v = data.get("contact")) ? v : data.get("keyContact");
        if (DefaultTypeTransformation.booleanUnbox(contactData)) {
            this.createOrUpdatePrimaryContact(org, (Map)ScriptBytecodeAdapter.asType(contactData, Map.class));
        }
    }

    public void doAfterPersistWithData(Org org, PersistArgs args) {
        Map data = args.getData();
        if (DefaultTypeTransformation.booleanUnbox(data.get("locations"))) {
            this.persistManyList(org, Location.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("locations"), List.class));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("contacts"))) {
            this.persistManyList(org, Contact.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("contacts"), List.class));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("tags"))) {
            this.orgTagRepo.addOrRemove((Persistable)org, data.get("tags"));
        }
    }

    public void persistToOneAssociations(Org org, List<String> associations) {
        Contact contact;
        GormRepo.Trait.Helper.persistToOneAssociations((GormRepo)this, (Object)org, associations);
        Location location = org.getLocation();
        Boolean bl = location != null ? Boolean.valueOf(location.isNewOrDirty()) : null;
        if (bl == null ? false : bl) {
            org.getLocation().persist();
        }
        Boolean bl2 = (contact = org.getContact()) != null ? Boolean.valueOf(contact.isNewOrDirty()) : null;
        if (bl2 == null ? false : bl2) {
            org.getContact().persist();
        }
    }

    public void persistManyList(Org org, GormRepo assocRepo, List<Map> assocList) {
        Reference org2 = new Reference((Object)org);
        if (!DefaultTypeTransformation.booleanUnbox(assocList)) {
            return;
        }
        public final class _persistManyList_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference org;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _persistManyList_closure1(Object _outerInstance, Object _thisObject, Reference org) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.org = reference = org;
            }

            public Object doCall(Object it) {
                Long l = ((Org)this.org.get()).getId();
                ScriptBytecodeAdapter.invokeMethodN(_persistManyList_closure1.class, (Object)it, (String)"putAt", (Object[])new Object[]{"orgId", l});
                return l;
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _persistManyList_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(assocList, (Closure)new _persistManyList_closure1(this, this, org2));
        assocRepo.createOrUpdate(assocList);
    }

    @RepoListener
    public void beforeRemove(Org org, BeforeRemoveEvent e) {
        OrgSource orgSource = org.getSource();
        if (ScriptBytecodeAdapter.compareEqual((Object)(orgSource != null ? orgSource.getSourceType() : null), (Object)SourceType.ERP)) {
            LinkedHashMap args = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", new GStringImpl(new Object[]{org.getName(), SourceType.ERP}, new String[]{"Org: ", ", source:", ""})}), LinkedHashMap.class);
            throw (Throwable)ValidationProblem.of((String)"error.delete.externalSource", (Object)args).entity((Object)org).toException();
        }
        this.orgTagRepo.remove((Persistable)org);
        this.contactRepo.removeAll(org);
    }

    @RepoListener
    public void afterRemove(Org org, AfterRemoveEvent e) {
        Location.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
        Contact.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
        OrgSource.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
    }

    public boolean verifyNumAndOrgSource(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)org.getNum()) || !DefaultTypeTransformation.booleanUnbox((Object)((Object)org.getType()))) {
            return false;
        }
        OrgSource orgSource = OrgSource.getRepo().createSource(org, data);
        org.setSource(orgSource);
        return DefaultTypeTransformation.booleanUnbox((Object)org.getSource().persist());
    }

    public Contact createOrUpdatePrimaryContact(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Contact)ScriptBytecodeAdapter.castToType(null, Contact.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)org.getContact())) {
            Long cid = (Long)ScriptBytecodeAdapter.asType(data.get("id"), Long.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)cid) && ScriptBytecodeAdapter.compareNotEqual((Object)org.getContact().getId(), (Object)cid)) {
                Contact contact = Contact.get(cid);
                org.setContact(contact);
                return org.getContact();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)cid)) {
                Long l = org.getContact().getId();
                ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"id");
            }
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)data, (String)"isPrimary");
        Long l = org.getId();
        ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"orgId");
        Contact contact = this.contactRepo.createOrUpdate(data);
        org.setContact(contact);
        return org.getContact();
    }

    public Location createOrUpdatePrimaryLocation(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Location)ScriptBytecodeAdapter.castToType(null, Location.class);
        }
        Long l = org.getId();
        ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"orgId");
        Location location = this.locationRepo.createOrUpdate(data);
        org.setLocation(location);
        return org.getLocation();
    }

    public OrgType getOrgTypeFromData(Map data) {
        if (DefaultTypeTransformation.booleanUnbox(data.get("type"))) {
            return this.coerceOrgType(data.get("type"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("orgTypeId"))) {
            return OrgType.get((Long)ScriptBytecodeAdapter.asType(data.get("orgTypeId"), Long.class));
        }
        return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
    }

    public OrgType coerceOrgType(Object orgTypeObj) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)orgTypeObj)) {
            return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
        }
        if (orgTypeObj instanceof Map) {
            return OrgType.get((Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.asType((Object)orgTypeObj, Map.class)), (Object)"id"), Long.class));
        }
        if (orgTypeObj instanceof OrgType) {
            return (OrgType)((Object)ScriptBytecodeAdapter.asType((Object)orgTypeObj, OrgType.class));
        }
        if (orgTypeObj instanceof String) {
            return OrgType.get(orgTypeObj);
        }
        return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
    }

    public OrgSource createSource(Org org, SourceType sourceType) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)org.getId())) {
            this.generateId((Persistable)org);
        }
        return OrgSource.getRepo().createSource(org, sourceType);
    }

    public Org lookup(Map data) {
        Org org = null;
        Long oid = null;
        OrgType orgType = this.coerceOrgType(data.get("type"));
        if (DefaultTypeTransformation.booleanUnbox(data.get("org"))) {
            Object object = DefaultGroovyMethods.getAt(data.get("org"), (String)"source");
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)data, (String)"source");
            Object object2 = DefaultGroovyMethods.getAt(data.get("org"), (String)"sourceId");
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)data, (String)"sourceId");
        }
        if (data.get("source") == null && DefaultTypeTransformation.booleanUnbox(data.get("sourceId"))) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceId", data.get("sourceId")});
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)data, (String)"source");
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("source")) && DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(data.get("source"), (String)"sourceId"))) {
            Org org2;
            Map source = (Map)ScriptBytecodeAdapter.asType(data.get("source"), Map.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)orgType)) && DefaultTypeTransformation.booleanUnbox(source.get("orgType"))) {
                OrgType orgType2;
                orgType = orgType2 = OrgType.get(source.get("orgType"));
            }
            if (orgType != null) {
                Long l;
                oid = l = this.orgSourceRepo.findOrgIdBySourceIdAndOrgType((String)ScriptBytecodeAdapter.asType(source.get("sourceId"), String.class), orgType);
                if (DefaultTypeTransformation.booleanUnbox((Object)oid)) {
                    Org org3;
                    org = org3 = this.get(oid);
                }
            } else {
                List<Long> res = this.orgSourceRepo.findOrgIdBySourceId((String)ScriptBytecodeAdapter.asType(source.get("sourceId"), String.class));
                List<Long> list = res;
                if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                    Object object = DefaultGroovyMethods.getAt(res, (int)0);
                    oid = (Long)ScriptBytecodeAdapter.castToType((Object)object, Long.class);
                } else if (res.size() > 1) {
                    throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{source.get("sourceId")}, new String[]{"Multiple Orgs found for sourceId: ", ", lookup key must return a unique Org"})));
                }
            }
            org = org2 = this.get(oid);
        } else if (DefaultTypeTransformation.booleanUnbox(data.get("num"))) {
            String num = (String)ScriptBytecodeAdapter.asType(data.get("num"), String.class);
            List<Org> orgsForNum = orgType != null ? Org.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num, "type", orgType})) : Org.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num}));
            List<Org> list = orgsForNum;
            if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                Org org4;
                org = org4 = (Org)DefaultGroovyMethods.getAt(orgsForNum, (int)0);
            } else if (orgsForNum.size() > 1) {
                throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{data.get("num")}, new String[]{"Multiple Orgs found for num: ", ", lookup key must return a unique Org"})));
            }
        }
        return org;
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Ljava/lang/String;")
    public String getIdGeneratorKey() {
        return IdGeneratorRepo.Trait.Helper.getIdGeneratorKey((IdGeneratorRepo)this);
    }

    public /* synthetic */ String gorm_tools_repository_model_IdGeneratorRepotrait$super$getIdGeneratorKey() {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getIdGeneratorKey", (Object)new Object[0]));
        }
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getIdGeneratorKey"));
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Lgorm/tools/repository/events/RepoEventPublisher;)V")
    public void setRepoEventPublisher(RepoEventPublisher param1) {
        IdGeneratorRepo.Trait.Helper.setRepoEventPublisher((IdGeneratorRepo)this, (RepoEventPublisher)param1);
    }

    public /* synthetic */ void gorm_tools_repository_model_IdGeneratorRepotrait$super$setRepoEventPublisher(RepoEventPublisher param0) {
        GormRepo.Trait.Helper.setRepoEventPublisher((GormRepo)this, (RepoEventPublisher)param0);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setRepoEventPublisher(RepoEventPublisher param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setRepoEventPublisher", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setRepoEventPublisher", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Lgorm/tools/idgen/IdGenerator;)V")
    public void setIdGenerator(IdGenerator param1) {
        IdGeneratorRepo.Trait.Helper.setIdGenerator((IdGeneratorRepo)this, (IdGenerator)param1);
    }

    public /* synthetic */ void gorm_tools_repository_model_IdGeneratorRepotrait$super$setIdGenerator(IdGenerator param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setIdGenerator", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setIdGenerator", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Lgorm/tools/model/Persistable;)Ljava/lang/Long;")
    public Long generateId(Persistable param1) {
        return IdGeneratorRepo.Trait.Helper.generateId((IdGeneratorRepo)this, (Persistable)param1);
    }

    public /* synthetic */ Long gorm_tools_repository_model_IdGeneratorRepotrait$super$generateId(Persistable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"generateId", (Object)new Object[]{param0}), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"generateId", (Object[])new Object[]{param0}), Long.class);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Lgorm/tools/repository/events/RepoEventPublisher;")
    public RepoEventPublisher getRepoEventPublisher() {
        return IdGeneratorRepo.Trait.Helper.getRepoEventPublisher((IdGeneratorRepo)this);
    }

    public /* synthetic */ RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepotrait$super$getRepoEventPublisher() {
        return GormRepo.Trait.Helper.getRepoEventPublisher((GormRepo)this);
    }

    public /* synthetic */ RepoEventPublisher gorm_tools_repository_GormRepotrait$super$getRepoEventPublisher() {
        if (this instanceof GeneratedGroovyProxy) {
            return (RepoEventPublisher)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getRepoEventPublisher", (Object)new Object[0]), RepoEventPublisher.class);
        }
        return (RepoEventPublisher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getRepoEventPublisher"), RepoEventPublisher.class);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Lgorm/tools/idgen/IdGenerator;")
    public IdGenerator getIdGenerator() {
        return IdGeneratorRepo.Trait.Helper.getIdGenerator((IdGeneratorRepo)this);
    }

    public /* synthetic */ IdGenerator gorm_tools_repository_model_IdGeneratorRepotrait$super$getIdGenerator() {
        if (this instanceof GeneratedGroovyProxy) {
            return (IdGenerator)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getIdGenerator", (Object)new Object[0]), IdGenerator.class);
        }
        return (IdGenerator)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getIdGenerator"), IdGenerator.class);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Ljava/lang/String;)V")
    public void setIdGeneratorKey(String param1) {
        IdGeneratorRepo.Trait.Helper.setIdGeneratorKey((IdGeneratorRepo)this, (String)param1);
    }

    public /* synthetic */ void gorm_tools_repository_model_IdGeneratorRepotrait$super$setIdGeneratorKey(String param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setIdGeneratorKey", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setIdGeneratorKey", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doBeforePersist(Org param1, PersistArgs param2) {
        IdGeneratorRepo.Trait.Helper.doBeforePersist((IdGeneratorRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Ljava/lang/Long;")
    public Long generateId() {
        return IdGeneratorRepo.Trait.Helper.generateId((IdGeneratorRepo)this);
    }

    public /* synthetic */ Long gorm_tools_repository_model_IdGeneratorRepotrait$super$generateId() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"generateId", (Object)new Object[0]), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"generateId"), Long.class);
    }

    static {
        Logger logger;
        gorm_tools_repository_bulk_BulkableRepo__log = logger = BulkableRepo.Trait.Helper.$static$init$gorm_tools_repository_bulk_BulkableRepo__log(AbstractOrgRepo.class);
        IdGeneratorRepo.Trait.Helper.$static$init$(AbstractOrgRepo.class);
        GormRepo.Trait.Helper.$static$init$(AbstractOrgRepo.class);
        QueryMangoEntityApi.Trait.Helper.$static$init$(AbstractOrgRepo.class);
        RepoEntityErrors.Trait.Helper.$static$init$(AbstractOrgRepo.class);
        BulkableRepo.Trait.Helper.$static$init$(AbstractOrgRepo.class);
    }

    public RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher$get() {
        return this.gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher;
    }

    public IdGenerator gorm_tools_repository_model_IdGeneratorRepo__idGenerator$get() {
        return this.gorm_tools_repository_model_IdGeneratorRepo__idGenerator;
    }

    public String gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey$get() {
        return this.gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey;
    }

    public String gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey$set(String val) {
        String string;
        this.gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey = string = val;
        return string;
    }

    public RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher$set(RepoEventPublisher val) {
        RepoEventPublisher repoEventPublisher;
        this.gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher = repoEventPublisher = val;
        return repoEventPublisher;
    }

    public IdGenerator gorm_tools_repository_model_IdGeneratorRepo__idGenerator$set(IdGenerator val) {
        IdGenerator idGenerator;
        this.gorm_tools_repository_model_IdGeneratorRepo__idGenerator = idGenerator = val;
        return idGenerator;
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Z")
    public boolean validate(Org param1, PersistArgs param2) {
        return GormRepo.Trait.Helper.validate((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Org load(Serializable param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.load((GormRepo)this, (Serializable)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$load(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"load", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"load", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;)V")
    public void remove(Org param1, Map param2) {
        GormRepo.Trait.Helper.remove((GormRepo)this, (Object)param1, (Map)param2);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Org createOrUpdate(Map param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.createOrUpdate((GormRepo)this, (Map)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$createOrUpdate(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0}), Org.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Org update(Map param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.update((GormRepo)this, (Map)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$update(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"update", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"update", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org doPersist(Org param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.doPersist((GormRepo)this, (Object)param1, (PersistArgs)param2), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doAfterValidateBeforeSave(Org param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doAfterValidateBeforeSave((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lgorm/tools/databinding/EntityMapBinder;")
    public EntityMapBinder getEntityMapBinder() {
        return GormRepo.Trait.Helper.getEntityMapBinder((GormRepo)this);
    }

    public /* synthetic */ EntityMapBinder gorm_tools_repository_GormRepotrait$super$getEntityMapBinder() {
        if (this instanceof GeneratedGroovyProxy) {
            return (EntityMapBinder)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEntityMapBinder", (Object)new Object[0]), EntityMapBinder.class);
        }
        return (EntityMapBinder)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEntityMapBinder"), EntityMapBinder.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Class;)V")
    public void setEntityClass(Class<Org> param1) {
        GormRepo.Trait.Helper.setEntityClass((GormRepo)this, param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setEntityClass(Class<Org> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEntityClass", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEntityClass", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org doCreate(Map param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.doCreate((GormRepo)this, (Map)param1, (PersistArgs)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$doCreate(Map<Object, Object> param0, PersistArgs param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"doCreate", (Object[])new Object[]{this, param0, param1}), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_bulk_BulkableRepotrait$super$doCreate(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doCreate", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doCreate", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Z)Ljava/lang/Object;")
    public Org findWithData(Map param1, boolean param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.findWithData((GormRepo)this, (Map)param1, (boolean)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$findWithData(Map<Object, Object> param0, boolean param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"findWithData", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"findWithData", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)V")
    public void remove(Org param1) {
        GormRepo.Trait.Helper.remove((GormRepo)this, (Object)param1);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/gorm/GormStaticApi;")
    public GormStaticApi<Org> gormStaticApi() {
        return GormRepo.Trait.Helper.gormStaticApi((GormRepo)this);
    }

    public /* synthetic */ GormStaticApi<Org> gorm_tools_repository_GormRepotrait$super$gormStaticApi() {
        if (this instanceof GeneratedGroovyProxy) {
            return (GormStaticApi)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"gormStaticApi", (Object)new Object[0]), GormStaticApi.class);
        }
        return (GormStaticApi)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"gormStaticApi"), GormStaticApi.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgorm/tools/databinding/EntityMapBinder;)V")
    public void setEntityMapBinder(EntityMapBinder param1) {
        GormRepo.Trait.Helper.setEntityMapBinder((GormRepo)this, (EntityMapBinder)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setEntityMapBinder(EntityMapBinder param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEntityMapBinder", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEntityMapBinder", (Object[])new Object[]{param0});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;)V")
    public void bind(Org param1, Map param2, BindAction param3) {
        GormRepo.Trait.Helper.bind((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public Org entityTrx(Closure<Org> param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.entityTrx((GormRepo)this, param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$entityTrx(Closure<Org> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"entityTrx", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"entityTrx", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org createOrUpdate(Map param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.createOrUpdate((GormRepo)this, (Map)param1, (PersistArgs)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$createOrUpdate(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()V")
    public void clear() {
        GormRepo.Trait.Helper.clear((GormRepo)this);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$clear() {
        ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"clear", (Object[])new Object[]{this});
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$clear() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"clear", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"clear");
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;Lgorm/tools/repository/PersistArgs;)V")
    public void bindAndSave(Org param1, Map param2, BindAction param3, PersistArgs param4) {
        GormRepo.Trait.Helper.bindAndSave((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3, (PersistArgs)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;Ljava/lang/Long;)Ljava/lang/Object;")
    public Org get(Serializable param1, Long param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.get((GormRepo)this, (Serializable)param1, (Long)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$get(Serializable param0, Long param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"get", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"get", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/GormRepo;Ljava/util/List;Ljava/lang/String;)Ljava/util/List;")
    public List persistToManyData(Org param1, GormRepo param2, List<Map> param3, String param4) {
        return GormRepo.Trait.Helper.persistToManyData((GormRepo)this, (Object)param1, (GormRepo)param2, param3, (String)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Org read(Serializable param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.read((GormRepo)this, (Serializable)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$read(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"read", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"read", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()V")
    public void flushAndClear() {
        GormRepo.Trait.Helper.flushAndClear((GormRepo)this);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$flushAndClear() {
        ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"flushAndClear", (Object[])new Object[]{this});
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$flushAndClear() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"flushAndClear", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"flushAndClear");
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lgrails/core/support/proxy/ProxyHandler;")
    public ProxyHandler getProxyHandler() {
        return GormRepo.Trait.Helper.getProxyHandler((GormRepo)this);
    }

    public /* synthetic */ ProxyHandler gorm_tools_repository_GormRepotrait$super$getProxyHandler() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ProxyHandler)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getProxyHandler", (Object)new Object[0]), ProxyHandler.class);
        }
        return (ProxyHandler)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getProxyHandler"), ProxyHandler.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Ljava/lang/Boolean;")
    public Boolean getEnableEvents() {
        return GormRepo.Trait.Helper.getEnableEvents((GormRepo)this);
    }

    public /* synthetic */ Boolean gorm_tools_repository_GormRepotrait$super$getEnableEvents() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Boolean)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEnableEvents", (Object)new Object[0]), Boolean.class);
        }
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEnableEvents"), Boolean.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/gorm/GormValidationApi;")
    public GormValidationApi gormValidationApi() {
        return GormRepo.Trait.Helper.gormValidationApi((GormRepo)this);
    }

    public /* synthetic */ GormValidationApi<Org> gorm_tools_repository_GormRepotrait$super$gormValidationApi() {
        if (this instanceof GeneratedGroovyProxy) {
            return (GormValidationApi)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"gormValidationApi", (Object)new Object[0]), GormValidationApi.class);
        }
        return (GormValidationApi)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"gormValidationApi"), GormValidationApi.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/GormRepo;Ljava/util/List;)Ljava/util/List;")
    public List persistToManyData(Org param1, GormRepo param2, List<Map> param3) {
        return GormRepo.Trait.Helper.persistToManyData((GormRepo)this, (Object)param1, (GormRepo)param2, param3);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Org get(Serializable param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.get((GormRepo)this, (Serializable)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$get(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"get", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"get", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;Lgorm/tools/repository/PersistArgs;)V")
    public void doBind(Org param1, Map param2, BindAction param3, PersistArgs param4) {
        GormRepo.Trait.Helper.doBind((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3, (PersistArgs)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public Org entityReadOnlyTrx(Closure<Org> param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.entityReadOnlyTrx((GormRepo)this, param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$entityReadOnlyTrx(Closure<Org> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"entityReadOnlyTrx", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"entityReadOnlyTrx", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org create(Map param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.create((GormRepo)this, (Map)param1, (PersistArgs)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$create(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"create", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"create", (Object[])new Object[]{param0, param1}), Org.class);
    }

    public /* synthetic */ List<String> gorm_tools_repository_GormRepotrait$super$getToOneAssociations() {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getToOneAssociations", (Object)new Object[0]), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getToOneAssociations"), List.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)V")
    public void bindAndUpdate(Org param1, Map param2, PersistArgs param3) {
        GormRepo.Trait.Helper.bindAndUpdate((GormRepo)this, (Object)param1, (Map)param2, (PersistArgs)param3);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/List;)Ljava/util/List;")
    public List<Org> createOrUpdate(List<Map> param1) {
        return GormRepo.Trait.Helper.createOrUpdate((GormRepo)this, param1);
    }

    public /* synthetic */ List<Org> gorm_tools_repository_GormRepotrait$super$createOrUpdate(List<Map<Object, Object>> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0}), List.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Boolean;)V")
    public void setEnableEvents(Boolean param1) {
        GormRepo.Trait.Helper.setEnableEvents((GormRepo)this, (Boolean)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setEnableEvents(Boolean param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEnableEvents", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEnableEvents", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()V")
    public void flush() {
        GormRepo.Trait.Helper.flush((GormRepo)this);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$flush() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"flush", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"flush");
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Org findWithData(Map param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.findWithData((GormRepo)this, (Map)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$findWithData(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"findWithData", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"findWithData", (Object[])new Object[]{param0}), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$lookup(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"lookup", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"lookup", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Org getWithTrx(Serializable param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.getWithTrx((GormRepo)this, (Serializable)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$getWithTrx(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getWithTrx", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"getWithTrx", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doRemove(Org param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doRemove((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/gorm/GormInstanceApi;")
    public GormInstanceApi<Org> gormInstanceApi() {
        return GormRepo.Trait.Helper.gormInstanceApi((GormRepo)this);
    }

    public /* synthetic */ GormInstanceApi<Org> gorm_tools_repository_GormRepotrait$super$gormInstanceApi() {
        if (this instanceof GeneratedGroovyProxy) {
            return (GormInstanceApi)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"gormInstanceApi", (Object)new Object[0]), GormInstanceApi.class);
        }
        return (GormInstanceApi)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"gormInstanceApi"), GormInstanceApi.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)Ljava/lang/Object;")
    public Org gormSave(Org param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.gormSave((GormRepo)this, (Object)param1), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org doUpdate(Map param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.doUpdate((GormRepo)this, (Map)param1, (PersistArgs)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$doUpdate(Map<Object, Object> param0, PersistArgs param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"doUpdate", (Object[])new Object[]{this, param0, param1}), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_bulk_BulkableRepotrait$super$doUpdate(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doUpdate", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doUpdate", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Ljava/lang/Class;")
    public Class<Org> getEntityClass() {
        return GormRepo.Trait.Helper.getEntityClass((GormRepo)this);
    }

    public /* synthetic */ Class<Org> gorm_tools_repository_model_IdGeneratorRepotrait$super$getEntityClass() {
        return GormRepo.Trait.Helper.getEntityClass((GormRepo)this);
    }

    public /* synthetic */ Class<Org> gorm_tools_repository_GormRepotrait$super$getEntityClass() {
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, QueryMangoEntityApi.Trait.Helper.class, (String)"getEntityClass", (Object[])new Object[]{this}));
    }

    public /* synthetic */ Class<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$getEntityClass() {
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, RepoEntityErrors.Trait.Helper.class, (String)"getEntityClass", (Object[])new Object[]{this}));
    }

    public /* synthetic */ Class<Org> gorm_tools_repository_errors_RepoEntityErrorstrait$super$getEntityClass() {
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"getEntityClass", (Object[])new Object[]{this}));
    }

    public /* synthetic */ Class<Org> gorm_tools_repository_bulk_BulkableRepotrait$super$getEntityClass() {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToClass((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEntityClass", (Object)new Object[0]));
        }
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEntityClass"));
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doAfterPersist(Org param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doAfterPersist((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org gormSave(Org param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.gormSave((GormRepo)this, (Object)param1, (PersistArgs)param2), Org.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Org create(Map param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.create((GormRepo)this, (Map)param1), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$create(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"create", (Object)new Object[]{param0}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"create", (Object[])new Object[]{param0}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;)Ljava/lang/Object;")
    public Org persist(Org param1, Map param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.persist((GormRepo)this, (Object)param1, (Map)param2), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgrails/core/support/proxy/ProxyHandler;)V")
    public void setProxyHandler(ProxyHandler param1) {
        GormRepo.Trait.Helper.setProxyHandler((GormRepo)this, (ProxyHandler)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setProxyHandler(ProxyHandler param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setProxyHandler", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setProxyHandler", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)Z")
    public boolean isNewOrDirty(Org param1) {
        return GormRepo.Trait.Helper.isNewOrDirty((GormRepo)this, (Object)param1);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)V")
    public void removeById(Serializable param1) {
        GormRepo.Trait.Helper.removeById((GormRepo)this, (Serializable)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$removeById(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"removeById", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"removeById", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public <T> T withTrx(Closure<T> param1) {
        return (T)GormRepo.Trait.Helper.withTrx((GormRepo)this, param1);
    }

    public /* synthetic */ <T> T gorm_tools_repository_GormRepotrait$super$withTrx(Closure<T> param0) {
        return (T)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"withTrx", (Object[])new Object[]{this, param0});
    }

    public /* synthetic */ <T> T gorm_tools_repository_bulk_BulkableRepotrait$super$withTrx(Closure<T> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (T)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"withTrx", (Object)new Object[]{param0});
        }
        return (T)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"withTrx", (Object[])new Object[]{param0});
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Object;")
    public Org update(Map param1, Map param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.update((GormRepo)this, (Map)param1, (Map)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$update(Map<Object, Object> param0, Map<Object, Object> param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"update", (Object[])new Object[]{this, param0, param1}), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_bulk_BulkableRepotrait$super$update(Map<Object, Object> param0, Map<Object, Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"update", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"update", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/mapping/core/Datastore;")
    public Datastore getDatastore() {
        return GormRepo.Trait.Helper.getDatastore((GormRepo)this);
    }

    public /* synthetic */ Datastore gorm_tools_repository_GormRepotrait$super$getDatastore() {
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"getDatastore", (Object[])new Object[]{this}), Datastore.class);
    }

    public /* synthetic */ Datastore gorm_tools_repository_bulk_BulkableRepotrait$super$getDatastore() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getDatastore", (Object)new Object[0]), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getDatastore"), Datastore.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)V")
    public void bindAndCreate(Org param1, Map param2, PersistArgs param3) {
        GormRepo.Trait.Helper.bindAndCreate((GormRepo)this, (Object)param1, (Map)param2, (PersistArgs)param3);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)Ljava/lang/Object;")
    public Org persist(Org param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.persist((GormRepo)this, (Object)param1), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;Ljava/util/Map;)V")
    public void removeById(Serializable param1, Map param2) {
        GormRepo.Trait.Helper.removeById((GormRepo)this, (Serializable)param1, (Map)param2);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$removeById(Serializable param0, Map<Object, Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"removeById", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"removeById", (Object[])new Object[]{param0, param1});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public <T> T withNewTrx(Closure<T> param1) {
        return (T)GormRepo.Trait.Helper.withNewTrx((GormRepo)this, param1);
    }

    public /* synthetic */ <T> T gorm_tools_repository_GormRepotrait$super$withNewTrx(Closure<T> param0) {
        return (T)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"withNewTrx", (Object[])new Object[]{this, param0});
    }

    public /* synthetic */ <T> T gorm_tools_repository_bulk_BulkableRepotrait$super$withNewTrx(Closure<T> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (T)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"withNewTrx", (Object)new Object[]{param0});
        }
        return (T)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"withNewTrx", (Object[])new Object[]{param0});
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;Lgorm/tools/repository/PersistArgs;)V")
    public void bind(Org param1, Map param2, BindAction param3, PersistArgs param4) {
        GormRepo.Trait.Helper.bind((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3, (PersistArgs)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org update(Map param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.update((GormRepo)this, (Map)param1, (PersistArgs)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$update(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"update", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"update", (Object[])new Object[]{param0, param1}), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Org persist(Org param1, PersistArgs param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.persist((GormRepo)this, (Object)param1, (PersistArgs)param2), Org.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void validateAndSave(Org param1, PersistArgs param2) {
        GormRepo.Trait.Helper.validateAndSave((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Object;")
    public Org create(Map param1, Map param2) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.create((GormRepo)this, (Map)param1, (Map)param2), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_GormRepotrait$super$create(Map<Object, Object> param0, Map<Object, Object> param1) {
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(AbstractOrgRepo.class, BulkableRepo.Trait.Helper.class, (String)"create", (Object[])new Object[]{this, param0, param1}), Org.class);
    }

    public /* synthetic */ Org gorm_tools_repository_bulk_BulkableRepotrait$super$create(Map<Object, Object> param0, Map<Object, Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Org)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"create", (Object)new Object[]{param0, param1}), Org.class);
        }
        return (Org)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"create", (Object[])new Object[]{param0, param1}), Org.class);
    }

    public ProxyHandler gorm_tools_repository_GormRepo__proxyHandler$get() {
        return this.gorm_tools_repository_GormRepo__proxyHandler;
    }

    public Class<Org> gorm_tools_repository_GormRepo__entityClass$get() {
        return this.gorm_tools_repository_GormRepo__entityClass;
    }

    public Boolean gorm_tools_repository_GormRepo__enableEvents$get() {
        return this.gorm_tools_repository_GormRepo__enableEvents;
    }

    public RepoEventPublisher gorm_tools_repository_GormRepo__repoEventPublisher$get() {
        return this.gorm_tools_repository_GormRepo__repoEventPublisher;
    }

    public EntityMapBinder gorm_tools_repository_GormRepo__entityMapBinder$get() {
        return this.gorm_tools_repository_GormRepo__entityMapBinder;
    }

    public EntityMapBinder gorm_tools_repository_GormRepo__entityMapBinder$set(EntityMapBinder val) {
        EntityMapBinder entityMapBinder;
        this.gorm_tools_repository_GormRepo__entityMapBinder = entityMapBinder = val;
        return entityMapBinder;
    }

    public ProxyHandler gorm_tools_repository_GormRepo__proxyHandler$set(ProxyHandler val) {
        ProxyHandler proxyHandler;
        this.gorm_tools_repository_GormRepo__proxyHandler = proxyHandler = val;
        return proxyHandler;
    }

    public Class<Org> gorm_tools_repository_GormRepo__entityClass$set(Class<Org> val) {
        Class<Org> clazz = val;
        this.gorm_tools_repository_GormRepo__entityClass = clazz;
        return clazz;
    }

    public Boolean gorm_tools_repository_GormRepo__enableEvents$set(Boolean val) {
        Boolean bl;
        this.gorm_tools_repository_GormRepo__enableEvents = bl = val;
        return bl;
    }

    public RepoEventPublisher gorm_tools_repository_GormRepo__repoEventPublisher$set(RepoEventPublisher val) {
        RepoEventPublisher repoEventPublisher;
        this.gorm_tools_repository_GormRepo__repoEventPublisher = repoEventPublisher = val;
        return repoEventPublisher;
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgroovy/lang/Closure;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Org> query(@DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param1) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (Closure)param1);
    }

    public /* synthetic */ MangoDetachedCriteria<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(Closure<Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0}), MangoDetachedCriteria.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;)Ljava/util/List;")
    public List<Org> queryList(Map param1) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (Map)param1);
    }

    public /* synthetic */ List<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0}), List.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="()Ljava/util/List;")
    public List<Org> queryList() {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this);
    }

    public /* synthetic */ List<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList() {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[0]), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"queryList"), List.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Org> query(Map param1) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (Map)param1);
    }

    public /* synthetic */ MangoDetachedCriteria<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0}), MangoDetachedCriteria.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;Lgroovy/lang/Closure;)Ljava/util/List;")
    public List<Org> queryList(Map param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (Map)param1, (Closure)param2);
    }

    public /* synthetic */ List<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(Map<Object, Object> param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0, param1}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0, param1}), List.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Org> query(QueryArgs param1) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (QueryArgs)param1);
    }

    public /* synthetic */ MangoDetachedCriteria<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(QueryArgs param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0}), MangoDetachedCriteria.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/MangoQuery;)V")
    public void setMangoQuery(MangoQuery param1) {
        QueryMangoEntityApi.Trait.Helper.setMangoQuery((QueryMangoEntityApi)this, (MangoQuery)param1);
    }

    public /* synthetic */ void gorm_tools_mango_api_QueryMangoEntityApitrait$super$setMangoQuery(MangoQuery param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setMangoQuery", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setMangoQuery", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;Lgroovy/lang/Closure;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Org> query(QueryArgs param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (QueryArgs)param1, (Closure)param2);
    }

    public /* synthetic */ MangoDetachedCriteria<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(QueryArgs param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0, param1}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0, param1}), MangoDetachedCriteria.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="()Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Org> query() {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this);
    }

    public /* synthetic */ MangoDetachedCriteria<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[0]), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"query"), MangoDetachedCriteria.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;)Ljava/util/List;")
    public List<Org> queryList(QueryArgs param1) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (QueryArgs)param1);
    }

    public /* synthetic */ List<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(QueryArgs param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0}), List.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;Lgroovy/lang/Closure;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Org> query(Map param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (Map)param1, (Closure)param2);
    }

    public /* synthetic */ MangoDetachedCriteria<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(Map<Object, Object> param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0, param1}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0, param1}), MangoDetachedCriteria.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="()Lgorm/tools/mango/api/MangoQuery;")
    public MangoQuery getMangoQuery() {
        return QueryMangoEntityApi.Trait.Helper.getMangoQuery((QueryMangoEntityApi)this);
    }

    public /* synthetic */ MangoQuery gorm_tools_mango_api_QueryMangoEntityApitrait$super$getMangoQuery() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoQuery)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getMangoQuery", (Object)new Object[0]), MangoQuery.class);
        }
        return (MangoQuery)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getMangoQuery"), MangoQuery.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;Lgroovy/lang/Closure;)Ljava/util/List;")
    public List<Org> queryList(QueryArgs param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (QueryArgs)param1, (Closure)param2);
    }

    public /* synthetic */ List<Org> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(QueryArgs param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0, param1}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0, param1}), List.class);
    }

    public MangoQuery gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery$get() {
        return this.gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery;
    }

    public MangoQuery gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery$set(MangoQuery val) {
        MangoQuery mangoQuery;
        this.gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery = mangoQuery = val;
        return mangoQuery;
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;Lorg/springframework/validation/Errors;)Z")
    public boolean validateNotNull(GormValidateable param1, String param2, Errors param3) {
        return RepoEntityErrors.Trait.Helper.validateNotNull((RepoEntityErrors)this, (GormValidateable)param1, (String)param2, (Errors)param3);
    }

    public /* synthetic */ boolean gorm_tools_repository_errors_RepoEntityErrorstrait$super$validateNotNull(GormValidateable param0, String param1, Errors param2) {
        if (this instanceof GeneratedGroovyProxy) {
            return DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"validateNotNull", (Object)new Object[]{param0, param1, param2}));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"validateNotNull", (Object[])new Object[]{param0, param1, param2}));
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V")
    public void rejectValue(GormValidateable param1, String param2, Object param3, String param4) {
        RepoEntityErrors.Trait.Helper.rejectValue((RepoEntityErrors)this, (GormValidateable)param1, (String)param2, (Object)param3, (String)param4);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValue(GormValidateable param0, String param1, Object param2, String param3) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValue", (Object)new Object[]{param0, param1, param2, param3});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValue", (Object[])new Object[]{param0, param1, param2, param3});
        }
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Lorg/springframework/validation/Errors;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V")
    public void rejectValue(GormValidateable param1, Errors param2, String param3, Object param4, String param5, String param6, Object param7) {
        RepoEntityErrors.Trait.Helper.rejectValue((RepoEntityErrors)this, (GormValidateable)param1, (Errors)param2, (String)param3, (Object)param4, (String)param5, (String)param6, (Object)param7);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValue(GormValidateable param0, Errors param1, String param2, Object param3, String param4, String param5, Object param6) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValue", (Object)new Object[]{param0, param1, param2, param3, param4, param5, param6});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValue", (Object[])new Object[]{param0, param1, param2, param3, param4, param5, param6});
        }
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="()Lorg/springframework/context/MessageSource;")
    public MessageSource getMessageSource() {
        return RepoEntityErrors.Trait.Helper.getMessageSource((RepoEntityErrors)this);
    }

    public /* synthetic */ MessageSource gorm_tools_repository_errors_RepoEntityErrorstrait$super$getMessageSource() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MessageSource)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getMessageSource", (Object)new Object[0]), MessageSource.class);
        }
        return (MessageSource)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getMessageSource"), MessageSource.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;)V")
    public void rejectNullValue(GormValidateable param1, String param2) {
        RepoEntityErrors.Trait.Helper.rejectNullValue((RepoEntityErrors)this, (GormValidateable)param1, (String)param2);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectNullValue(GormValidateable param0, String param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectNullValue", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectNullValue", (Object[])new Object[]{param0, param1});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V")
    public void rejectValue(GormValidateable param1, String param2, Object param3, String param4, String param5) {
        RepoEntityErrors.Trait.Helper.rejectValue((RepoEntityErrors)this, (GormValidateable)param1, (String)param2, (Object)param3, (String)param4, (String)param5);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValue(GormValidateable param0, String param1, Object param2, String param3, String param4) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValue", (Object)new Object[]{param0, param1, param2, param3, param4});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValue", (Object[])new Object[]{param0, param1, param2, param3, param4});
        }
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Ljava/lang/String;)Ljava/lang/String;")
    public String getDefaultMessage(String param1) {
        return RepoEntityErrors.Trait.Helper.getDefaultMessage((RepoEntityErrors)this, (String)param1);
    }

    public /* synthetic */ String gorm_tools_repository_errors_RepoEntityErrorstrait$super$getDefaultMessage(String param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getDefaultMessage", (Object)new Object[]{param0}));
        }
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"getDefaultMessage", (Object[])new Object[]{param0}));
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Lorg/springframework/validation/Errors;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V")
    public void rejectValue(GormValidateable param1, Errors param2, String param3, Object param4, String param5) {
        RepoEntityErrors.Trait.Helper.rejectValue((RepoEntityErrors)this, (GormValidateable)param1, (Errors)param2, (String)param3, (Object)param4, (String)param5);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValue(GormValidateable param0, Errors param1, String param2, Object param3, String param4) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValue", (Object)new Object[]{param0, param1, param2, param3, param4});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValue", (Object[])new Object[]{param0, param1, param2, param3, param4});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Lorg/springframework/validation/Errors;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V")
    public void rejectValue(GormValidateable param1, Errors param2, String param3, Object param4, String param5, String param6) {
        RepoEntityErrors.Trait.Helper.rejectValue((RepoEntityErrors)this, (GormValidateable)param1, (Errors)param2, (String)param3, (Object)param4, (String)param5, (String)param6);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValue(GormValidateable param0, Errors param1, String param2, Object param3, String param4, String param5) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValue", (Object)new Object[]{param0, param1, param2, param3, param4, param5});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValue", (Object[])new Object[]{param0, param1, param2, param3, param4, param5});
        }
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;Lorg/springframework/validation/Errors;)V")
    public void rejectNullValue(GormValidateable param1, String param2, Errors param3) {
        RepoEntityErrors.Trait.Helper.rejectNullValue((RepoEntityErrors)this, (GormValidateable)param1, (String)param2, (Errors)param3);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectNullValue(GormValidateable param0, String param1, Errors param2) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectNullValue", (Object)new Object[]{param0, param1, param2});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectNullValue", (Object[])new Object[]{param0, param1, param2});
        }
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V")
    public void rejectValue(GormValidateable param1, String param2, Object param3, String param4, String param5, Object param6) {
        RepoEntityErrors.Trait.Helper.rejectValue((RepoEntityErrors)this, (GormValidateable)param1, (String)param2, (Object)param3, (String)param4, (String)param5, (Object)param6);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValue(GormValidateable param0, String param1, Object param2, String param3, String param4, Object param5) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValue", (Object)new Object[]{param0, param1, param2, param3, param4, param5});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValue", (Object[])new Object[]{param0, param1, param2, param3, param4, param5});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Lorg/springframework/validation/Errors;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V")
    public void rejectValueWithMessage(GormValidateable param1, Errors param2, String param3, Object param4, String param5, String param6) {
        RepoEntityErrors.Trait.Helper.rejectValueWithMessage((RepoEntityErrors)this, (GormValidateable)param1, (Errors)param2, (String)param3, (Object)param4, (String)param5, (String)param6);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValueWithMessage(GormValidateable param0, Errors param1, String param2, Object param3, String param4, String param5) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValueWithMessage", (Object)new Object[]{param0, param1, param2, param3, param4, param5});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValueWithMessage", (Object[])new Object[]{param0, param1, param2, param3, param4, param5});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Lorg/springframework/validation/Errors;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V")
    public void rejectValueWithMessage(GormValidateable param1, Errors param2, String param3, Object param4, String param5) {
        RepoEntityErrors.Trait.Helper.rejectValueWithMessage((RepoEntityErrors)this, (GormValidateable)param1, (Errors)param2, (String)param3, (Object)param4, (String)param5);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValueWithMessage(GormValidateable param0, Errors param1, String param2, Object param3, String param4) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValueWithMessage", (Object)new Object[]{param0, param1, param2, param3, param4});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValueWithMessage", (Object[])new Object[]{param0, param1, param2, param3, param4});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Ljava/lang/String;)Z")
    public boolean validateNotNull(GormValidateable param1, String param2) {
        return RepoEntityErrors.Trait.Helper.validateNotNull((RepoEntityErrors)this, (GormValidateable)param1, (String)param2);
    }

    public /* synthetic */ boolean gorm_tools_repository_errors_RepoEntityErrorstrait$super$validateNotNull(GormValidateable param0, String param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"validateNotNull", (Object)new Object[]{param0, param1}));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"validateNotNull", (Object[])new Object[]{param0, param1}));
    }

    @Traits.TraitBridge(traitClass=RepoEntityErrors.class, desc="(Lorg/grails/datastore/gorm/GormValidateable;Lorg/springframework/validation/Errors;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V")
    public void rejectValueWithMessage(GormValidateable param1, Errors param2, String param3, Object param4, String param5, String param6, Object param7) {
        RepoEntityErrors.Trait.Helper.rejectValueWithMessage((RepoEntityErrors)this, (GormValidateable)param1, (Errors)param2, (String)param3, (Object)param4, (String)param5, (String)param6, (Object)param7);
    }

    public /* synthetic */ void gorm_tools_repository_errors_RepoEntityErrorstrait$super$rejectValueWithMessage(GormValidateable param0, Errors param1, String param2, Object param3, String param4, String param5, Object param6) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"rejectValueWithMessage", (Object)new Object[]{param0, param1, param2, param3, param4, param5, param6});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"rejectValueWithMessage", (Object[])new Object[]{param0, param1, param2, param3, param4, param5, param6});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/async/AsyncService;)V")
    public void setAsyncService(AsyncService param1) {
        BulkableRepo.Trait.Helper.setAsyncService((BulkableRepo)this, (AsyncService)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setAsyncService(AsyncService param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setAsyncService", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setAsyncService", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/job/SyncJobContext;)Ljava/util/Map;")
    public Map buildSuccessMap(Org param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.buildSuccessMap((BulkableRepo)this, (Object)param1, (SyncJobContext)param2);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobContext;Z)Lyakworks/api/ApiResults;")
    public ApiResults doBulk(List<Map> param1, SyncJobContext param2, boolean param3) {
        return BulkableRepo.Trait.Helper.doBulk((BulkableRepo)this, param1, (SyncJobContext)param2, (boolean)param3);
    }

    public /* synthetic */ ApiResults gorm_tools_repository_bulk_BulkableRepotrait$super$doBulk(List<Map<Object, Object>> param0, SyncJobContext param1, boolean param2) {
        if (this instanceof GeneratedGroovyProxy) {
            return (ApiResults)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doBulk", (Object)new Object[]{param0, param1, param2}), ApiResults.class);
        }
        return (ApiResults)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doBulk", (Object[])new Object[]{param0, param1, param2}), ApiResults.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobService;)V")
    public void setSyncJobService(SyncJobService param1) {
        BulkableRepo.Trait.Helper.setSyncJobService((BulkableRepo)this, (SyncJobService)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setSyncJobService(SyncJobService<Org> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setSyncJobService", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setSyncJobService", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/Map;Lgorm/tools/job/SyncJobContext;)Ljava/util/Map;")
    public Map buildErrorMap(Map param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.buildErrorMap((BulkableRepo)this, (Map)param1, (SyncJobContext)param2);
    }

    public /* synthetic */ Map<Object, Object> gorm_tools_repository_bulk_BulkableRepotrait$super$buildErrorMap(Map<Object, Object> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"buildErrorMap", (Object)new Object[]{param0, param1}), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"buildErrorMap", (Object[])new Object[]{param0, param1}), Map.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobContext;ZZLjava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/util/Map;")
    public Map createOrUpdate(SyncJobContext param1, boolean param2, boolean param3, Map param4, PersistArgs param5) {
        return BulkableRepo.Trait.Helper.createOrUpdate((BulkableRepo)this, (SyncJobContext)param1, (boolean)param2, (boolean)param3, (Map)param4, (PersistArgs)param5);
    }

    public /* synthetic */ Map<Object, Object> gorm_tools_repository_bulk_BulkableRepotrait$super$createOrUpdate(SyncJobContext param0, boolean param1, boolean param2, Map<Object, Object> param3, PersistArgs param4) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0, param1, param2, param3, param4}), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0, param1, param2, param3, param4}), Map.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/function/Supplier;Lgorm/tools/job/SyncJobContext;)Ljava/lang/Long;")
    public Long bulk(Supplier param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.bulk((BulkableRepo)this, (Supplier)param1, (SyncJobContext)param2);
    }

    public /* synthetic */ Long gorm_tools_repository_bulk_BulkableRepotrait$super$bulk(Supplier<Object> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"bulk", (Object)new Object[]{param0, param1}), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"bulk", (Object[])new Object[]{param0, param1}), Long.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobContext;Lyakworks/api/ApiResults;Ljava/lang/Long;)V")
    public void updateJobResults(SyncJobContext param1, ApiResults param2, Long param3) {
        BulkableRepo.Trait.Helper.updateJobResults((BulkableRepo)this, (SyncJobContext)param1, (ApiResults)param2, (Long)param3);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$updateJobResults(SyncJobContext param0, ApiResults param1, Long param2) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"updateJobResults", (Object)new Object[]{param0, param1, param2});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"updateJobResults", (Object[])new Object[]{param0, param1, param2});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/problem/ProblemHandler;)V")
    public void setProblemHandler(ProblemHandler param1) {
        BulkableRepo.Trait.Helper.setProblemHandler((BulkableRepo)this, (ProblemHandler)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setProblemHandler(ProblemHandler param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setProblemHandler", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setProblemHandler", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/job/SyncJobService;")
    public SyncJobService getSyncJobService() {
        return BulkableRepo.Trait.Helper.getSyncJobService((BulkableRepo)this);
    }

    public /* synthetic */ SyncJobService<Org> gorm_tools_repository_bulk_BulkableRepotrait$super$getSyncJobService() {
        if (this instanceof GeneratedGroovyProxy) {
            return (SyncJobService)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getSyncJobService", (Object)new Object[0]), SyncJobService.class);
        }
        return (SyncJobService)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getSyncJobService"), SyncJobService.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobContext;)Lyakworks/api/ApiResults;")
    public ApiResults doBulk(List<Map> param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.doBulk((BulkableRepo)this, param1, (SyncJobContext)param2);
    }

    public /* synthetic */ ApiResults gorm_tools_repository_bulk_BulkableRepotrait$super$doBulk(List<Map<Object, Object>> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (ApiResults)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doBulk", (Object)new Object[]{param0, param1}), ApiResults.class);
        }
        return (ApiResults)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doBulk", (Object[])new Object[]{param0, param1}), ApiResults.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/async/AsyncService;")
    public AsyncService getAsyncService() {
        return BulkableRepo.Trait.Helper.getAsyncService((BulkableRepo)this);
    }

    public /* synthetic */ AsyncService gorm_tools_repository_bulk_BulkableRepotrait$super$getAsyncService() {
        if (this instanceof GeneratedGroovyProxy) {
            return (AsyncService)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getAsyncService", (Object)new Object[0]), AsyncService.class);
        }
        return (AsyncService)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getAsyncService"), AsyncService.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/job/SyncJobContext;)Ljava/util/Map;")
    public Map createMetaMap(Org param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.createMetaMap((BulkableRepo)this, (Object)param1, (SyncJobContext)param2);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobArgs;)Ljava/lang/Long;")
    public Long bulk(List<Map> param1, SyncJobArgs param2) {
        return BulkableRepo.Trait.Helper.bulk((BulkableRepo)this, param1, (SyncJobArgs)param2);
    }

    public /* synthetic */ Long gorm_tools_repository_bulk_BulkableRepotrait$super$bulk(List<Map<Object, Object>> param0, SyncJobArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"bulk", (Object)new Object[]{param0, param1}), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"bulk", (Object[])new Object[]{param0, param1}), Long.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/async/ParallelTools;)V")
    public void setParallelTools(ParallelTools param1) {
        BulkableRepo.Trait.Helper.setParallelTools((BulkableRepo)this, (ParallelTools)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setParallelTools(ParallelTools param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setParallelTools", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setParallelTools", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/beans/map/MetaMapEntityService;)V")
    public void setMetaMapEntityService(MetaMapEntityService param1) {
        BulkableRepo.Trait.Helper.setMetaMapEntityService((BulkableRepo)this, (MetaMapEntityService)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setMetaMapEntityService(MetaMapEntityService param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setMetaMapEntityService", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setMetaMapEntityService", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/async/ParallelTools;")
    public ParallelTools getParallelTools() {
        return BulkableRepo.Trait.Helper.getParallelTools((BulkableRepo)this);
    }

    public /* synthetic */ ParallelTools gorm_tools_repository_bulk_BulkableRepotrait$super$getParallelTools() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ParallelTools)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParallelTools", (Object)new Object[0]), ParallelTools.class);
        }
        return (ParallelTools)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParallelTools"), ParallelTools.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobContext;)V")
    public void doBulkParallel(List<Map> param1, SyncJobContext param2) {
        BulkableRepo.Trait.Helper.doBulkParallel((BulkableRepo)this, param1, (SyncJobContext)param2);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$doBulkParallel(List<Map<Object, Object>> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doBulkParallel", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doBulkParallel", (Object[])new Object[]{param0, param1});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/problem/ProblemHandler;")
    public ProblemHandler getProblemHandler() {
        return BulkableRepo.Trait.Helper.getProblemHandler((BulkableRepo)this);
    }

    public /* synthetic */ ProblemHandler gorm_tools_repository_bulk_BulkableRepotrait$super$getProblemHandler() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ProblemHandler)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getProblemHandler", (Object)new Object[0]), ProblemHandler.class);
        }
        return (ProblemHandler)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getProblemHandler"), ProblemHandler.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/beans/map/MetaMapEntityService;")
    public MetaMapEntityService getMetaMapEntityService() {
        return BulkableRepo.Trait.Helper.getMetaMapEntityService((BulkableRepo)this);
    }

    public /* synthetic */ MetaMapEntityService gorm_tools_repository_bulk_BulkableRepotrait$super$getMetaMapEntityService() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MetaMapEntityService)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getMetaMapEntityService", (Object)new Object[0]), MetaMapEntityService.class);
        }
        return (MetaMapEntityService)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getMetaMapEntityService"), MetaMapEntityService.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobContext;Lyakworks/api/ApiResults;)V")
    public void updateJobResults(SyncJobContext param1, ApiResults param2) {
        BulkableRepo.Trait.Helper.updateJobResults((BulkableRepo)this, (SyncJobContext)param1, (ApiResults)param2);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$updateJobResults(SyncJobContext param0, ApiResults param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"updateJobResults", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"updateJobResults", (Object[])new Object[]{param0, param1});
        }
    }

    public static Logger gorm_tools_repository_bulk_BulkableRepo__log$get() {
        return gorm_tools_repository_bulk_BulkableRepo__log;
    }

    public AsyncService gorm_tools_repository_bulk_BulkableRepo__asyncService$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__asyncService;
    }

    public SyncJobService gorm_tools_repository_bulk_BulkableRepo__syncJobService$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__syncJobService;
    }

    public ProblemHandler gorm_tools_repository_bulk_BulkableRepo__problemHandler$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__problemHandler;
    }

    public ParallelTools gorm_tools_repository_bulk_BulkableRepo__parallelTools$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__parallelTools;
    }

    public MetaMapEntityService gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService;
    }

    public ParallelTools gorm_tools_repository_bulk_BulkableRepo__parallelTools$set(ParallelTools val) {
        ParallelTools parallelTools;
        this.gorm_tools_repository_bulk_BulkableRepo__parallelTools = parallelTools = val;
        return parallelTools;
    }

    public MetaMapEntityService gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService$set(MetaMapEntityService val) {
        MetaMapEntityService metaMapEntityService;
        this.gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService = metaMapEntityService = val;
        return metaMapEntityService;
    }

    public ProblemHandler gorm_tools_repository_bulk_BulkableRepo__problemHandler$set(ProblemHandler val) {
        ProblemHandler problemHandler;
        this.gorm_tools_repository_bulk_BulkableRepo__problemHandler = problemHandler = val;
        return problemHandler;
    }

    public AsyncService gorm_tools_repository_bulk_BulkableRepo__asyncService$set(AsyncService val) {
        AsyncService asyncService;
        this.gorm_tools_repository_bulk_BulkableRepo__asyncService = asyncService = val;
        return asyncService;
    }

    public SyncJobService gorm_tools_repository_bulk_BulkableRepo__syncJobService$set(SyncJobService val) {
        SyncJobService syncJobService;
        this.gorm_tools_repository_bulk_BulkableRepo__syncJobService = syncJobService = val;
        return syncJobService;
    }

    public static Logger gorm_tools_repository_bulk_BulkableRepo__log$set(Logger val) {
        return null;
    }

    @Generated
    public OrgSource createSource(Org org) {
        return this.createSource(org, SourceType.App);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractOrgRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public LocationRepo getLocationRepo() {
        return this.locationRepo;
    }

    @Generated
    public void setLocationRepo(LocationRepo locationRepo) {
        this.locationRepo = locationRepo;
    }

    @Generated
    public ContactRepo getContactRepo() {
        return this.contactRepo;
    }

    @Generated
    public void setContactRepo(ContactRepo contactRepo) {
        this.contactRepo = contactRepo;
    }

    @Generated
    public OrgTagRepo getOrgTagRepo() {
        return this.orgTagRepo;
    }

    @Generated
    public void setOrgTagRepo(OrgTagRepo orgTagRepo) {
        this.orgTagRepo = orgTagRepo;
    }

    @Generated
    public OrgSourceRepo getOrgSourceRepo() {
        return this.orgSourceRepo;
    }

    @Generated
    public void setOrgSourceRepo(OrgSourceRepo orgSourceRepo) {
        this.orgSourceRepo = orgSourceRepo;
    }

    @Generated
    public OrgMemberService getOrgMemberService() {
        return this.orgMemberService;
    }

    @Generated
    public void setOrgMemberService(OrgMemberService orgMemberService) {
        this.orgMemberService = orgMemberService;
    }

    @Generated
    public List<String> getToOneAssociations() {
        return this.toOneAssociations;
    }

    @Generated
    public void setToOneAssociations(List<String> list) {
        this.toOneAssociations = list;
    }
}

